export interface KubernetesConnection {
    namespace: string;
    host: string;
    token: string;
    insecurelyDisableTlsCertificateValidation: boolean;
}
export declare const EMPTY_KUBERNETES_CONNECTION: {
    namespace: string;
    host: string;
    token: string;
    insecurelyDisableTlsCertificateValidation: boolean;
};
export declare enum KubernetesConnectionStatus {
    CONNECTED = "CONNECTED",
    ERROR = "ERROR",
    MISSING_PERMISSIONS = "MISSING_PERMISSIONS",
    NAMESPACE_NOT_FOUND = "NAMESPACE_NOT_FOUND"
}
export declare const isKubernetesConnectionValid: (connection: KubernetesConnection) => boolean;
export declare const isNamespaceValid: (namespace: string) => boolean;
export declare const isTokenValid: (token: string) => boolean;
export declare const isHostValid: (host: string) => boolean;
//# sourceMappingURL=KubernetesConnection.d.ts.map