import { HttpMethod } from "../../fetch/FetchConstants";
import { CreateResourceFetchArgs, ResourceFetch, ResourceFetchArgs, UniqueResourceFetchArgs } from "../../fetch/ResourceFetch";
import { IDeployment, IDeploymentCondition } from "kubernetes-models/apps/v1";
import { EnvVar, ResourceDataSource, ResourceGroupDescriptor, ResourceMetadataEnforcer } from "../common";
import { IContainer } from "kubernetes-models/v1";
export declare type CreateDeploymentTemplateArgs = {
    uri: string;
    baseUrl: string;
    workspaceName: string;
    containerImageUrl: string;
    envVars: EnvVar[];
    resourceDataSource: ResourceDataSource.TEMPLATE;
    imagePullPolicy?: IContainer["imagePullPolicy"];
};
export declare type CreateDeploymentArgs = CreateResourceFetchArgs & (CreateDeploymentTemplateArgs | {
    descriptor: DeploymentDescriptor;
    resourceDataSource: ResourceDataSource.PROVIDED;
});
export declare type DeploymentDescriptor = IDeployment & ResourceMetadataEnforcer;
export declare type DeploymentGroupDescriptor = ResourceGroupDescriptor<DeploymentDescriptor>;
export declare type DeploymentCondition = IDeploymentCondition;
export declare const DEPLOYMENT_TEMPLATE: (args: CreateResourceFetchArgs & CreateDeploymentTemplateArgs) => DeploymentDescriptor;
export declare class CreateDeployment extends ResourceFetch {
    protected args: CreateDeploymentArgs;
    constructor(args: CreateDeploymentArgs);
    method(): HttpMethod;
    body(): string;
    endpoint(): string;
}
export declare class ListDeployments extends ResourceFetch {
    protected args: ResourceFetchArgs & {
        labelSelector?: string;
    };
    constructor(args: ResourceFetchArgs & {
        labelSelector?: string;
    });
    method(): HttpMethod;
    endpoint(): string;
}
export declare class DeleteDeployment extends ResourceFetch {
    protected args: UniqueResourceFetchArgs;
    constructor(args: UniqueResourceFetchArgs);
    method(): HttpMethod;
    body(): string;
    endpoint(): string;
}
export declare class GetDeployment extends ResourceFetch {
    protected args: UniqueResourceFetchArgs;
    constructor(args: UniqueResourceFetchArgs);
    method(): HttpMethod;
    endpoint(): string;
}
export declare class UpdateDeployment extends ResourceFetch {
    protected args: UniqueResourceFetchArgs & {
        descriptor: DeploymentDescriptor;
    };
    constructor(args: UniqueResourceFetchArgs & {
        descriptor: DeploymentDescriptor;
    });
    method(): HttpMethod;
    body(): string;
    endpoint(): string;
}
//# sourceMappingURL=Deployment.d.ts.map