"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceFetcher = void 0;
var FetchConstants_1 = require("./FetchConstants");
var ResourceFetcher = (function () {
    function ResourceFetcher(args) {
        this.args = args;
    }
    ResourceFetcher.prototype.execute = function (args) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            var targetUrl, urlToFetch, headers, error, response, e_1, _b, _c, resource, e_2_1;
            var _d, e_2, _e;
            return __generator(this, function (_f) {
                switch (_f.label) {
                    case 0:
                        targetUrl = "".concat(this.args.connection.host).concat(args.target.endpoint());
                        urlToFetch = (_a = this.args.proxyUrl) !== null && _a !== void 0 ? _a : targetUrl;
                        headers = (_d = {},
                            _d[FetchConstants_1.HeaderKeys.AUTHORIZATION] = "Bearer ".concat(this.args.connection.token),
                            _d[FetchConstants_1.HeaderKeys.ACCEPT] = FetchConstants_1.ContentTypes.APPLICATION_JSON,
                            _d[FetchConstants_1.HeaderKeys.CONTENT_TYPE] = args.target.contentType(),
                            _d);
                        if (this.args.proxyUrl) {
                            headers[FetchConstants_1.HeaderKeys.TARGET_URL] = targetUrl;
                            if (this.args.connection.insecurelyDisableTlsCertificateValidation) {
                                headers[FetchConstants_1.HeaderKeys.INSECURELY_DISABLE_TLS_CERTIFICATE_VALIDATION] = "true";
                            }
                        }
                        _f.label = 1;
                    case 1:
                        _f.trys.push([1, 6, , 7]);
                        return [4, fetch(urlToFetch, {
                                method: args.target.method(),
                                body: args.target.body(),
                                headers: headers,
                            })];
                    case 2:
                        response = _f.sent();
                        if (!response.ok) return [3, 4];
                        return [4, response.json()];
                    case 3: return [2, (_f.sent())];
                    case 4:
                        error = {
                            status: response.status,
                            statusText: response.statusText,
                        };
                        _f.label = 5;
                    case 5: return [3, 7];
                    case 6:
                        e_1 = _f.sent();
                        return [3, 7];
                    case 7:
                        if (!(args.rollbacks && args.rollbacks.length > 0)) return [3, 15];
                        _f.label = 8;
                    case 8:
                        _f.trys.push([8, 13, 14, 15]);
                        _b = __values(args.rollbacks), _c = _b.next();
                        _f.label = 9;
                    case 9:
                        if (!!_c.done) return [3, 12];
                        resource = _c.value;
                        return [4, this.execute({ target: resource })];
                    case 10:
                        _f.sent();
                        _f.label = 11;
                    case 11:
                        _c = _b.next();
                        return [3, 9];
                    case 12: return [3, 15];
                    case 13:
                        e_2_1 = _f.sent();
                        e_2 = { error: e_2_1 };
                        return [3, 15];
                    case 14:
                        try {
                            if (_c && !_c.done && (_e = _b.return)) _e.call(_b);
                        }
                        finally { if (e_2) throw e_2.error; }
                        return [7];
                    case 15: throw new Error("Error fetching ".concat(args.target.name()), { cause: error });
                }
            });
        });
    };
    return ResourceFetcher;
}());
exports.ResourceFetcher = ResourceFetcher;
//# sourceMappingURL=ResourceFetcher.js.map