"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.meta = exports.elements = exports.subs = exports.ns = exports.root = void 0;
exports.root = {
    element: "definitions",
    type: "BPMN20__tDefinitions"
};
exports.ns = new Map([
    ["http://www.omg.org/spec/BPMN/20100524/MODEL", ""],
    ["", "http://www.omg.org/spec/BPMN/20100524/MODEL"],
    ["http://www.omg.org/spec/BPMN/20100524/DI", "bpmndi:"],
    ["bpmndi:", "http://www.omg.org/spec/BPMN/20100524/DI"],
    ["http://www.omg.org/spec/DD/20100524/DC", "dc:"],
    ["dc:", "http://www.omg.org/spec/DD/20100524/DC"],
    ["http://www.omg.org/spec/DD/20100524/DI", "di:"],
    ["di:", "http://www.omg.org/spec/DD/20100524/DI"],
]);
exports.subs = {
    "": {
        "adHocSubProcess": "flowElement",
        "boundaryEvent": "flowElement",
        "businessRuleTask": "flowElement",
        "callActivity": "flowElement",
        "callChoreography": "flowElement",
        "choreographyTask": "flowElement",
        "complexGateway": "flowElement",
        "dataObject": "flowElement",
        "dataObjectReference": "flowElement",
        "dataStoreReference": "flowElement",
        "endEvent": "flowElement",
        "event": "flowElement",
        "eventBasedGateway": "flowElement",
        "exclusiveGateway": "flowElement",
        "implicitThrowEvent": "flowElement",
        "inclusiveGateway": "flowElement",
        "intermediateCatchEvent": "flowElement",
        "intermediateThrowEvent": "flowElement",
        "manualTask": "flowElement",
        "parallelGateway": "flowElement",
        "receiveTask": "flowElement",
        "scriptTask": "flowElement",
        "sendTask": "flowElement",
        "sequenceFlow": "flowElement",
        "serviceTask": "flowElement",
        "startEvent": "flowElement",
        "subChoreography": "flowElement",
        "subProcess": "flowElement",
        "task": "flowElement",
        "transaction": "flowElement",
        "userTask": "flowElement",
        "association": "artifact",
        "group": "artifact",
        "textAnnotation": "artifact",
        "callConversation": "conversationNode",
        "conversation": "conversationNode",
        "subConversation": "conversationNode",
        "cancelEventDefinition": "eventDefinition",
        "compensateEventDefinition": "eventDefinition",
        "conditionalEventDefinition": "eventDefinition",
        "errorEventDefinition": "eventDefinition",
        "escalationEventDefinition": "eventDefinition",
        "linkEventDefinition": "eventDefinition",
        "messageEventDefinition": "eventDefinition",
        "signalEventDefinition": "eventDefinition",
        "terminateEventDefinition": "eventDefinition",
        "timerEventDefinition": "eventDefinition",
        "category": "rootElement",
        "collaboration": "rootElement",
        "correlationProperty": "rootElement",
        "dataStore": "rootElement",
        "endPoint": "rootElement",
        "error": "rootElement",
        "escalation": "rootElement",
        "eventDefinition": "rootElement",
        "globalBusinessRuleTask": "rootElement",
        "globalManualTask": "rootElement",
        "globalScriptTask": "rootElement",
        "globalTask": "rootElement",
        "globalUserTask": "rootElement",
        "interface": "rootElement",
        "itemDefinition": "rootElement",
        "message": "rootElement",
        "partnerEntity": "rootElement",
        "partnerRole": "rootElement",
        "process": "rootElement",
        "resource": "rootElement",
        "signal": "rootElement",
        "choreography": "collaboration",
        "globalConversation": "collaboration",
        "formalExpression": "expression",
        "globalChoreographyTask": "choreography",
        "humanPerformer": "performer",
        "potentialOwner": "performer",
        "multiInstanceLoopCharacteristics": "loopCharacteristics",
        "standardLoopCharacteristics": "loopCharacteristics",
        "performer": "resourceRole",
    },
    "bpmndi:": {
        "bpmndi:BPMNShape": "di:DiagramElement",
        "bpmndi:BPMNEdge": "di:DiagramElement",
    },
    "dc:": {},
    "di:": {},
};
exports.elements = {
    "definitions": "BPMN20__tDefinitions",
    "import": "BPMN20__tImport",
    "activity": "BPMN20__tActivity",
    "adHocSubProcess": "BPMN20__tAdHocSubProcess",
    "artifact": "BPMN20__tArtifact",
    "assignment": "BPMN20__tAssignment",
    "association": "BPMN20__tAssociation",
    "auditing": "BPMN20__tAuditing",
    "baseElement": "BPMN20__tBaseElement",
    "baseElementWithMixedContent": "BPMN20__tBaseElementWithMixedContent",
    "boundaryEvent": "BPMN20__tBoundaryEvent",
    "businessRuleTask": "BPMN20__tBusinessRuleTask",
    "callableElement": "BPMN20__tCallableElement",
    "callActivity": "BPMN20__tCallActivity",
    "callChoreography": "BPMN20__tCallChoreography",
    "callConversation": "BPMN20__tCallConversation",
    "cancelEventDefinition": "BPMN20__tCancelEventDefinition",
    "catchEvent": "BPMN20__tCatchEvent",
    "category": "BPMN20__tCategory",
    "categoryValue": "BPMN20__tCategoryValue",
    "choreography": "BPMN20__tChoreography",
    "choreographyActivity": "BPMN20__tChoreographyActivity",
    "choreographyTask": "BPMN20__tChoreographyTask",
    "collaboration": "BPMN20__tCollaboration",
    "compensateEventDefinition": "BPMN20__tCompensateEventDefinition",
    "complexBehaviorDefinition": "BPMN20__tComplexBehaviorDefinition",
    "complexGateway": "BPMN20__tComplexGateway",
    "conditionalEventDefinition": "BPMN20__tConditionalEventDefinition",
    "conversation": "BPMN20__tConversation",
    "conversationAssociation": "BPMN20__tConversationAssociation",
    "conversationLink": "BPMN20__tConversationLink",
    "conversationNode": "BPMN20__tConversationNode",
    "correlationKey": "BPMN20__tCorrelationKey",
    "correlationProperty": "BPMN20__tCorrelationProperty",
    "correlationPropertyBinding": "BPMN20__tCorrelationPropertyBinding",
    "correlationPropertyRetrievalExpression": "BPMN20__tCorrelationPropertyRetrievalExpression",
    "correlationSubscription": "BPMN20__tCorrelationSubscription",
    "dataAssociation": "BPMN20__tDataAssociation",
    "dataInput": "BPMN20__tDataInput",
    "dataInputAssociation": "BPMN20__tDataInputAssociation",
    "dataObject": "BPMN20__tDataObject",
    "dataObjectReference": "BPMN20__tDataObjectReference",
    "dataOutput": "BPMN20__tDataOutput",
    "dataOutputAssociation": "BPMN20__tDataOutputAssociation",
    "dataState": "BPMN20__tDataState",
    "dataStore": "BPMN20__tDataStore",
    "dataStoreReference": "BPMN20__tDataStoreReference",
    "documentation": "BPMN20__tDocumentation",
    "endEvent": "BPMN20__tEndEvent",
    "endPoint": "BPMN20__tEndPoint",
    "error": "BPMN20__tError",
    "errorEventDefinition": "BPMN20__tErrorEventDefinition",
    "escalation": "BPMN20__tEscalation",
    "escalationEventDefinition": "BPMN20__tEscalationEventDefinition",
    "event": "BPMN20__tEvent",
    "eventBasedGateway": "BPMN20__tEventBasedGateway",
    "eventDefinition": "BPMN20__tEventDefinition",
    "exclusiveGateway": "BPMN20__tExclusiveGateway",
    "expression": "BPMN20__tExpression",
    "extension": "BPMN20__tExtension",
    "extensionElements": "BPMN20__tExtensionElements",
    "flowElement": "BPMN20__tFlowElement",
    "flowNode": "BPMN20__tFlowNode",
    "formalExpression": "BPMN20__tFormalExpression",
    "gateway": "BPMN20__tGateway",
    "globalBusinessRuleTask": "BPMN20__tGlobalBusinessRuleTask",
    "globalChoreographyTask": "BPMN20__tGlobalChoreographyTask",
    "globalConversation": "BPMN20__tGlobalConversation",
    "globalManualTask": "BPMN20__tGlobalManualTask",
    "globalScriptTask": "BPMN20__tGlobalScriptTask",
    "globalTask": "BPMN20__tGlobalTask",
    "globalUserTask": "BPMN20__tGlobalUserTask",
    "group": "BPMN20__tGroup",
    "humanPerformer": "BPMN20__tHumanPerformer",
    "implicitThrowEvent": "BPMN20__tImplicitThrowEvent",
    "inclusiveGateway": "BPMN20__tInclusiveGateway",
    "inputSet": "BPMN20__tInputSet",
    "interface": "BPMN20__tInterface",
    "intermediateCatchEvent": "BPMN20__tIntermediateCatchEvent",
    "intermediateThrowEvent": "BPMN20__tIntermediateThrowEvent",
    "ioBinding": "BPMN20__tInputOutputBinding",
    "ioSpecification": "BPMN20__tInputOutputSpecification",
    "itemDefinition": "BPMN20__tItemDefinition",
    "lane": "BPMN20__tLane",
    "laneSet": "BPMN20__tLaneSet",
    "linkEventDefinition": "BPMN20__tLinkEventDefinition",
    "loopCharacteristics": "BPMN20__tLoopCharacteristics",
    "manualTask": "BPMN20__tManualTask",
    "message": "BPMN20__tMessage",
    "messageEventDefinition": "BPMN20__tMessageEventDefinition",
    "messageFlow": "BPMN20__tMessageFlow",
    "messageFlowAssociation": "BPMN20__tMessageFlowAssociation",
    "monitoring": "BPMN20__tMonitoring",
    "multiInstanceLoopCharacteristics": "BPMN20__tMultiInstanceLoopCharacteristics",
    "operation": "BPMN20__tOperation",
    "outputSet": "BPMN20__tOutputSet",
    "parallelGateway": "BPMN20__tParallelGateway",
    "participant": "BPMN20__tParticipant",
    "participantAssociation": "BPMN20__tParticipantAssociation",
    "participantMultiplicity": "BPMN20__tParticipantMultiplicity",
    "partnerEntity": "BPMN20__tPartnerEntity",
    "partnerRole": "BPMN20__tPartnerRole",
    "performer": "BPMN20__tPerformer",
    "potentialOwner": "BPMN20__tPotentialOwner",
    "process": "BPMN20__tProcess",
    "property": "BPMN20__tProperty",
    "receiveTask": "BPMN20__tReceiveTask",
    "relationship": "BPMN20__tRelationship",
    "rendering": "BPMN20__tRendering",
    "resource": "BPMN20__tResource",
    "resourceAssignmentExpression": "BPMN20__tResourceAssignmentExpression",
    "resourceParameter": "BPMN20__tResourceParameter",
    "resourceParameterBinding": "BPMN20__tResourceParameterBinding",
    "resourceRole": "BPMN20__tResourceRole",
    "rootElement": "BPMN20__tRootElement",
    "scriptTask": "BPMN20__tScriptTask",
    "script": "BPMN20__tScript",
    "sendTask": "BPMN20__tSendTask",
    "sequenceFlow": "BPMN20__tSequenceFlow",
    "serviceTask": "BPMN20__tServiceTask",
    "signal": "BPMN20__tSignal",
    "signalEventDefinition": "BPMN20__tSignalEventDefinition",
    "standardLoopCharacteristics": "BPMN20__tStandardLoopCharacteristics",
    "startEvent": "BPMN20__tStartEvent",
    "subChoreography": "BPMN20__tSubChoreography",
    "subConversation": "BPMN20__tSubConversation",
    "subProcess": "BPMN20__tSubProcess",
    "task": "BPMN20__tTask",
    "terminateEventDefinition": "BPMN20__tTerminateEventDefinition",
    "textAnnotation": "BPMN20__tTextAnnotation",
    "text": "BPMN20__tText",
    "throwEvent": "BPMN20__tThrowEvent",
    "timerEventDefinition": "BPMN20__tTimerEventDefinition",
    "transaction": "BPMN20__tTransaction",
    "userTask": "BPMN20__tUserTask",
    "bpmndi:BPMNDiagram": "BPMNDI__BPMNDiagram",
    "bpmndi:BPMNPlane": "BPMNDI__BPMNPlane",
    "bpmndi:BPMNLabelStyle": "BPMNDI__BPMNLabelStyle",
    "bpmndi:BPMNShape": "BPMNDI__BPMNShape",
    "bpmndi:BPMNLabel": "BPMNDI__BPMNLabel",
    "bpmndi:BPMNEdge": "BPMNDI__BPMNEdge",
    "dc:Font": "DC__Font",
    "dc:Point": "DC__Point",
    "dc:Bounds": "DC__Bounds",
    "di:DiagramElement": "DI__DiagramElement",
    "di:Diagram": "DI__Diagram",
    "di:Style": "DI__Style",
    "di:Node": "DI__Node",
    "di:Edge": "DI__Edge",
    "di:Shape": "DI__Shape",
    "di:Plane": "DI__Plane",
    "di:LabeledEdge": "DI__LabeledEdge",
    "di:Label": "DI__Label",
    "di:LabeledShape": "DI__LabeledShape",
};
exports.meta = {
    "BPMN20__tDefinitions": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tDefinitions", xsdType: "xsd:ID" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tDefinitions", xsdType: "xsd:string" },
        "@_targetNamespace": { type: "string", isArray: false, fromType: "BPMN20__tDefinitions", xsdType: "xsd:anyURI" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "BPMN20__tDefinitions", xsdType: "xsd:anyURI" },
        "@_typeLanguage": { type: "string", isArray: false, fromType: "BPMN20__tDefinitions", xsdType: "xsd:anyURI" },
        "@_exporter": { type: "string", isArray: false, fromType: "BPMN20__tDefinitions", xsdType: "xsd:string" },
        "@_exporterVersion": { type: "string", isArray: false, fromType: "BPMN20__tDefinitions", xsdType: "xsd:string" },
        "import": { type: "BPMN20__tImport", isArray: true, fromType: "BPMN20__tDefinitions", xsdType: "// local type" },
        "extension": { type: "BPMN20__tExtension", isArray: true, fromType: "BPMN20__tDefinitions", xsdType: "// local type" },
        "rootElement": { type: "BPMN20__tRootElement", isArray: true, fromType: "BPMN20__tDefinitions", xsdType: "// local type" },
        "bpmndi:BPMNDiagram": { type: "BPMNDI__BPMNDiagram", isArray: true, fromType: "BPMN20__tDefinitions", xsdType: "type found from namespace with declaration name 'bpmndi'." },
        "relationship": { type: "BPMN20__tRelationship", isArray: true, fromType: "BPMN20__tDefinitions", xsdType: "// local type" },
    },
    "BPMN20__tImport": {
        "@_namespace": { type: "string", isArray: false, fromType: "BPMN20__tImport", xsdType: "xsd:anyURI" },
        "@_location": { type: "string", isArray: false, fromType: "BPMN20__tImport", xsdType: "xsd:string" },
        "@_importType": { type: "string", isArray: false, fromType: "BPMN20__tImport", xsdType: "xsd:anyURI" },
    },
    "BPMN20__tAdHocSubProcess": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_isForCompensation": { type: "boolean", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:boolean" },
        "@_startQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_completionQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_default": { type: "string", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:IDREF" },
        "ioSpecification": { type: "BPMN20__tInputOutputSpecification", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "property": { type: "BPMN20__tProperty", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataInputAssociation": { type: "BPMN20__tDataInputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataOutputAssociation": { type: "BPMN20__tDataOutputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "resourceRole": { type: "BPMN20__tResourceRole", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "loopCharacteristics": { type: "BPMN20__tLoopCharacteristics", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "@_triggeredByEvent": { type: "boolean", isArray: false, fromType: "BPMN20__tSubProcess", xsdType: "xsd:boolean" },
        "laneSet": { type: "BPMN20__tLaneSet", isArray: true, fromType: "BPMN20__tSubProcess", xsdType: "// local type" },
        "flowElement": { type: "BPMN20__tFlowElement", isArray: true, fromType: "BPMN20__tSubProcess", xsdType: "// local type" },
        "artifact": { type: "BPMN20__tArtifact", isArray: true, fromType: "BPMN20__tSubProcess", xsdType: "// local type" },
        "@_cancelRemainingInstances": { type: "boolean", isArray: false, fromType: "BPMN20__tAdHocSubProcess", xsdType: "xsd:boolean" },
        "@_ordering": { type: "BPMN20__tAdHocOrdering", isArray: false, fromType: "BPMN20__tAdHocSubProcess", xsdType: "// local type" },
        "completionCondition": { type: "BPMN20__tExpression", isArray: false, fromType: "BPMN20__tAdHocSubProcess", xsdType: "// local type" },
    },
    "BPMN20__tAssignment": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "from": { type: "BPMN20__tExpression", isArray: false, fromType: "BPMN20__tAssignment", xsdType: "// local type" },
        "to": { type: "BPMN20__tExpression", isArray: false, fromType: "BPMN20__tAssignment", xsdType: "// local type" },
    },
    "BPMN20__tAssociation": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_sourceRef": { type: "string", isArray: false, fromType: "BPMN20__tAssociation", xsdType: "xsd:QName" },
        "@_targetRef": { type: "string", isArray: false, fromType: "BPMN20__tAssociation", xsdType: "xsd:QName" },
        "@_associationDirection": { type: "BPMN20__tAssociationDirection", isArray: false, fromType: "BPMN20__tAssociation", xsdType: "// local type" },
    },
    "BPMN20__tAuditing": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
    },
    "BPMN20__tBoundaryEvent": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "property": { type: "BPMN20__tProperty", isArray: true, fromType: "BPMN20__tEvent", xsdType: "// local type" },
        "@_parallelMultiple": { type: "boolean", isArray: false, fromType: "BPMN20__tCatchEvent", xsdType: "xsd:boolean" },
        "dataOutput": { type: "BPMN20__tDataOutput", isArray: true, fromType: "BPMN20__tCatchEvent", xsdType: "// local type" },
        "dataOutputAssociation": { type: "BPMN20__tDataOutputAssociation", isArray: true, fromType: "BPMN20__tCatchEvent", xsdType: "// local type" },
        "outputSet": { type: "BPMN20__tOutputSet", isArray: false, fromType: "BPMN20__tCatchEvent", xsdType: "// local type" },
        "eventDefinition": { type: "BPMN20__tEventDefinition", isArray: true, fromType: "BPMN20__tCatchEvent", xsdType: "// local type" },
        "eventDefinitionRef": { type: "string", isArray: true, fromType: "BPMN20__tCatchEvent", xsdType: "xsd:QName" },
        "@_cancelActivity": { type: "boolean", isArray: false, fromType: "BPMN20__tBoundaryEvent", xsdType: "xsd:boolean" },
        "@_attachedToRef": { type: "string", isArray: false, fromType: "BPMN20__tBoundaryEvent", xsdType: "xsd:QName" },
    },
    "BPMN20__tBusinessRuleTask": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_isForCompensation": { type: "boolean", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:boolean" },
        "@_startQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_completionQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_default": { type: "string", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:IDREF" },
        "ioSpecification": { type: "BPMN20__tInputOutputSpecification", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "property": { type: "BPMN20__tProperty", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataInputAssociation": { type: "BPMN20__tDataInputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataOutputAssociation": { type: "BPMN20__tDataOutputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "resourceRole": { type: "BPMN20__tResourceRole", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "loopCharacteristics": { type: "BPMN20__tLoopCharacteristics", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "@_implementation": { type: "BPMN20__tImplementation", isArray: false, fromType: "BPMN20__tBusinessRuleTask", xsdType: "// local type" },
    },
    "BPMN20__tCallableElement": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tCallableElement", xsdType: "xsd:string" },
        "supportedInterfaceRef": { type: "string", isArray: true, fromType: "BPMN20__tCallableElement", xsdType: "xsd:QName" },
        "ioSpecification": { type: "BPMN20__tInputOutputSpecification", isArray: false, fromType: "BPMN20__tCallableElement", xsdType: "// local type" },
        "ioBinding": { type: "BPMN20__tInputOutputBinding", isArray: true, fromType: "BPMN20__tCallableElement", xsdType: "// local type" },
    },
    "BPMN20__tCallActivity": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_isForCompensation": { type: "boolean", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:boolean" },
        "@_startQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_completionQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_default": { type: "string", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:IDREF" },
        "ioSpecification": { type: "BPMN20__tInputOutputSpecification", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "property": { type: "BPMN20__tProperty", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataInputAssociation": { type: "BPMN20__tDataInputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataOutputAssociation": { type: "BPMN20__tDataOutputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "resourceRole": { type: "BPMN20__tResourceRole", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "loopCharacteristics": { type: "BPMN20__tLoopCharacteristics", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "@_calledElement": { type: "string", isArray: false, fromType: "BPMN20__tCallActivity", xsdType: "xsd:QName" },
    },
    "BPMN20__tCallChoreography": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_initiatingParticipantRef": { type: "string", isArray: false, fromType: "BPMN20__tChoreographyActivity", xsdType: "xsd:QName" },
        "@_loopType": { type: "BPMN20__tChoreographyLoopType", isArray: false, fromType: "BPMN20__tChoreographyActivity", xsdType: "// local type" },
        "participantRef": { type: "string", isArray: true, fromType: "BPMN20__tChoreographyActivity", xsdType: "xsd:QName" },
        "correlationKey": { type: "BPMN20__tCorrelationKey", isArray: true, fromType: "BPMN20__tChoreographyActivity", xsdType: "// local type" },
        "@_calledChoreographyRef": { type: "string", isArray: false, fromType: "BPMN20__tCallChoreography", xsdType: "xsd:QName" },
        "participantAssociation": { type: "BPMN20__tParticipantAssociation", isArray: true, fromType: "BPMN20__tCallChoreography", xsdType: "// local type" },
    },
    "BPMN20__tCallConversation": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tConversationNode", xsdType: "xsd:string" },
        "participantRef": { type: "string", isArray: true, fromType: "BPMN20__tConversationNode", xsdType: "xsd:QName" },
        "messageFlowRef": { type: "string", isArray: true, fromType: "BPMN20__tConversationNode", xsdType: "xsd:QName" },
        "correlationKey": { type: "BPMN20__tCorrelationKey", isArray: true, fromType: "BPMN20__tConversationNode", xsdType: "// local type" },
        "@_calledCollaborationRef": { type: "string", isArray: false, fromType: "BPMN20__tCallConversation", xsdType: "xsd:QName" },
        "participantAssociation": { type: "BPMN20__tParticipantAssociation", isArray: true, fromType: "BPMN20__tCallConversation", xsdType: "// local type" },
    },
    "BPMN20__tCancelEventDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
    },
    "BPMN20__tCategory": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tCategory", xsdType: "xsd:string" },
        "categoryValue": { type: "BPMN20__tCategoryValue", isArray: true, fromType: "BPMN20__tCategory", xsdType: "// local type" },
    },
    "BPMN20__tCategoryValue": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_value": { type: "string", isArray: false, fromType: "BPMN20__tCategoryValue", xsdType: "xsd:string" },
    },
    "BPMN20__tChoreography": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tCollaboration", xsdType: "xsd:string" },
        "@_isClosed": { type: "boolean", isArray: false, fromType: "BPMN20__tCollaboration", xsdType: "xsd:boolean" },
        "participant": { type: "BPMN20__tParticipant", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "messageFlow": { type: "BPMN20__tMessageFlow", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "artifact": { type: "BPMN20__tArtifact", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "conversationNode": { type: "BPMN20__tConversationNode", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "conversationAssociation": { type: "BPMN20__tConversationAssociation", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "participantAssociation": { type: "BPMN20__tParticipantAssociation", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "messageFlowAssociation": { type: "BPMN20__tMessageFlowAssociation", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "correlationKey": { type: "BPMN20__tCorrelationKey", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "choreographyRef": { type: "string", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "xsd:QName" },
        "conversationLink": { type: "BPMN20__tConversationLink", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "flowElement": { type: "BPMN20__tFlowElement", isArray: true, fromType: "BPMN20__tChoreography", xsdType: "// local type" },
    },
    "BPMN20__tChoreographyTask": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_initiatingParticipantRef": { type: "string", isArray: false, fromType: "BPMN20__tChoreographyActivity", xsdType: "xsd:QName" },
        "@_loopType": { type: "BPMN20__tChoreographyLoopType", isArray: false, fromType: "BPMN20__tChoreographyActivity", xsdType: "// local type" },
        "participantRef": { type: "string", isArray: true, fromType: "BPMN20__tChoreographyActivity", xsdType: "xsd:QName" },
        "correlationKey": { type: "BPMN20__tCorrelationKey", isArray: true, fromType: "BPMN20__tChoreographyActivity", xsdType: "// local type" },
        "messageFlowRef": { type: "string", isArray: true, fromType: "BPMN20__tChoreographyTask", xsdType: "xsd:QName" },
    },
    "BPMN20__tCollaboration": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tCollaboration", xsdType: "xsd:string" },
        "@_isClosed": { type: "boolean", isArray: false, fromType: "BPMN20__tCollaboration", xsdType: "xsd:boolean" },
        "participant": { type: "BPMN20__tParticipant", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "messageFlow": { type: "BPMN20__tMessageFlow", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "artifact": { type: "BPMN20__tArtifact", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "conversationNode": { type: "BPMN20__tConversationNode", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "conversationAssociation": { type: "BPMN20__tConversationAssociation", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "participantAssociation": { type: "BPMN20__tParticipantAssociation", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "messageFlowAssociation": { type: "BPMN20__tMessageFlowAssociation", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "correlationKey": { type: "BPMN20__tCorrelationKey", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "choreographyRef": { type: "string", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "xsd:QName" },
        "conversationLink": { type: "BPMN20__tConversationLink", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
    },
    "BPMN20__tCompensateEventDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_waitForCompletion": { type: "boolean", isArray: false, fromType: "BPMN20__tCompensateEventDefinition", xsdType: "xsd:boolean" },
        "@_activityRef": { type: "string", isArray: false, fromType: "BPMN20__tCompensateEventDefinition", xsdType: "xsd:QName" },
    },
    "BPMN20__tComplexBehaviorDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "condition": { type: "BPMN20__tFormalExpression", isArray: false, fromType: "BPMN20__tComplexBehaviorDefinition", xsdType: "// local type" },
        "event": { type: "BPMN20__tImplicitThrowEvent", isArray: false, fromType: "BPMN20__tComplexBehaviorDefinition", xsdType: "// local type" },
    },
    "BPMN20__tComplexGateway": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_gatewayDirection": { type: "BPMN20__tGatewayDirection", isArray: false, fromType: "BPMN20__tGateway", xsdType: "// local type" },
        "@_default": { type: "string", isArray: false, fromType: "BPMN20__tComplexGateway", xsdType: "xsd:IDREF" },
        "activationCondition": { type: "BPMN20__tExpression", isArray: false, fromType: "BPMN20__tComplexGateway", xsdType: "// local type" },
    },
    "BPMN20__tConditionalEventDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "condition": { type: "BPMN20__tExpression", isArray: false, fromType: "BPMN20__tConditionalEventDefinition", xsdType: "// local type" },
    },
    "BPMN20__tConversation": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tConversationNode", xsdType: "xsd:string" },
        "participantRef": { type: "string", isArray: true, fromType: "BPMN20__tConversationNode", xsdType: "xsd:QName" },
        "messageFlowRef": { type: "string", isArray: true, fromType: "BPMN20__tConversationNode", xsdType: "xsd:QName" },
        "correlationKey": { type: "BPMN20__tCorrelationKey", isArray: true, fromType: "BPMN20__tConversationNode", xsdType: "// local type" },
    },
    "BPMN20__tConversationAssociation": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_innerConversationNodeRef": { type: "string", isArray: false, fromType: "BPMN20__tConversationAssociation", xsdType: "xsd:QName" },
        "@_outerConversationNodeRef": { type: "string", isArray: false, fromType: "BPMN20__tConversationAssociation", xsdType: "xsd:QName" },
    },
    "BPMN20__tConversationLink": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tConversationLink", xsdType: "xsd:string" },
        "@_sourceRef": { type: "string", isArray: false, fromType: "BPMN20__tConversationLink", xsdType: "xsd:QName" },
        "@_targetRef": { type: "string", isArray: false, fromType: "BPMN20__tConversationLink", xsdType: "xsd:QName" },
    },
    "BPMN20__tCorrelationKey": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tCorrelationKey", xsdType: "xsd:string" },
        "correlationPropertyRef": { type: "string", isArray: true, fromType: "BPMN20__tCorrelationKey", xsdType: "xsd:QName" },
    },
    "BPMN20__tCorrelationProperty": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tCorrelationProperty", xsdType: "xsd:string" },
        "@_type": { type: "string", isArray: false, fromType: "BPMN20__tCorrelationProperty", xsdType: "xsd:QName" },
        "correlationPropertyRetrievalExpression": { type: "BPMN20__tCorrelationPropertyRetrievalExpression", isArray: true, fromType: "BPMN20__tCorrelationProperty", xsdType: "// local type" },
    },
    "BPMN20__tCorrelationPropertyBinding": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_correlationPropertyRef": { type: "string", isArray: false, fromType: "BPMN20__tCorrelationPropertyBinding", xsdType: "xsd:QName" },
        "dataPath": { type: "BPMN20__tFormalExpression", isArray: false, fromType: "BPMN20__tCorrelationPropertyBinding", xsdType: "// local type" },
    },
    "BPMN20__tCorrelationPropertyRetrievalExpression": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_messageRef": { type: "string", isArray: false, fromType: "BPMN20__tCorrelationPropertyRetrievalExpression", xsdType: "xsd:QName" },
        "messagePath": { type: "BPMN20__tFormalExpression", isArray: false, fromType: "BPMN20__tCorrelationPropertyRetrievalExpression", xsdType: "// local type" },
    },
    "BPMN20__tCorrelationSubscription": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_correlationKeyRef": { type: "string", isArray: false, fromType: "BPMN20__tCorrelationSubscription", xsdType: "xsd:QName" },
        "correlationPropertyBinding": { type: "BPMN20__tCorrelationPropertyBinding", isArray: true, fromType: "BPMN20__tCorrelationSubscription", xsdType: "// local type" },
    },
    "BPMN20__tDataAssociation": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "sourceRef": { type: "string", isArray: true, fromType: "BPMN20__tDataAssociation", xsdType: "xsd:IDREF" },
        "targetRef": { type: "string", isArray: false, fromType: "BPMN20__tDataAssociation", xsdType: "xsd:IDREF" },
        "transformation": { type: "BPMN20__tFormalExpression", isArray: false, fromType: "BPMN20__tDataAssociation", xsdType: "// local type" },
        "assignment": { type: "BPMN20__tAssignment", isArray: true, fromType: "BPMN20__tDataAssociation", xsdType: "// local type" },
    },
    "BPMN20__tDataInput": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tDataInput", xsdType: "xsd:string" },
        "@_itemSubjectRef": { type: "string", isArray: false, fromType: "BPMN20__tDataInput", xsdType: "xsd:QName" },
        "@_isCollection": { type: "boolean", isArray: false, fromType: "BPMN20__tDataInput", xsdType: "xsd:boolean" },
        "dataState": { type: "BPMN20__tDataState", isArray: false, fromType: "BPMN20__tDataInput", xsdType: "// local type" },
    },
    "BPMN20__tDataInputAssociation": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "sourceRef": { type: "string", isArray: true, fromType: "BPMN20__tDataAssociation", xsdType: "xsd:IDREF" },
        "targetRef": { type: "string", isArray: false, fromType: "BPMN20__tDataAssociation", xsdType: "xsd:IDREF" },
        "transformation": { type: "BPMN20__tFormalExpression", isArray: false, fromType: "BPMN20__tDataAssociation", xsdType: "// local type" },
        "assignment": { type: "BPMN20__tAssignment", isArray: true, fromType: "BPMN20__tDataAssociation", xsdType: "// local type" },
    },
    "BPMN20__tDataObject": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "@_itemSubjectRef": { type: "string", isArray: false, fromType: "BPMN20__tDataObject", xsdType: "xsd:QName" },
        "@_isCollection": { type: "boolean", isArray: false, fromType: "BPMN20__tDataObject", xsdType: "xsd:boolean" },
        "dataState": { type: "BPMN20__tDataState", isArray: false, fromType: "BPMN20__tDataObject", xsdType: "// local type" },
    },
    "BPMN20__tDataObjectReference": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "@_itemSubjectRef": { type: "string", isArray: false, fromType: "BPMN20__tDataObjectReference", xsdType: "xsd:QName" },
        "@_dataObjectRef": { type: "string", isArray: false, fromType: "BPMN20__tDataObjectReference", xsdType: "xsd:IDREF" },
        "dataState": { type: "BPMN20__tDataState", isArray: false, fromType: "BPMN20__tDataObjectReference", xsdType: "// local type" },
    },
    "BPMN20__tDataOutput": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tDataOutput", xsdType: "xsd:string" },
        "@_itemSubjectRef": { type: "string", isArray: false, fromType: "BPMN20__tDataOutput", xsdType: "xsd:QName" },
        "@_isCollection": { type: "boolean", isArray: false, fromType: "BPMN20__tDataOutput", xsdType: "xsd:boolean" },
        "dataState": { type: "BPMN20__tDataState", isArray: false, fromType: "BPMN20__tDataOutput", xsdType: "// local type" },
    },
    "BPMN20__tDataOutputAssociation": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "sourceRef": { type: "string", isArray: true, fromType: "BPMN20__tDataAssociation", xsdType: "xsd:IDREF" },
        "targetRef": { type: "string", isArray: false, fromType: "BPMN20__tDataAssociation", xsdType: "xsd:IDREF" },
        "transformation": { type: "BPMN20__tFormalExpression", isArray: false, fromType: "BPMN20__tDataAssociation", xsdType: "// local type" },
        "assignment": { type: "BPMN20__tAssignment", isArray: true, fromType: "BPMN20__tDataAssociation", xsdType: "// local type" },
    },
    "BPMN20__tDataState": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tDataState", xsdType: "xsd:string" },
    },
    "BPMN20__tDataStore": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tDataStore", xsdType: "xsd:string" },
        "@_capacity": { type: "integer", isArray: false, fromType: "BPMN20__tDataStore", xsdType: "xsd:integer" },
        "@_isUnlimited": { type: "boolean", isArray: false, fromType: "BPMN20__tDataStore", xsdType: "xsd:boolean" },
        "@_itemSubjectRef": { type: "string", isArray: false, fromType: "BPMN20__tDataStore", xsdType: "xsd:QName" },
        "dataState": { type: "BPMN20__tDataState", isArray: false, fromType: "BPMN20__tDataStore", xsdType: "// local type" },
    },
    "BPMN20__tDataStoreReference": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "@_itemSubjectRef": { type: "string", isArray: false, fromType: "BPMN20__tDataStoreReference", xsdType: "xsd:QName" },
        "@_dataStoreRef": { type: "string", isArray: false, fromType: "BPMN20__tDataStoreReference", xsdType: "xsd:QName" },
        "dataState": { type: "BPMN20__tDataState", isArray: false, fromType: "BPMN20__tDataStoreReference", xsdType: "// local type" },
    },
    "BPMN20__tDocumentation": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tDocumentation", xsdType: "xsd:ID" },
        "@_textFormat": { type: "string", isArray: false, fromType: "BPMN20__tDocumentation", xsdType: "xsd:string" },
    },
    "BPMN20__tEndEvent": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "property": { type: "BPMN20__tProperty", isArray: true, fromType: "BPMN20__tEvent", xsdType: "// local type" },
        "dataInput": { type: "BPMN20__tDataInput", isArray: true, fromType: "BPMN20__tThrowEvent", xsdType: "// local type" },
        "dataInputAssociation": { type: "BPMN20__tDataInputAssociation", isArray: true, fromType: "BPMN20__tThrowEvent", xsdType: "// local type" },
        "inputSet": { type: "BPMN20__tInputSet", isArray: false, fromType: "BPMN20__tThrowEvent", xsdType: "// local type" },
        "eventDefinition": { type: "BPMN20__tEventDefinition", isArray: true, fromType: "BPMN20__tThrowEvent", xsdType: "// local type" },
        "eventDefinitionRef": { type: "string", isArray: true, fromType: "BPMN20__tThrowEvent", xsdType: "xsd:QName" },
    },
    "BPMN20__tEndPoint": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
    },
    "BPMN20__tError": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tError", xsdType: "xsd:string" },
        "@_errorCode": { type: "string", isArray: false, fromType: "BPMN20__tError", xsdType: "xsd:string" },
        "@_structureRef": { type: "string", isArray: false, fromType: "BPMN20__tError", xsdType: "xsd:QName" },
    },
    "BPMN20__tErrorEventDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_errorRef": { type: "string", isArray: false, fromType: "BPMN20__tErrorEventDefinition", xsdType: "xsd:QName" },
    },
    "BPMN20__tEscalation": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tEscalation", xsdType: "xsd:string" },
        "@_escalationCode": { type: "string", isArray: false, fromType: "BPMN20__tEscalation", xsdType: "xsd:string" },
        "@_structureRef": { type: "string", isArray: false, fromType: "BPMN20__tEscalation", xsdType: "xsd:QName" },
    },
    "BPMN20__tEscalationEventDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_escalationRef": { type: "string", isArray: false, fromType: "BPMN20__tEscalationEventDefinition", xsdType: "xsd:QName" },
    },
    "BPMN20__tEventBasedGateway": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_gatewayDirection": { type: "BPMN20__tGatewayDirection", isArray: false, fromType: "BPMN20__tGateway", xsdType: "// local type" },
        "@_instantiate": { type: "boolean", isArray: false, fromType: "BPMN20__tEventBasedGateway", xsdType: "xsd:boolean" },
        "@_eventGatewayType": { type: "BPMN20__tEventBasedGatewayType", isArray: false, fromType: "BPMN20__tEventBasedGateway", xsdType: "// local type" },
    },
    "BPMN20__tExclusiveGateway": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_gatewayDirection": { type: "BPMN20__tGatewayDirection", isArray: false, fromType: "BPMN20__tGateway", xsdType: "// local type" },
        "@_default": { type: "string", isArray: false, fromType: "BPMN20__tExclusiveGateway", xsdType: "xsd:IDREF" },
    },
    "BPMN20__tExpression": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElementWithMixedContent", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElementWithMixedContent", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElementWithMixedContent", xsdType: "// local type" },
    },
    "BPMN20__tExtension": {
        "@_definition": { type: "string", isArray: false, fromType: "BPMN20__tExtension", xsdType: "xsd:QName" },
        "@_mustUnderstand": { type: "boolean", isArray: false, fromType: "BPMN20__tExtension", xsdType: "xsd:boolean" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tExtension", xsdType: "// local type" },
    },
    "BPMN20__tExtensionElements": {},
    "BPMN20__tFormalExpression": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElementWithMixedContent", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElementWithMixedContent", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElementWithMixedContent", xsdType: "// local type" },
        "@_language": { type: "string", isArray: false, fromType: "BPMN20__tFormalExpression", xsdType: "xsd:anyURI" },
        "@_evaluatesToTypeRef": { type: "string", isArray: false, fromType: "BPMN20__tFormalExpression", xsdType: "xsd:QName" },
    },
    "BPMN20__tGateway": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_gatewayDirection": { type: "BPMN20__tGatewayDirection", isArray: false, fromType: "BPMN20__tGateway", xsdType: "// local type" },
    },
    "BPMN20__tGlobalBusinessRuleTask": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tCallableElement", xsdType: "xsd:string" },
        "supportedInterfaceRef": { type: "string", isArray: true, fromType: "BPMN20__tCallableElement", xsdType: "xsd:QName" },
        "ioSpecification": { type: "BPMN20__tInputOutputSpecification", isArray: false, fromType: "BPMN20__tCallableElement", xsdType: "// local type" },
        "ioBinding": { type: "BPMN20__tInputOutputBinding", isArray: true, fromType: "BPMN20__tCallableElement", xsdType: "// local type" },
        "resourceRole": { type: "BPMN20__tResourceRole", isArray: true, fromType: "BPMN20__tGlobalTask", xsdType: "// local type" },
        "@_implementation": { type: "BPMN20__tImplementation", isArray: false, fromType: "BPMN20__tGlobalBusinessRuleTask", xsdType: "// local type" },
    },
    "BPMN20__tGlobalChoreographyTask": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tCollaboration", xsdType: "xsd:string" },
        "@_isClosed": { type: "boolean", isArray: false, fromType: "BPMN20__tCollaboration", xsdType: "xsd:boolean" },
        "participant": { type: "BPMN20__tParticipant", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "messageFlow": { type: "BPMN20__tMessageFlow", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "artifact": { type: "BPMN20__tArtifact", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "conversationNode": { type: "BPMN20__tConversationNode", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "conversationAssociation": { type: "BPMN20__tConversationAssociation", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "participantAssociation": { type: "BPMN20__tParticipantAssociation", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "messageFlowAssociation": { type: "BPMN20__tMessageFlowAssociation", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "correlationKey": { type: "BPMN20__tCorrelationKey", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "choreographyRef": { type: "string", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "xsd:QName" },
        "conversationLink": { type: "BPMN20__tConversationLink", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "flowElement": { type: "BPMN20__tFlowElement", isArray: true, fromType: "BPMN20__tChoreography", xsdType: "// local type" },
        "@_initiatingParticipantRef": { type: "string", isArray: false, fromType: "BPMN20__tGlobalChoreographyTask", xsdType: "xsd:QName" },
    },
    "BPMN20__tGlobalConversation": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tCollaboration", xsdType: "xsd:string" },
        "@_isClosed": { type: "boolean", isArray: false, fromType: "BPMN20__tCollaboration", xsdType: "xsd:boolean" },
        "participant": { type: "BPMN20__tParticipant", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "messageFlow": { type: "BPMN20__tMessageFlow", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "artifact": { type: "BPMN20__tArtifact", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "conversationNode": { type: "BPMN20__tConversationNode", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "conversationAssociation": { type: "BPMN20__tConversationAssociation", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "participantAssociation": { type: "BPMN20__tParticipantAssociation", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "messageFlowAssociation": { type: "BPMN20__tMessageFlowAssociation", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "correlationKey": { type: "BPMN20__tCorrelationKey", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
        "choreographyRef": { type: "string", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "xsd:QName" },
        "conversationLink": { type: "BPMN20__tConversationLink", isArray: true, fromType: "BPMN20__tCollaboration", xsdType: "// local type" },
    },
    "BPMN20__tGlobalManualTask": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tCallableElement", xsdType: "xsd:string" },
        "supportedInterfaceRef": { type: "string", isArray: true, fromType: "BPMN20__tCallableElement", xsdType: "xsd:QName" },
        "ioSpecification": { type: "BPMN20__tInputOutputSpecification", isArray: false, fromType: "BPMN20__tCallableElement", xsdType: "// local type" },
        "ioBinding": { type: "BPMN20__tInputOutputBinding", isArray: true, fromType: "BPMN20__tCallableElement", xsdType: "// local type" },
        "resourceRole": { type: "BPMN20__tResourceRole", isArray: true, fromType: "BPMN20__tGlobalTask", xsdType: "// local type" },
    },
    "BPMN20__tGlobalScriptTask": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tCallableElement", xsdType: "xsd:string" },
        "supportedInterfaceRef": { type: "string", isArray: true, fromType: "BPMN20__tCallableElement", xsdType: "xsd:QName" },
        "ioSpecification": { type: "BPMN20__tInputOutputSpecification", isArray: false, fromType: "BPMN20__tCallableElement", xsdType: "// local type" },
        "ioBinding": { type: "BPMN20__tInputOutputBinding", isArray: true, fromType: "BPMN20__tCallableElement", xsdType: "// local type" },
        "resourceRole": { type: "BPMN20__tResourceRole", isArray: true, fromType: "BPMN20__tGlobalTask", xsdType: "// local type" },
        "@_scriptLanguage": { type: "string", isArray: false, fromType: "BPMN20__tGlobalScriptTask", xsdType: "xsd:anyURI" },
        "script": { type: "BPMN20__tScript", isArray: false, fromType: "BPMN20__tGlobalScriptTask", xsdType: "// local type" },
    },
    "BPMN20__tGlobalTask": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tCallableElement", xsdType: "xsd:string" },
        "supportedInterfaceRef": { type: "string", isArray: true, fromType: "BPMN20__tCallableElement", xsdType: "xsd:QName" },
        "ioSpecification": { type: "BPMN20__tInputOutputSpecification", isArray: false, fromType: "BPMN20__tCallableElement", xsdType: "// local type" },
        "ioBinding": { type: "BPMN20__tInputOutputBinding", isArray: true, fromType: "BPMN20__tCallableElement", xsdType: "// local type" },
        "resourceRole": { type: "BPMN20__tResourceRole", isArray: true, fromType: "BPMN20__tGlobalTask", xsdType: "// local type" },
    },
    "BPMN20__tGlobalUserTask": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tCallableElement", xsdType: "xsd:string" },
        "supportedInterfaceRef": { type: "string", isArray: true, fromType: "BPMN20__tCallableElement", xsdType: "xsd:QName" },
        "ioSpecification": { type: "BPMN20__tInputOutputSpecification", isArray: false, fromType: "BPMN20__tCallableElement", xsdType: "// local type" },
        "ioBinding": { type: "BPMN20__tInputOutputBinding", isArray: true, fromType: "BPMN20__tCallableElement", xsdType: "// local type" },
        "resourceRole": { type: "BPMN20__tResourceRole", isArray: true, fromType: "BPMN20__tGlobalTask", xsdType: "// local type" },
        "@_implementation": { type: "BPMN20__tImplementation", isArray: false, fromType: "BPMN20__tGlobalUserTask", xsdType: "// local type" },
        "rendering": { type: "BPMN20__tRendering", isArray: true, fromType: "BPMN20__tGlobalUserTask", xsdType: "// local type" },
    },
    "BPMN20__tGroup": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_categoryValueRef": { type: "string", isArray: false, fromType: "BPMN20__tGroup", xsdType: "xsd:QName" },
    },
    "BPMN20__tHumanPerformer": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tResourceRole", xsdType: "xsd:string" },
        "resourceAssignmentExpression": { type: "BPMN20__tResourceAssignmentExpression", isArray: false, fromType: "BPMN20__tResourceRole", xsdType: "// local type" },
        "resourceRef": { type: "string", isArray: false, fromType: "BPMN20__tResourceRole", xsdType: "xsd:QName" },
        "resourceParameterBinding": { type: "BPMN20__tResourceParameterBinding", isArray: true, fromType: "BPMN20__tResourceRole", xsdType: "// local type" },
    },
    "BPMN20__tImplicitThrowEvent": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "property": { type: "BPMN20__tProperty", isArray: true, fromType: "BPMN20__tEvent", xsdType: "// local type" },
        "dataInput": { type: "BPMN20__tDataInput", isArray: true, fromType: "BPMN20__tThrowEvent", xsdType: "// local type" },
        "dataInputAssociation": { type: "BPMN20__tDataInputAssociation", isArray: true, fromType: "BPMN20__tThrowEvent", xsdType: "// local type" },
        "inputSet": { type: "BPMN20__tInputSet", isArray: false, fromType: "BPMN20__tThrowEvent", xsdType: "// local type" },
        "eventDefinition": { type: "BPMN20__tEventDefinition", isArray: true, fromType: "BPMN20__tThrowEvent", xsdType: "// local type" },
        "eventDefinitionRef": { type: "string", isArray: true, fromType: "BPMN20__tThrowEvent", xsdType: "xsd:QName" },
    },
    "BPMN20__tInclusiveGateway": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_gatewayDirection": { type: "BPMN20__tGatewayDirection", isArray: false, fromType: "BPMN20__tGateway", xsdType: "// local type" },
        "@_default": { type: "string", isArray: false, fromType: "BPMN20__tInclusiveGateway", xsdType: "xsd:IDREF" },
    },
    "BPMN20__tInputSet": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tInputSet", xsdType: "xsd:string" },
        "dataInputRefs": { type: "string", isArray: true, fromType: "BPMN20__tInputSet", xsdType: "xsd:IDREF" },
        "optionalInputRefs": { type: "string", isArray: true, fromType: "BPMN20__tInputSet", xsdType: "xsd:IDREF" },
        "whileExecutingInputRefs": { type: "string", isArray: true, fromType: "BPMN20__tInputSet", xsdType: "xsd:IDREF" },
        "outputSetRefs": { type: "string", isArray: true, fromType: "BPMN20__tInputSet", xsdType: "xsd:IDREF" },
    },
    "BPMN20__tInterface": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tInterface", xsdType: "xsd:string" },
        "@_implementationRef": { type: "string", isArray: false, fromType: "BPMN20__tInterface", xsdType: "xsd:QName" },
        "operation": { type: "BPMN20__tOperation", isArray: true, fromType: "BPMN20__tInterface", xsdType: "// local type" },
    },
    "BPMN20__tIntermediateCatchEvent": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "property": { type: "BPMN20__tProperty", isArray: true, fromType: "BPMN20__tEvent", xsdType: "// local type" },
        "@_parallelMultiple": { type: "boolean", isArray: false, fromType: "BPMN20__tCatchEvent", xsdType: "xsd:boolean" },
        "dataOutput": { type: "BPMN20__tDataOutput", isArray: true, fromType: "BPMN20__tCatchEvent", xsdType: "// local type" },
        "dataOutputAssociation": { type: "BPMN20__tDataOutputAssociation", isArray: true, fromType: "BPMN20__tCatchEvent", xsdType: "// local type" },
        "outputSet": { type: "BPMN20__tOutputSet", isArray: false, fromType: "BPMN20__tCatchEvent", xsdType: "// local type" },
        "eventDefinition": { type: "BPMN20__tEventDefinition", isArray: true, fromType: "BPMN20__tCatchEvent", xsdType: "// local type" },
        "eventDefinitionRef": { type: "string", isArray: true, fromType: "BPMN20__tCatchEvent", xsdType: "xsd:QName" },
    },
    "BPMN20__tIntermediateThrowEvent": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "property": { type: "BPMN20__tProperty", isArray: true, fromType: "BPMN20__tEvent", xsdType: "// local type" },
        "dataInput": { type: "BPMN20__tDataInput", isArray: true, fromType: "BPMN20__tThrowEvent", xsdType: "// local type" },
        "dataInputAssociation": { type: "BPMN20__tDataInputAssociation", isArray: true, fromType: "BPMN20__tThrowEvent", xsdType: "// local type" },
        "inputSet": { type: "BPMN20__tInputSet", isArray: false, fromType: "BPMN20__tThrowEvent", xsdType: "// local type" },
        "eventDefinition": { type: "BPMN20__tEventDefinition", isArray: true, fromType: "BPMN20__tThrowEvent", xsdType: "// local type" },
        "eventDefinitionRef": { type: "string", isArray: true, fromType: "BPMN20__tThrowEvent", xsdType: "xsd:QName" },
    },
    "BPMN20__tInputOutputBinding": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_operationRef": { type: "string", isArray: false, fromType: "BPMN20__tInputOutputBinding", xsdType: "xsd:QName" },
        "@_inputDataRef": { type: "string", isArray: false, fromType: "BPMN20__tInputOutputBinding", xsdType: "xsd:IDREF" },
        "@_outputDataRef": { type: "string", isArray: false, fromType: "BPMN20__tInputOutputBinding", xsdType: "xsd:IDREF" },
    },
    "BPMN20__tInputOutputSpecification": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "dataInput": { type: "BPMN20__tDataInput", isArray: true, fromType: "BPMN20__tInputOutputSpecification", xsdType: "// local type" },
        "dataOutput": { type: "BPMN20__tDataOutput", isArray: true, fromType: "BPMN20__tInputOutputSpecification", xsdType: "// local type" },
        "inputSet": { type: "BPMN20__tInputSet", isArray: true, fromType: "BPMN20__tInputOutputSpecification", xsdType: "// local type" },
        "outputSet": { type: "BPMN20__tOutputSet", isArray: true, fromType: "BPMN20__tInputOutputSpecification", xsdType: "// local type" },
    },
    "BPMN20__tItemDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_structureRef": { type: "string", isArray: false, fromType: "BPMN20__tItemDefinition", xsdType: "xsd:QName" },
        "@_isCollection": { type: "boolean", isArray: false, fromType: "BPMN20__tItemDefinition", xsdType: "xsd:boolean" },
        "@_itemKind": { type: "BPMN20__tItemKind", isArray: false, fromType: "BPMN20__tItemDefinition", xsdType: "// local type" },
    },
    "BPMN20__tLane": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tLane", xsdType: "xsd:string" },
        "@_partitionElementRef": { type: "string", isArray: false, fromType: "BPMN20__tLane", xsdType: "xsd:QName" },
        "partitionElement": { type: "BPMN20__tBaseElement", isArray: false, fromType: "BPMN20__tLane", xsdType: "// local type" },
        "flowNodeRef": { type: "string", isArray: true, fromType: "BPMN20__tLane", xsdType: "xsd:IDREF" },
        "childLaneSet": { type: "BPMN20__tLaneSet", isArray: false, fromType: "BPMN20__tLane", xsdType: "// local type" },
    },
    "BPMN20__tLaneSet": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tLaneSet", xsdType: "xsd:string" },
        "lane": { type: "BPMN20__tLane", isArray: true, fromType: "BPMN20__tLaneSet", xsdType: "// local type" },
    },
    "BPMN20__tLinkEventDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tLinkEventDefinition", xsdType: "xsd:string" },
        "source": { type: "string", isArray: true, fromType: "BPMN20__tLinkEventDefinition", xsdType: "xsd:QName" },
        "target": { type: "string", isArray: false, fromType: "BPMN20__tLinkEventDefinition", xsdType: "xsd:QName" },
    },
    "BPMN20__tManualTask": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_isForCompensation": { type: "boolean", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:boolean" },
        "@_startQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_completionQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_default": { type: "string", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:IDREF" },
        "ioSpecification": { type: "BPMN20__tInputOutputSpecification", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "property": { type: "BPMN20__tProperty", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataInputAssociation": { type: "BPMN20__tDataInputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataOutputAssociation": { type: "BPMN20__tDataOutputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "resourceRole": { type: "BPMN20__tResourceRole", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "loopCharacteristics": { type: "BPMN20__tLoopCharacteristics", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
    },
    "BPMN20__tMessage": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tMessage", xsdType: "xsd:string" },
        "@_itemRef": { type: "string", isArray: false, fromType: "BPMN20__tMessage", xsdType: "xsd:QName" },
    },
    "BPMN20__tMessageEventDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_messageRef": { type: "string", isArray: false, fromType: "BPMN20__tMessageEventDefinition", xsdType: "xsd:QName" },
        "operationRef": { type: "string", isArray: false, fromType: "BPMN20__tMessageEventDefinition", xsdType: "xsd:QName" },
    },
    "BPMN20__tMessageFlow": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tMessageFlow", xsdType: "xsd:string" },
        "@_sourceRef": { type: "string", isArray: false, fromType: "BPMN20__tMessageFlow", xsdType: "xsd:QName" },
        "@_targetRef": { type: "string", isArray: false, fromType: "BPMN20__tMessageFlow", xsdType: "xsd:QName" },
        "@_messageRef": { type: "string", isArray: false, fromType: "BPMN20__tMessageFlow", xsdType: "xsd:QName" },
    },
    "BPMN20__tMessageFlowAssociation": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_innerMessageFlowRef": { type: "string", isArray: false, fromType: "BPMN20__tMessageFlowAssociation", xsdType: "xsd:QName" },
        "@_outerMessageFlowRef": { type: "string", isArray: false, fromType: "BPMN20__tMessageFlowAssociation", xsdType: "xsd:QName" },
    },
    "BPMN20__tMonitoring": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
    },
    "BPMN20__tMultiInstanceLoopCharacteristics": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_isSequential": { type: "boolean", isArray: false, fromType: "BPMN20__tMultiInstanceLoopCharacteristics", xsdType: "xsd:boolean" },
        "@_behavior": { type: "BPMN20__tMultiInstanceFlowCondition", isArray: false, fromType: "BPMN20__tMultiInstanceLoopCharacteristics", xsdType: "// local type" },
        "@_oneBehaviorEventRef": { type: "string", isArray: false, fromType: "BPMN20__tMultiInstanceLoopCharacteristics", xsdType: "xsd:QName" },
        "@_noneBehaviorEventRef": { type: "string", isArray: false, fromType: "BPMN20__tMultiInstanceLoopCharacteristics", xsdType: "xsd:QName" },
        "loopCardinality": { type: "BPMN20__tExpression", isArray: false, fromType: "BPMN20__tMultiInstanceLoopCharacteristics", xsdType: "// local type" },
        "loopDataInputRef": { type: "string", isArray: false, fromType: "BPMN20__tMultiInstanceLoopCharacteristics", xsdType: "xsd:QName" },
        "loopDataOutputRef": { type: "string", isArray: false, fromType: "BPMN20__tMultiInstanceLoopCharacteristics", xsdType: "xsd:QName" },
        "inputDataItem": { type: "BPMN20__tDataInput", isArray: false, fromType: "BPMN20__tMultiInstanceLoopCharacteristics", xsdType: "// local type" },
        "outputDataItem": { type: "BPMN20__tDataOutput", isArray: false, fromType: "BPMN20__tMultiInstanceLoopCharacteristics", xsdType: "// local type" },
        "complexBehaviorDefinition": { type: "BPMN20__tComplexBehaviorDefinition", isArray: true, fromType: "BPMN20__tMultiInstanceLoopCharacteristics", xsdType: "// local type" },
        "completionCondition": { type: "BPMN20__tExpression", isArray: false, fromType: "BPMN20__tMultiInstanceLoopCharacteristics", xsdType: "// local type" },
    },
    "BPMN20__tOperation": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tOperation", xsdType: "xsd:string" },
        "@_implementationRef": { type: "string", isArray: false, fromType: "BPMN20__tOperation", xsdType: "xsd:QName" },
        "inMessageRef": { type: "string", isArray: false, fromType: "BPMN20__tOperation", xsdType: "xsd:QName" },
        "outMessageRef": { type: "string", isArray: false, fromType: "BPMN20__tOperation", xsdType: "xsd:QName" },
        "errorRef": { type: "string", isArray: true, fromType: "BPMN20__tOperation", xsdType: "xsd:QName" },
    },
    "BPMN20__tOutputSet": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tOutputSet", xsdType: "xsd:string" },
        "dataOutputRefs": { type: "string", isArray: true, fromType: "BPMN20__tOutputSet", xsdType: "xsd:IDREF" },
        "optionalOutputRefs": { type: "string", isArray: true, fromType: "BPMN20__tOutputSet", xsdType: "xsd:IDREF" },
        "whileExecutingOutputRefs": { type: "string", isArray: true, fromType: "BPMN20__tOutputSet", xsdType: "xsd:IDREF" },
        "inputSetRefs": { type: "string", isArray: true, fromType: "BPMN20__tOutputSet", xsdType: "xsd:IDREF" },
    },
    "BPMN20__tParallelGateway": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_gatewayDirection": { type: "BPMN20__tGatewayDirection", isArray: false, fromType: "BPMN20__tGateway", xsdType: "// local type" },
    },
    "BPMN20__tParticipant": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tParticipant", xsdType: "xsd:string" },
        "@_processRef": { type: "string", isArray: false, fromType: "BPMN20__tParticipant", xsdType: "xsd:QName" },
        "interfaceRef": { type: "string", isArray: true, fromType: "BPMN20__tParticipant", xsdType: "xsd:QName" },
        "endPointRef": { type: "string", isArray: true, fromType: "BPMN20__tParticipant", xsdType: "xsd:QName" },
        "participantMultiplicity": { type: "BPMN20__tParticipantMultiplicity", isArray: false, fromType: "BPMN20__tParticipant", xsdType: "// local type" },
    },
    "BPMN20__tParticipantAssociation": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "innerParticipantRef": { type: "string", isArray: false, fromType: "BPMN20__tParticipantAssociation", xsdType: "xsd:QName" },
        "outerParticipantRef": { type: "string", isArray: false, fromType: "BPMN20__tParticipantAssociation", xsdType: "xsd:QName" },
    },
    "BPMN20__tParticipantMultiplicity": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_minimum": { type: "integer", isArray: false, fromType: "BPMN20__tParticipantMultiplicity", xsdType: "xsd:int" },
        "@_maximum": { type: "integer", isArray: false, fromType: "BPMN20__tParticipantMultiplicity", xsdType: "xsd:int" },
    },
    "BPMN20__tPartnerEntity": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tPartnerEntity", xsdType: "xsd:string" },
        "participantRef": { type: "string", isArray: true, fromType: "BPMN20__tPartnerEntity", xsdType: "xsd:QName" },
    },
    "BPMN20__tPartnerRole": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tPartnerRole", xsdType: "xsd:string" },
        "participantRef": { type: "string", isArray: true, fromType: "BPMN20__tPartnerRole", xsdType: "xsd:QName" },
    },
    "BPMN20__tPerformer": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tResourceRole", xsdType: "xsd:string" },
        "resourceAssignmentExpression": { type: "BPMN20__tResourceAssignmentExpression", isArray: false, fromType: "BPMN20__tResourceRole", xsdType: "// local type" },
        "resourceRef": { type: "string", isArray: false, fromType: "BPMN20__tResourceRole", xsdType: "xsd:QName" },
        "resourceParameterBinding": { type: "BPMN20__tResourceParameterBinding", isArray: true, fromType: "BPMN20__tResourceRole", xsdType: "// local type" },
    },
    "BPMN20__tPotentialOwner": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tResourceRole", xsdType: "xsd:string" },
        "resourceAssignmentExpression": { type: "BPMN20__tResourceAssignmentExpression", isArray: false, fromType: "BPMN20__tResourceRole", xsdType: "// local type" },
        "resourceRef": { type: "string", isArray: false, fromType: "BPMN20__tResourceRole", xsdType: "xsd:QName" },
        "resourceParameterBinding": { type: "BPMN20__tResourceParameterBinding", isArray: true, fromType: "BPMN20__tResourceRole", xsdType: "// local type" },
    },
    "BPMN20__tProcess": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tCallableElement", xsdType: "xsd:string" },
        "supportedInterfaceRef": { type: "string", isArray: true, fromType: "BPMN20__tCallableElement", xsdType: "xsd:QName" },
        "ioSpecification": { type: "BPMN20__tInputOutputSpecification", isArray: false, fromType: "BPMN20__tCallableElement", xsdType: "// local type" },
        "ioBinding": { type: "BPMN20__tInputOutputBinding", isArray: true, fromType: "BPMN20__tCallableElement", xsdType: "// local type" },
        "@_processType": { type: "BPMN20__tProcessType", isArray: false, fromType: "BPMN20__tProcess", xsdType: "// local type" },
        "@_isClosed": { type: "boolean", isArray: false, fromType: "BPMN20__tProcess", xsdType: "xsd:boolean" },
        "@_isExecutable": { type: "boolean", isArray: false, fromType: "BPMN20__tProcess", xsdType: "xsd:boolean" },
        "@_definitionalCollaborationRef": { type: "string", isArray: false, fromType: "BPMN20__tProcess", xsdType: "xsd:QName" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tProcess", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tProcess", xsdType: "// local type" },
        "property": { type: "BPMN20__tProperty", isArray: true, fromType: "BPMN20__tProcess", xsdType: "// local type" },
        "laneSet": { type: "BPMN20__tLaneSet", isArray: true, fromType: "BPMN20__tProcess", xsdType: "// local type" },
        "flowElement": { type: "BPMN20__tFlowElement", isArray: true, fromType: "BPMN20__tProcess", xsdType: "// local type" },
        "artifact": { type: "BPMN20__tArtifact", isArray: true, fromType: "BPMN20__tProcess", xsdType: "// local type" },
        "resourceRole": { type: "BPMN20__tResourceRole", isArray: true, fromType: "BPMN20__tProcess", xsdType: "// local type" },
        "correlationSubscription": { type: "BPMN20__tCorrelationSubscription", isArray: true, fromType: "BPMN20__tProcess", xsdType: "// local type" },
        "supports": { type: "string", isArray: true, fromType: "BPMN20__tProcess", xsdType: "xsd:QName" },
    },
    "BPMN20__tProperty": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tProperty", xsdType: "xsd:string" },
        "@_itemSubjectRef": { type: "string", isArray: false, fromType: "BPMN20__tProperty", xsdType: "xsd:QName" },
        "dataState": { type: "BPMN20__tDataState", isArray: false, fromType: "BPMN20__tProperty", xsdType: "// local type" },
    },
    "BPMN20__tReceiveTask": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_isForCompensation": { type: "boolean", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:boolean" },
        "@_startQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_completionQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_default": { type: "string", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:IDREF" },
        "ioSpecification": { type: "BPMN20__tInputOutputSpecification", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "property": { type: "BPMN20__tProperty", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataInputAssociation": { type: "BPMN20__tDataInputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataOutputAssociation": { type: "BPMN20__tDataOutputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "resourceRole": { type: "BPMN20__tResourceRole", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "loopCharacteristics": { type: "BPMN20__tLoopCharacteristics", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "@_implementation": { type: "BPMN20__tImplementation", isArray: false, fromType: "BPMN20__tReceiveTask", xsdType: "// local type" },
        "@_instantiate": { type: "boolean", isArray: false, fromType: "BPMN20__tReceiveTask", xsdType: "xsd:boolean" },
        "@_messageRef": { type: "string", isArray: false, fromType: "BPMN20__tReceiveTask", xsdType: "xsd:QName" },
        "@_operationRef": { type: "string", isArray: false, fromType: "BPMN20__tReceiveTask", xsdType: "xsd:QName" },
    },
    "BPMN20__tRelationship": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_type": { type: "string", isArray: false, fromType: "BPMN20__tRelationship", xsdType: "xsd:string" },
        "@_direction": { type: "BPMN20__tRelationshipDirection", isArray: false, fromType: "BPMN20__tRelationship", xsdType: "// local type" },
        "source": { type: "string", isArray: true, fromType: "BPMN20__tRelationship", xsdType: "xsd:QName" },
        "target": { type: "string", isArray: true, fromType: "BPMN20__tRelationship", xsdType: "xsd:QName" },
    },
    "BPMN20__tRendering": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
    },
    "BPMN20__tResource": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tResource", xsdType: "xsd:string" },
        "resourceParameter": { type: "BPMN20__tResourceParameter", isArray: true, fromType: "BPMN20__tResource", xsdType: "// local type" },
    },
    "BPMN20__tResourceAssignmentExpression": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "expression": { type: "BPMN20__tExpression", isArray: false, fromType: "BPMN20__tResourceAssignmentExpression", xsdType: "// local type" },
    },
    "BPMN20__tResourceParameter": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tResourceParameter", xsdType: "xsd:string" },
        "@_type": { type: "string", isArray: false, fromType: "BPMN20__tResourceParameter", xsdType: "xsd:QName" },
        "@_isRequired": { type: "boolean", isArray: false, fromType: "BPMN20__tResourceParameter", xsdType: "xsd:boolean" },
    },
    "BPMN20__tResourceParameterBinding": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_parameterRef": { type: "string", isArray: false, fromType: "BPMN20__tResourceParameterBinding", xsdType: "xsd:QName" },
        "expression": { type: "BPMN20__tExpression", isArray: false, fromType: "BPMN20__tResourceParameterBinding", xsdType: "// local type" },
    },
    "BPMN20__tResourceRole": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tResourceRole", xsdType: "xsd:string" },
        "resourceAssignmentExpression": { type: "BPMN20__tResourceAssignmentExpression", isArray: false, fromType: "BPMN20__tResourceRole", xsdType: "// local type" },
        "resourceRef": { type: "string", isArray: false, fromType: "BPMN20__tResourceRole", xsdType: "xsd:QName" },
        "resourceParameterBinding": { type: "BPMN20__tResourceParameterBinding", isArray: true, fromType: "BPMN20__tResourceRole", xsdType: "// local type" },
    },
    "BPMN20__tScriptTask": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_isForCompensation": { type: "boolean", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:boolean" },
        "@_startQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_completionQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_default": { type: "string", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:IDREF" },
        "ioSpecification": { type: "BPMN20__tInputOutputSpecification", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "property": { type: "BPMN20__tProperty", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataInputAssociation": { type: "BPMN20__tDataInputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataOutputAssociation": { type: "BPMN20__tDataOutputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "resourceRole": { type: "BPMN20__tResourceRole", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "loopCharacteristics": { type: "BPMN20__tLoopCharacteristics", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "@_scriptFormat": { type: "string", isArray: false, fromType: "BPMN20__tScriptTask", xsdType: "xsd:string" },
        "script": { type: "BPMN20__tScript", isArray: false, fromType: "BPMN20__tScriptTask", xsdType: "// local type" },
    },
    "BPMN20__tScript": {},
    "BPMN20__tSendTask": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_isForCompensation": { type: "boolean", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:boolean" },
        "@_startQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_completionQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_default": { type: "string", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:IDREF" },
        "ioSpecification": { type: "BPMN20__tInputOutputSpecification", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "property": { type: "BPMN20__tProperty", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataInputAssociation": { type: "BPMN20__tDataInputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataOutputAssociation": { type: "BPMN20__tDataOutputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "resourceRole": { type: "BPMN20__tResourceRole", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "loopCharacteristics": { type: "BPMN20__tLoopCharacteristics", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "@_implementation": { type: "BPMN20__tImplementation", isArray: false, fromType: "BPMN20__tSendTask", xsdType: "// local type" },
        "@_messageRef": { type: "string", isArray: false, fromType: "BPMN20__tSendTask", xsdType: "xsd:QName" },
        "@_operationRef": { type: "string", isArray: false, fromType: "BPMN20__tSendTask", xsdType: "xsd:QName" },
    },
    "BPMN20__tSequenceFlow": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "@_sourceRef": { type: "string", isArray: false, fromType: "BPMN20__tSequenceFlow", xsdType: "xsd:IDREF" },
        "@_targetRef": { type: "string", isArray: false, fromType: "BPMN20__tSequenceFlow", xsdType: "xsd:IDREF" },
        "@_isImmediate": { type: "boolean", isArray: false, fromType: "BPMN20__tSequenceFlow", xsdType: "xsd:boolean" },
        "conditionExpression": { type: "BPMN20__tExpression", isArray: false, fromType: "BPMN20__tSequenceFlow", xsdType: "// local type" },
    },
    "BPMN20__tServiceTask": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_isForCompensation": { type: "boolean", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:boolean" },
        "@_startQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_completionQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_default": { type: "string", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:IDREF" },
        "ioSpecification": { type: "BPMN20__tInputOutputSpecification", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "property": { type: "BPMN20__tProperty", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataInputAssociation": { type: "BPMN20__tDataInputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataOutputAssociation": { type: "BPMN20__tDataOutputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "resourceRole": { type: "BPMN20__tResourceRole", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "loopCharacteristics": { type: "BPMN20__tLoopCharacteristics", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "@_implementation": { type: "BPMN20__tImplementation", isArray: false, fromType: "BPMN20__tServiceTask", xsdType: "// local type" },
        "@_operationRef": { type: "string", isArray: false, fromType: "BPMN20__tServiceTask", xsdType: "xsd:QName" },
    },
    "BPMN20__tSignal": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tSignal", xsdType: "xsd:string" },
        "@_structureRef": { type: "string", isArray: false, fromType: "BPMN20__tSignal", xsdType: "xsd:QName" },
    },
    "BPMN20__tSignalEventDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_signalRef": { type: "string", isArray: false, fromType: "BPMN20__tSignalEventDefinition", xsdType: "xsd:QName" },
    },
    "BPMN20__tStandardLoopCharacteristics": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_testBefore": { type: "boolean", isArray: false, fromType: "BPMN20__tStandardLoopCharacteristics", xsdType: "xsd:boolean" },
        "@_loopMaximum": { type: "integer", isArray: false, fromType: "BPMN20__tStandardLoopCharacteristics", xsdType: "xsd:integer" },
        "loopCondition": { type: "BPMN20__tExpression", isArray: false, fromType: "BPMN20__tStandardLoopCharacteristics", xsdType: "// local type" },
    },
    "BPMN20__tStartEvent": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "property": { type: "BPMN20__tProperty", isArray: true, fromType: "BPMN20__tEvent", xsdType: "// local type" },
        "@_parallelMultiple": { type: "boolean", isArray: false, fromType: "BPMN20__tCatchEvent", xsdType: "xsd:boolean" },
        "dataOutput": { type: "BPMN20__tDataOutput", isArray: true, fromType: "BPMN20__tCatchEvent", xsdType: "// local type" },
        "dataOutputAssociation": { type: "BPMN20__tDataOutputAssociation", isArray: true, fromType: "BPMN20__tCatchEvent", xsdType: "// local type" },
        "outputSet": { type: "BPMN20__tOutputSet", isArray: false, fromType: "BPMN20__tCatchEvent", xsdType: "// local type" },
        "eventDefinition": { type: "BPMN20__tEventDefinition", isArray: true, fromType: "BPMN20__tCatchEvent", xsdType: "// local type" },
        "eventDefinitionRef": { type: "string", isArray: true, fromType: "BPMN20__tCatchEvent", xsdType: "xsd:QName" },
        "@_isInterrupting": { type: "boolean", isArray: false, fromType: "BPMN20__tStartEvent", xsdType: "xsd:boolean" },
    },
    "BPMN20__tSubChoreography": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_initiatingParticipantRef": { type: "string", isArray: false, fromType: "BPMN20__tChoreographyActivity", xsdType: "xsd:QName" },
        "@_loopType": { type: "BPMN20__tChoreographyLoopType", isArray: false, fromType: "BPMN20__tChoreographyActivity", xsdType: "// local type" },
        "participantRef": { type: "string", isArray: true, fromType: "BPMN20__tChoreographyActivity", xsdType: "xsd:QName" },
        "correlationKey": { type: "BPMN20__tCorrelationKey", isArray: true, fromType: "BPMN20__tChoreographyActivity", xsdType: "// local type" },
        "flowElement": { type: "BPMN20__tFlowElement", isArray: true, fromType: "BPMN20__tSubChoreography", xsdType: "// local type" },
        "artifact": { type: "BPMN20__tArtifact", isArray: true, fromType: "BPMN20__tSubChoreography", xsdType: "// local type" },
    },
    "BPMN20__tSubConversation": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tConversationNode", xsdType: "xsd:string" },
        "participantRef": { type: "string", isArray: true, fromType: "BPMN20__tConversationNode", xsdType: "xsd:QName" },
        "messageFlowRef": { type: "string", isArray: true, fromType: "BPMN20__tConversationNode", xsdType: "xsd:QName" },
        "correlationKey": { type: "BPMN20__tCorrelationKey", isArray: true, fromType: "BPMN20__tConversationNode", xsdType: "// local type" },
        "conversationNode": { type: "BPMN20__tConversationNode", isArray: true, fromType: "BPMN20__tSubConversation", xsdType: "// local type" },
    },
    "BPMN20__tSubProcess": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_isForCompensation": { type: "boolean", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:boolean" },
        "@_startQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_completionQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_default": { type: "string", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:IDREF" },
        "ioSpecification": { type: "BPMN20__tInputOutputSpecification", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "property": { type: "BPMN20__tProperty", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataInputAssociation": { type: "BPMN20__tDataInputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataOutputAssociation": { type: "BPMN20__tDataOutputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "resourceRole": { type: "BPMN20__tResourceRole", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "loopCharacteristics": { type: "BPMN20__tLoopCharacteristics", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "@_triggeredByEvent": { type: "boolean", isArray: false, fromType: "BPMN20__tSubProcess", xsdType: "xsd:boolean" },
        "laneSet": { type: "BPMN20__tLaneSet", isArray: true, fromType: "BPMN20__tSubProcess", xsdType: "// local type" },
        "flowElement": { type: "BPMN20__tFlowElement", isArray: true, fromType: "BPMN20__tSubProcess", xsdType: "// local type" },
        "artifact": { type: "BPMN20__tArtifact", isArray: true, fromType: "BPMN20__tSubProcess", xsdType: "// local type" },
    },
    "BPMN20__tTask": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_isForCompensation": { type: "boolean", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:boolean" },
        "@_startQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_completionQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_default": { type: "string", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:IDREF" },
        "ioSpecification": { type: "BPMN20__tInputOutputSpecification", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "property": { type: "BPMN20__tProperty", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataInputAssociation": { type: "BPMN20__tDataInputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataOutputAssociation": { type: "BPMN20__tDataOutputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "resourceRole": { type: "BPMN20__tResourceRole", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "loopCharacteristics": { type: "BPMN20__tLoopCharacteristics", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
    },
    "BPMN20__tTerminateEventDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
    },
    "BPMN20__tTextAnnotation": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_textFormat": { type: "string", isArray: false, fromType: "BPMN20__tTextAnnotation", xsdType: "xsd:string" },
        "text": { type: "BPMN20__tText", isArray: false, fromType: "BPMN20__tTextAnnotation", xsdType: "// local type" },
    },
    "BPMN20__tText": {},
    "BPMN20__tTimerEventDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "timeDate": { type: "BPMN20__tExpression", isArray: false, fromType: "BPMN20__tTimerEventDefinition", xsdType: "// local type" },
        "timeDuration": { type: "BPMN20__tExpression", isArray: false, fromType: "BPMN20__tTimerEventDefinition", xsdType: "// local type" },
        "timeCycle": { type: "BPMN20__tExpression", isArray: false, fromType: "BPMN20__tTimerEventDefinition", xsdType: "// local type" },
    },
    "BPMN20__tTransaction": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_isForCompensation": { type: "boolean", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:boolean" },
        "@_startQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_completionQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_default": { type: "string", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:IDREF" },
        "ioSpecification": { type: "BPMN20__tInputOutputSpecification", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "property": { type: "BPMN20__tProperty", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataInputAssociation": { type: "BPMN20__tDataInputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataOutputAssociation": { type: "BPMN20__tDataOutputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "resourceRole": { type: "BPMN20__tResourceRole", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "loopCharacteristics": { type: "BPMN20__tLoopCharacteristics", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "@_triggeredByEvent": { type: "boolean", isArray: false, fromType: "BPMN20__tSubProcess", xsdType: "xsd:boolean" },
        "laneSet": { type: "BPMN20__tLaneSet", isArray: true, fromType: "BPMN20__tSubProcess", xsdType: "// local type" },
        "flowElement": { type: "BPMN20__tFlowElement", isArray: true, fromType: "BPMN20__tSubProcess", xsdType: "// local type" },
        "artifact": { type: "BPMN20__tArtifact", isArray: true, fromType: "BPMN20__tSubProcess", xsdType: "// local type" },
        "@_method": { type: "BPMN20__tTransactionMethod", isArray: false, fromType: "BPMN20__tTransaction", xsdType: "// local type" },
    },
    "BPMN20__tUserTask": {
        "@_id": { type: "string", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "xsd:ID" },
        "documentation": { type: "BPMN20__tDocumentation", isArray: true, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "extensionElements": { type: "BPMN20__tExtensionElements", isArray: false, fromType: "BPMN20__tBaseElement", xsdType: "// local type" },
        "@_name": { type: "string", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "xsd:string" },
        "auditing": { type: "BPMN20__tAuditing", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "monitoring": { type: "BPMN20__tMonitoring", isArray: false, fromType: "BPMN20__tFlowElement", xsdType: "// local type" },
        "categoryValueRef": { type: "string", isArray: true, fromType: "BPMN20__tFlowElement", xsdType: "xsd:QName" },
        "incoming": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "outgoing": { type: "string", isArray: true, fromType: "BPMN20__tFlowNode", xsdType: "xsd:QName" },
        "@_isForCompensation": { type: "boolean", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:boolean" },
        "@_startQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_completionQuantity": { type: "integer", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:integer" },
        "@_default": { type: "string", isArray: false, fromType: "BPMN20__tActivity", xsdType: "xsd:IDREF" },
        "ioSpecification": { type: "BPMN20__tInputOutputSpecification", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "property": { type: "BPMN20__tProperty", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataInputAssociation": { type: "BPMN20__tDataInputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "dataOutputAssociation": { type: "BPMN20__tDataOutputAssociation", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "resourceRole": { type: "BPMN20__tResourceRole", isArray: true, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "loopCharacteristics": { type: "BPMN20__tLoopCharacteristics", isArray: false, fromType: "BPMN20__tActivity", xsdType: "// local type" },
        "@_implementation": { type: "BPMN20__tImplementation", isArray: false, fromType: "BPMN20__tUserTask", xsdType: "// local type" },
        "rendering": { type: "BPMN20__tRendering", isArray: true, fromType: "BPMN20__tUserTask", xsdType: "// local type" },
    },
    "BPMNDI__BPMNDiagram": {
        "@_name": { type: "string", isArray: false, fromType: "DI__Diagram", xsdType: "xsd:string" },
        "@_documentation": { type: "string", isArray: false, fromType: "DI__Diagram", xsdType: "xsd:string" },
        "@_resolution": { type: "float", isArray: false, fromType: "DI__Diagram", xsdType: "xsd:double" },
        "@_id": { type: "string", isArray: false, fromType: "DI__Diagram", xsdType: "xsd:ID" },
        "bpmndi:BPMNPlane": { type: "BPMNDI__BPMNPlane", isArray: false, fromType: "BPMNDI__BPMNDiagram", xsdType: "type found from namespace with declaration name 'bpmndi'." },
        "bpmndi:BPMNLabelStyle": { type: "BPMNDI__BPMNLabelStyle", isArray: true, fromType: "BPMNDI__BPMNDiagram", xsdType: "type found from namespace with declaration name 'bpmndi'." },
    },
    "BPMNDI__BPMNPlane__extension": {},
    "BPMNDI__BPMNPlane": {
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "BPMNDI__BPMNPlane__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:DiagramElement": { type: "DI__DiagramElement", isArray: true, fromType: "DI__Plane", xsdType: "type found from namespace with declaration name 'di'." },
        "@_bpmnElement": { type: "string", isArray: false, fromType: "BPMNDI__BPMNPlane", xsdType: "xsd:QName" },
    },
    "BPMNDI__BPMNEdge__extension": {},
    "BPMNDI__BPMNEdge": {
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "BPMNDI__BPMNEdge__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:waypoint": { type: "DC__Point", isArray: true, fromType: "DI__Edge", xsdType: "type found from namespace with declaration name 'dc'." },
        "@_bpmnElement": { type: "string", isArray: false, fromType: "BPMNDI__BPMNEdge", xsdType: "xsd:QName" },
        "@_sourceElement": { type: "string", isArray: false, fromType: "BPMNDI__BPMNEdge", xsdType: "xsd:QName" },
        "@_targetElement": { type: "string", isArray: false, fromType: "BPMNDI__BPMNEdge", xsdType: "xsd:QName" },
        "@_messageVisibleKind": { type: "BPMNDI__MessageVisibleKind", isArray: false, fromType: "BPMNDI__BPMNEdge", xsdType: "type found from namespace with declaration name 'bpmndi'." },
        "bpmndi:BPMNLabel": { type: "BPMNDI__BPMNLabel", isArray: false, fromType: "BPMNDI__BPMNEdge", xsdType: "type found from namespace with declaration name 'bpmndi'." },
    },
    "BPMNDI__BPMNShape__extension": {},
    "BPMNDI__BPMNShape": {
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "BPMNDI__BPMNShape__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "dc:Bounds": { type: "DC__Bounds", isArray: false, fromType: "DI__Shape", xsdType: "type found from namespace with declaration name 'dc'." },
        "@_bpmnElement": { type: "string", isArray: false, fromType: "BPMNDI__BPMNShape", xsdType: "xsd:QName" },
        "@_isHorizontal": { type: "boolean", isArray: false, fromType: "BPMNDI__BPMNShape", xsdType: "xsd:boolean" },
        "@_isExpanded": { type: "boolean", isArray: false, fromType: "BPMNDI__BPMNShape", xsdType: "xsd:boolean" },
        "@_isMarkerVisible": { type: "boolean", isArray: false, fromType: "BPMNDI__BPMNShape", xsdType: "xsd:boolean" },
        "@_isMessageVisible": { type: "boolean", isArray: false, fromType: "BPMNDI__BPMNShape", xsdType: "xsd:boolean" },
        "@_participantBandKind": { type: "BPMNDI__ParticipantBandKind", isArray: false, fromType: "BPMNDI__BPMNShape", xsdType: "type found from namespace with declaration name 'bpmndi'." },
        "@_choreographyActivityShape": { type: "string", isArray: false, fromType: "BPMNDI__BPMNShape", xsdType: "xsd:QName" },
        "bpmndi:BPMNLabel": { type: "BPMNDI__BPMNLabel", isArray: false, fromType: "BPMNDI__BPMNShape", xsdType: "type found from namespace with declaration name 'bpmndi'." },
    },
    "BPMNDI__BPMNLabel__extension": {},
    "BPMNDI__BPMNLabel": {
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "BPMNDI__BPMNLabel__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "dc:Bounds": { type: "DC__Bounds", isArray: false, fromType: "DI__Label", xsdType: "type found from namespace with declaration name 'dc'." },
        "@_labelStyle": { type: "string", isArray: false, fromType: "BPMNDI__BPMNLabel", xsdType: "xsd:QName" },
    },
    "BPMNDI__BPMNLabelStyle": {
        "@_id": { type: "string", isArray: false, fromType: "DI__Style", xsdType: "xsd:ID" },
        "dc:Font": { type: "DC__Font", isArray: false, fromType: "BPMNDI__BPMNLabelStyle", xsdType: "type found from namespace with declaration name 'dc'." },
    },
    "DC__Font": {
        "@_name": { type: "string", isArray: false, fromType: "DC__Font", xsdType: "xsd:string" },
        "@_size": { type: "float", isArray: false, fromType: "DC__Font", xsdType: "xsd:double" },
        "@_isBold": { type: "boolean", isArray: false, fromType: "DC__Font", xsdType: "xsd:boolean" },
        "@_isItalic": { type: "boolean", isArray: false, fromType: "DC__Font", xsdType: "xsd:boolean" },
        "@_isUnderline": { type: "boolean", isArray: false, fromType: "DC__Font", xsdType: "xsd:boolean" },
        "@_isStrikeThrough": { type: "boolean", isArray: false, fromType: "DC__Font", xsdType: "xsd:boolean" },
    },
    "DC__Point": {
        "@_x": { type: "float", isArray: false, fromType: "DC__Point", xsdType: "xsd:double" },
        "@_y": { type: "float", isArray: false, fromType: "DC__Point", xsdType: "xsd:double" },
    },
    "DC__Bounds": {
        "@_x": { type: "float", isArray: false, fromType: "DC__Bounds", xsdType: "xsd:double" },
        "@_y": { type: "float", isArray: false, fromType: "DC__Bounds", xsdType: "xsd:double" },
        "@_width": { type: "float", isArray: false, fromType: "DC__Bounds", xsdType: "xsd:double" },
        "@_height": { type: "float", isArray: false, fromType: "DC__Bounds", xsdType: "xsd:double" },
    },
    "DI__DiagramElement__extension": {},
    "DI__Node__extension": {},
    "DI__Edge__extension": {},
    "DI__LabeledEdge__extension": {},
    "DI__Shape__extension": {},
    "DI__LabeledShape__extension": {},
    "DI__Label__extension": {},
    "DI__Plane__extension": {},
};
//# sourceMappingURL=meta.js.map