"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.doRefValidation = void 0;
var findNodesAtLocation_1 = require("./findNodesAtLocation");
function doRefValidation(args) {
    return __spreadArray([], __read(args.validationMap.entries()), false).flatMap(function (_a) {
        var _b = __read(_a, 2), src = _b[0], refs = _b[1];
        var sourceNodeValues = new Set((0, findNodesAtLocation_1.findNodesAtLocation)({ root: args.rootNode, path: src.path })
            .filter(function (node) { return (node === null || node === void 0 ? void 0 : node.type) === "string"; })
            .flatMap(function (node) { return node.value; }));
        return refs.flatMap(function (ref) {
            return (0, findNodesAtLocation_1.findNodesAtLocation)({ root: args.rootNode, path: ref.path })
                .flatMap(function (refNode) {
                var _a;
                if (refNode.type === ref.type) {
                    return [refNode];
                }
                if (areArraysOfMatchingType({ ref: ref, refNode: refNode })) {
                    return (_a = refNode.children) !== null && _a !== void 0 ? _a : [];
                }
                return [];
            })
                .flatMap(function (refNode) {
                if (sourceNodeValues.has(refNode.value)) {
                    return [];
                }
                return [
                    {
                        message: "Missing '".concat(refNode.value, "' in '").concat(src.name, "'"),
                        range: {
                            start: args.textDocument.positionAt(refNode.offset),
                            end: args.textDocument.positionAt(refNode.offset + refNode.length),
                        },
                    },
                ];
            });
        });
    });
}
exports.doRefValidation = doRefValidation;
function areArraysOfMatchingType(args) {
    var _a;
    return (args.ref.isArray &&
        args.refNode.type === "array" &&
        ((_a = args.refNode.children) === null || _a === void 0 ? void 0 : _a.every(function (child) { return child.type === args.ref.type; })));
}
//# sourceMappingURL=refValidation.js.map