"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.composeEnv = exports.varsWithName = exports.getOrDefault = exports.get = exports.str2bool = void 0;
var console_logs_1 = require("./console_logs");
function str2bool(str) {
    return str === "true";
}
exports.str2bool = str2bool;
function get(envVar) {
    return process.env[envVar.name];
}
exports.get = get;
function getOrDefault(envVar) {
    var _a;
    return (_a = get(envVar)) !== null && _a !== void 0 ? _a : envVar.default;
}
exports.getOrDefault = getOrDefault;
function varsWithName(obj) {
    __spreadArray([], __read(Object.keys(obj)), false).forEach(function (key) {
        obj[key]["name"] = key;
    });
    return obj;
}
exports.varsWithName = varsWithName;
function composeEnv(deps, self) {
    var selfEnvs = __spreadArray(__spreadArray([], __read(deps.map(function (s) { return s.self; })), false), [self], false);
    return {
        vars: selfEnvs.reduce(function (acc, d) {
            var conflictingProps = detectConflictingProps(acc, d.vars);
            if (conflictingProps.length > 0) {
                console.error(console_logs_1.LOGS.error.foundConflictingVars());
                console.error(conflictingProps);
                throw new Error("[build-env] conflicting-vars-error");
            }
            return __assign(__assign({}, acc), d.vars);
        }, {}),
        env: selfEnvs.reduce(function (acc, d) {
            var conflictingProps = detectConflictingProps(acc, d.env);
            if (conflictingProps.length > 0) {
                console.error(console_logs_1.LOGS.error.foundConflictingRootProps());
                console.error(conflictingProps);
                throw new Error("[build-env] conflicting-root-props-error");
            }
            return __assign(__assign({}, acc), d.env);
        }, {}),
        self: self,
    };
}
exports.composeEnv = composeEnv;
function detectConflictingProps(acc, d) {
    var accProps = new Set(Object.keys(acc));
    return Object.keys(d).filter(function (a) { return accProps.has(a); });
}
//# sourceMappingURL=index.js.map