"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initCompletion = void 0;
var monaco = require("monaco-editor");
var monaco_editor_1 = require("monaco-editor");
var ls = require("vscode-languageserver-types");
var CompletionItemInsertTextRule = monaco_editor_1.languages.CompletionItemInsertTextRule;
function initCompletion(commandIds, channelApi) {
    var _this = this;
    return monaco.languages.registerCompletionItemProvider(["json", "yaml"], {
        triggerCharacters: [" ", ":", '"', "."],
        provideCompletionItems: function (model, cursorPosition, context, cancellationToken) { return __awaiter(_this, void 0, void 0, function () {
            var currentWordPosition, lsCompletionItems, monacoCompletionItems;
            var _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        currentWordPosition = model.getWordAtPosition(cursorPosition);
                        return [4, channelApi.requests.kogitoSwfLanguageService__getCompletionItems({
                                content: model.getValue(),
                                uri: model.uri.toString(),
                                cursorPosition: {
                                    line: cursorPosition.lineNumber - 1,
                                    character: cursorPosition.column - 1,
                                },
                                cursorWordRange: {
                                    start: {
                                        line: cursorPosition.lineNumber - 1,
                                        character: ((_a = currentWordPosition === null || currentWordPosition === void 0 ? void 0 : currentWordPosition.startColumn) !== null && _a !== void 0 ? _a : cursorPosition.column) - 1,
                                    },
                                    end: {
                                        line: cursorPosition.lineNumber - 1,
                                        character: ((_b = currentWordPosition === null || currentWordPosition === void 0 ? void 0 : currentWordPosition.endColumn) !== null && _b !== void 0 ? _b : cursorPosition.column) - 1,
                                    },
                                },
                            })];
                    case 1:
                        lsCompletionItems = _c.sent();
                        if (cancellationToken.isCancellationRequested) {
                            return [2, undefined];
                        }
                        monacoCompletionItems = lsCompletionItems.map(function (c) {
                            var _a, _b, _c;
                            return ({
                                kind: toMonacoCompletionItemKind(c.kind),
                                label: c.label,
                                sortText: c.sortText,
                                detail: c.detail,
                                filterText: c.filterText,
                                insertTextRules: c.insertTextFormat === ls.InsertTextFormat.Snippet ? CompletionItemInsertTextRule.InsertAsSnippet : undefined,
                                insertText: (_c = (_a = c.insertText) !== null && _a !== void 0 ? _a : (_b = c.textEdit) === null || _b === void 0 ? void 0 : _b.newText) !== null && _c !== void 0 ? _c : "",
                                command: c.command
                                    ? {
                                        id: commandIds[c.command.command],
                                        arguments: c.command.arguments,
                                        title: c.command.title,
                                    }
                                    : undefined,
                                range: {
                                    startLineNumber: c.textEdit.range.start.line + 1,
                                    startColumn: c.textEdit.range.start.character + 1,
                                    endLineNumber: c.textEdit.range.end.line + 1,
                                    endColumn: c.textEdit.range.end.character + 1,
                                },
                            });
                        });
                        return [2, {
                                suggestions: monacoCompletionItems,
                            }];
                }
            });
        }); },
    });
}
exports.initCompletion = initCompletion;
function toMonacoCompletionItemKind(lsCompletionItemKind) {
    switch (lsCompletionItemKind) {
        case ls.CompletionItemKind.Text:
            return monaco.languages.CompletionItemKind.Text;
        case ls.CompletionItemKind.Method:
            return monaco.languages.CompletionItemKind.Method;
        case ls.CompletionItemKind.Function:
            return monaco.languages.CompletionItemKind.Function;
        case ls.CompletionItemKind.Constructor:
            return monaco.languages.CompletionItemKind.Constructor;
        case ls.CompletionItemKind.Field:
            return monaco.languages.CompletionItemKind.Field;
        case ls.CompletionItemKind.Variable:
            return monaco.languages.CompletionItemKind.Variable;
        case ls.CompletionItemKind.Class:
            return monaco.languages.CompletionItemKind.Class;
        case ls.CompletionItemKind.Interface:
            return monaco.languages.CompletionItemKind.Interface;
        case ls.CompletionItemKind.Module:
            return monaco.languages.CompletionItemKind.Module;
        case ls.CompletionItemKind.Property:
            return monaco.languages.CompletionItemKind.Property;
        case ls.CompletionItemKind.Unit:
            return monaco.languages.CompletionItemKind.Unit;
        case ls.CompletionItemKind.Value:
            return monaco.languages.CompletionItemKind.Value;
        case ls.CompletionItemKind.Enum:
            return monaco.languages.CompletionItemKind.Enum;
        case ls.CompletionItemKind.Keyword:
            return monaco.languages.CompletionItemKind.Keyword;
        case ls.CompletionItemKind.Snippet:
            return monaco.languages.CompletionItemKind.Snippet;
        case ls.CompletionItemKind.Color:
            return monaco.languages.CompletionItemKind.Color;
        case ls.CompletionItemKind.File:
            return monaco.languages.CompletionItemKind.File;
        case ls.CompletionItemKind.Reference:
            return monaco.languages.CompletionItemKind.Reference;
        case ls.CompletionItemKind.Folder:
            return monaco.languages.CompletionItemKind.Folder;
        case ls.CompletionItemKind.EnumMember:
            return monaco.languages.CompletionItemKind.EnumMember;
        case ls.CompletionItemKind.Constant:
            return monaco.languages.CompletionItemKind.Constant;
        case ls.CompletionItemKind.Struct:
            return monaco.languages.CompletionItemKind.Struct;
        case ls.CompletionItemKind.Event:
            return monaco.languages.CompletionItemKind.Event;
        case ls.CompletionItemKind.Operator:
            return monaco.languages.CompletionItemKind.Operator;
        case ls.CompletionItemKind.TypeParameter:
            return monaco.languages.CompletionItemKind.TypeParameter;
        default:
            throw new Error("Can't convert from LS Completion Kind to Monaco Completion Kind");
    }
}
//# sourceMappingURL=index.js.map