var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React, { useState } from "react";
import { EmptyState, EmptyStateIcon, EmptyStateVariant, EmptyStateBody, } from "@patternfly/react-core/dist/js/components/EmptyState";
import { PageSection } from "@patternfly/react-core/dist/js/components/Page";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { ExclamationCircleIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-circle-icon";
import { Redirect } from "react-router";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools/OuiaUtils";
export const PageNotFound = (_a) => {
    var { ouiaId, ouiaSafe } = _a, props = __rest(_a, ["ouiaId", "ouiaSafe"]);
    let prevPath;
    if (props.location.state !== undefined) {
        prevPath = props.location.state.prev;
    }
    else {
        prevPath = props.defaultPath;
    }
    const tempPath = prevPath === null || prevPath === void 0 ? void 0 : prevPath.split("/");
    prevPath = tempPath === null || tempPath === void 0 ? void 0 : tempPath.filter((item) => item);
    const [isRedirect, setIsredirect] = useState(false);
    const redirectHandler = () => {
        setIsredirect(true);
    };
    return (React.createElement(React.Fragment, null,
        isRedirect && React.createElement(Redirect, { to: `/${prevPath === null || prevPath === void 0 ? void 0 : prevPath[0]}` }),
        React.createElement(PageSection, Object.assign({ variant: "light" }, componentOuiaProps(ouiaId, "page-not-found", ouiaSafe ? ouiaSafe : !isRedirect)),
            React.createElement(Bullseye, null,
                React.createElement(EmptyState, { variant: EmptyStateVariant.full },
                    React.createElement(EmptyStateIcon, { icon: ExclamationCircleIcon, color: "var(--pf-global--danger-color--100)" }),
                    React.createElement(Title, { headingLevel: "h1", size: "4xl" }, "404 Error: page not found"),
                    React.createElement(EmptyStateBody, null, "This page could not be found."),
                    React.createElement(Button, { variant: "primary", onClick: redirectHandler, "data-testid": "redirect-button" }, props.defaultButton))))));
};
//# sourceMappingURL=PageNotFound.js.map