import React, { useImperativeHandle, useState } from "react";
import JSONSchemaBridge from "uniforms-bridge-json-schema";
import { AutoFields, AutoForm, ErrorsField } from "@kie-tools/uniforms-patternfly/dist/esm";
import { componentOuiaProps } from "../../ouiaTools";
import { lookupValidator, ModelConversionTool } from "../../utils";
import { FormFooter } from "../FormFooter";
import "../styles.css";
export const FormRenderer = React.forwardRef(({ formSchema, model, onSubmit, formActions, readOnly, ouiaId, ouiaSafe }, forwardedRef) => {
    const validator = lookupValidator(formSchema);
    const [formApiRef, setFormApiRef] = useState();
    useImperativeHandle(forwardedRef, () => {
        return {
            doReset() {
                formApiRef.reset();
            },
        };
    }, [formApiRef]);
    const bridge = new JSONSchemaBridge(formSchema, (formModel) => {
        const newModel = ModelConversionTool.convertDateToString(formModel, formSchema);
        return validator.validate(newModel);
    });
    const formData = ModelConversionTool.convertStringToDate(model, formSchema);
    const submitFormData = () => {
        formApiRef.submit();
    };
    return (React.createElement(React.Fragment, null,
        React.createElement(AutoForm, Object.assign({ ref: (ref) => setFormApiRef(ref), placeholder: true, model: formData, disabled: readOnly, schema: bridge, showInlineError: true, onSubmit: (data) => onSubmit && onSubmit(data) }, componentOuiaProps(ouiaId, "form-renderer", ouiaSafe)),
            React.createElement(ErrorsField, null),
            React.createElement(AutoFields, null)),
        React.createElement(FormFooter, { actions: formActions, enabled: !readOnly, onSubmitForm: submitFormData })));
});
//# sourceMappingURL=FormRenderer.js.map