var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React from "react";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { useWorkflowFormGatewayApi } from "../WorkflowForm";
import { EmbeddedWorkflowForm } from "@kie-tools/runtime-tools-swf-enveloped-components/dist/workflowForm";
export const WorkflowFormContainer = ({ workflowDefinitionData, onStartWorkflowSuccess, onStartWorkflowError, onResetForm, ouiaId, ouiaSafe, targetOrigin, }) => {
    const gatewayApi = useWorkflowFormGatewayApi();
    return (React.createElement(EmbeddedWorkflowForm, Object.assign({}, componentOuiaProps(ouiaId, "workflow-form-container", ouiaSafe), { driver: {
            getCustomWorkflowSchema() {
                return __awaiter(this, void 0, void 0, function* () {
                    return gatewayApi.getCustomWorkflowSchema(workflowDefinitionData.workflowName, workflowDefinitionData.serviceUrl);
                });
            },
            resetBusinessKey() {
                return __awaiter(this, void 0, void 0, function* () {
                    onResetForm();
                });
            },
            startWorkflow(endpoint, data) {
                return __awaiter(this, void 0, void 0, function* () {
                    return gatewayApi
                        .startWorkflow(endpoint, data)
                        .then((id) => {
                        onStartWorkflowSuccess(id);
                    })
                        .catch((error) => {
                        var _a, _b, _c, _d, _e, _f;
                        const message = (((_b = (_a = error === null || error === void 0 ? void 0 : error.response) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.message) &&
                            ((_d = (_c = error === null || error === void 0 ? void 0 : error.response) === null || _c === void 0 ? void 0 : _c.data) === null || _d === void 0 ? void 0 : _d.message) + " " + ((_f = (_e = error === null || error === void 0 ? void 0 : error.response) === null || _e === void 0 ? void 0 : _e.data) === null || _f === void 0 ? void 0 : _f.cause)) ||
                            (error === null || error === void 0 ? void 0 : error.message) ||
                            "Unknown error. More details in the developer tools console.";
                        onStartWorkflowError(message);
                    });
                });
            },
        }, targetOrigin: targetOrigin || window.location.origin, workflowDefinition: {
            workflowName: workflowDefinitionData.workflowName,
            endpoint: workflowDefinitionData.endpoint,
        } })));
};
//# sourceMappingURL=WorkflowFormContainer.js.map