var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { getJobs, getTriggerableNodes, getWorkflowDetails, handleJobReschedule, handleNodeInstanceCancel, handleNodeInstanceRetrigger, handleNodeTrigger, handleWorkflowAbort, handleWorkflowRetry, handleWorkflowSkip, handleWorkflowVariableUpdate, jobCancel, } from "@kie-tools/runtime-tools-swf-gateway-api/dist/gatewayApi";
export class GraphQLWorkflowDetailsQueries {
    constructor(client) {
        this.client = client;
    }
    getWorkflowDetails(id) {
        return __awaiter(this, void 0, void 0, function* () {
            return getWorkflowDetails(id, this.client);
        });
    }
    getJobs(id) {
        return __awaiter(this, void 0, void 0, function* () {
            return Promise.resolve(getJobs(id, this.client));
        });
    }
    handleWorkflowSkip(workflowInstance) {
        return __awaiter(this, void 0, void 0, function* () {
            return handleWorkflowSkip(workflowInstance, this.client);
        });
    }
    handleWorkflowAbort(workflowInstance) {
        return __awaiter(this, void 0, void 0, function* () {
            return handleWorkflowAbort(workflowInstance, this.client);
        });
    }
    handleWorkflowRetry(workflowInstance) {
        return __awaiter(this, void 0, void 0, function* () {
            return handleWorkflowRetry(workflowInstance, this.client);
        });
    }
    jobCancel(job) {
        return __awaiter(this, void 0, void 0, function* () {
            return jobCancel(job, this.client);
        });
    }
    rescheduleJob(job, repeatInterval, repeatLimit, scheduleDate) {
        return __awaiter(this, void 0, void 0, function* () {
            return handleJobReschedule(job, repeatInterval, repeatLimit, scheduleDate, this.client);
        });
    }
    getTriggerableNodes(workflowInstance) {
        return __awaiter(this, void 0, void 0, function* () {
            return Promise.resolve(getTriggerableNodes(workflowInstance, this.client));
        });
    }
    handleNodeTrigger(workflowInstance, node) {
        return __awaiter(this, void 0, void 0, function* () {
            return handleNodeTrigger(workflowInstance, node, this.client);
        });
    }
    handleNodeInstanceCancel(workflowInstance, node) {
        return __awaiter(this, void 0, void 0, function* () {
            return handleNodeInstanceCancel(workflowInstance, node, this.client);
        });
    }
    handleWorkflowVariableUpdate(workflowInstance, updateJson) {
        return __awaiter(this, void 0, void 0, function* () {
            return handleWorkflowVariableUpdate(workflowInstance, updateJson, this.client);
        });
    }
    handleNodeInstanceRetrigger(workflowInstance, node) {
        return __awaiter(this, void 0, void 0, function* () {
            return handleNodeInstanceRetrigger(workflowInstance, node, this.client);
        });
    }
}
//# sourceMappingURL=WorkflowDetailsQueries.js.map