import { NodeInstance, TriggerableNode } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
import { Job, JobCancel, WorkflowInstance } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
import { WorkflowDetailsQueries } from "./WorkflowDetailsQueries";
export interface OnOpenWorkflowInstanceDetailsListener {
    onOpen(id: string): void;
}
export interface WorkflowDetailsUnSubscribeHandler {
    unSubscribe: () => void;
}
export interface WorkflowDetailsState {
    id: string;
}
export interface WorkflowDetailsGatewayApi {
    workflowDetailsState: any;
    handleWorkflowAbort: (workflowInstance: WorkflowInstance) => Promise<void>;
    cancelJob: (job: Job) => Promise<JobCancel>;
    rescheduleJob: (job: Job, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date) => Promise<{
        modalTitle: string;
        modalContent: string;
    }>;
    getTriggerableNodes(workflowInstance: WorkflowInstance): Promise<TriggerableNode[]>;
    handleNodeTrigger(workflowInstance: WorkflowInstance, node: any): Promise<void>;
    handleWorkflowVariableUpdate: (workflowInstance: WorkflowInstance, updateJson: Record<string, unknown>) => Promise<Record<string, unknown>>;
    workflowDetailsQuery(id: string): Promise<WorkflowInstance>;
    jobsQuery(id: string): Promise<Job[]>;
    openWorkflowInstanceDetails(id: string): Promise<void>;
    onOpenWorkflowInstanceDetailsListener: (listener: OnOpenWorkflowInstanceDetailsListener) => WorkflowDetailsUnSubscribeHandler;
    handleWorkflowRetry: (workflowInstance: WorkflowInstance) => Promise<void>;
    handleNodeInstanceCancel: (workflowInstance: WorkflowInstance, node: NodeInstance) => Promise<void>;
    handleWorkflowSkip: (workflowInstance: WorkflowInstance) => Promise<void>;
    handleNodeInstanceRetrigger(workflowInstance: WorkflowInstance, node: NodeInstance): Promise<void>;
}
export declare class WorkflowDetailsGatewayApiImpl implements WorkflowDetailsGatewayApi {
    private readonly queries;
    private _WorkflowDetailsState;
    private readonly listeners;
    constructor(queries: WorkflowDetailsQueries);
    get workflowDetailsState(): WorkflowDetailsState;
    handleWorkflowAbort: (workflowInstance: WorkflowInstance) => Promise<void>;
    cancelJob: (job: Job) => Promise<JobCancel>;
    rescheduleJob: (job: Job, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date) => Promise<{
        modalTitle: string;
        modalContent: string;
    }>;
    getTriggerableNodes(workflowInstance: WorkflowInstance): Promise<TriggerableNode[]>;
    handleNodeTrigger(workflowInstance: WorkflowInstance, node: TriggerableNode): Promise<void>;
    handleWorkflowVariableUpdate: (workflowInstance: WorkflowInstance, updatedJson: Record<string, unknown>) => Promise<Record<string, unknown>>;
    workflowDetailsQuery(id: string): Promise<WorkflowInstance>;
    jobsQuery(id: string): Promise<Job[]>;
    openWorkflowInstanceDetails(id: string): Promise<void>;
    onOpenWorkflowInstanceDetailsListener(listener: OnOpenWorkflowInstanceDetailsListener): WorkflowDetailsUnSubscribeHandler;
    handleWorkflowRetry(workflowInstance: WorkflowInstance): Promise<void>;
    handleNodeInstanceCancel(workflowInstance: WorkflowInstance, node: NodeInstance): Promise<void>;
    handleWorkflowSkip(workflowInstance: WorkflowInstance): Promise<void>;
    handleNodeInstanceRetrigger(workflowInstance: WorkflowInstance, node: NodeInstance): Promise<void>;
}
//# sourceMappingURL=WorkflowDetailsGatewayApi.d.ts.map