"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.discoverCurrentGitHubPageType = exports.extractFileInfoFromUrl = exports.startExtension = void 0;
var GitHubPageType_1 = require("./app/github/GitHubPageType");
var singleEditorEdit_1 = require("./app/components/single/singleEditorEdit");
var singleEditorView_1 = require("./app/components/single/singleEditorView");
var prEditors_1 = require("./app/components/pr/prEditors");
var utils_1 = require("./app/utils");
var Dependencies_1 = require("./app/Dependencies");
var ReactDOM = require("react-dom");
require("../resources/style.css");
var Logger_1 = require("./Logger");
var ChromeResourceContentService_1 = require("./app/components/common/ChromeResourceContentService");
var openRepoInExternalEditorApp_1 = require("./app/components/openRepoInExternalEditor/openRepoInExternalEditorApp");
var channel_1 = require("@kie-tools-core/editor/dist/channel");
function startExtension(args) {
    var logger = new Logger_1.Logger(args.name);
    var resourceContentServiceFactory = new ChromeResourceContentService_1.ResourceContentServiceFactory();
    var dependencies = new Dependencies_1.Dependencies();
    var runInit = function () {
        var _a;
        var pageType = discoverCurrentGitHubPageType();
        var fileInfo = extractFileInfoFromUrl();
        var stateControl = new channel_1.StateControl();
        init({
            id: chrome.runtime.id,
            logger: logger,
            dependencies: dependencies,
            githubAuthTokenCookieName: args.githubAuthTokenCookieName,
            extensionIconUrl: args.extensionIconUrl,
            editorEnvelopeLocator: args.editorEnvelopeLocator,
            resourceContentServiceFactory: resourceContentServiceFactory,
            externalEditorManager: args.externalEditorManager,
            stateControl: stateControl,
            customChannelApiImpl: (_a = args.getCustomChannelApiImpl) === null || _a === void 0 ? void 0 : _a.call(args, pageType, fileInfo, stateControl),
        });
    };
    (0, utils_1.runAfterUriChange)(logger, function () { return setTimeout(runInit, 0); });
    setTimeout(runInit, 0);
}
exports.startExtension = startExtension;
function init(globals) {
    globals.logger.log("---");
    globals.logger.log("Starting GitHub extension.");
    unmountPreviouslyRenderedFeatures(globals.id, globals.logger, globals.dependencies, globals.editorEnvelopeLocator);
    var fileInfo = extractFileInfoFromUrl();
    var pageType = discoverCurrentGitHubPageType();
    if (!globals.dependencies.all.octiconMarkGitHub() || pageType === GitHubPageType_1.GitHubPageType.NOT_SUPPORTED) {
        globals.logger.warn("This is not supported GitHub web page. '".concat(window.location.origin).concat(window.location.pathname, "'"));
        return;
    }
    if (pageType === GitHubPageType_1.GitHubPageType.EDIT) {
        (0, singleEditorEdit_1.renderSingleEditorApp)(__assign(__assign({}, globals), { fileInfo: fileInfo }));
    }
    else if (pageType === GitHubPageType_1.GitHubPageType.VIEW) {
        if (!globals.dependencies.openRepoInExternalEditor.buttonContainerOnRepoFilesList()) {
            globals.logger.warn("The extension stopped working for this asset view. Please be sure you explore the asset with the latest GitHub instance.");
        }
        else {
            (0, singleEditorView_1.renderSingleEditorReadonlyApp)(__assign(__assign({}, globals), { pageType: pageType, className: "btn ml-2 d-none d-md-block", container: function () { return globals.dependencies.openRepoInExternalEditor.buttonContainerOnRepoFilesList(); }, fileInfo: fileInfo }));
        }
    }
    else if (pageType === GitHubPageType_1.GitHubPageType.PR_HOME ||
        pageType === GitHubPageType_1.GitHubPageType.PR_FILES ||
        pageType === GitHubPageType_1.GitHubPageType.PR_COMMITS) {
        if (!globals.dependencies.openRepoInExternalEditor.buttonContainerOnPrs()) {
            globals.logger.warn("The extension stopped working for this pull request view. Please be sure you explore the pull request on the latest GitHub instance.");
        }
        else {
            (0, prEditors_1.renderPrEditorsApp)(__assign(__assign({}, globals), { pageType: pageType, className: "btn btn-sm", container: function () { return globals.dependencies.openRepoInExternalEditor.buttonContainerOnPrs(); } }));
        }
    }
    else if (pageType === GitHubPageType_1.GitHubPageType.REPO_HOME) {
        if (!globals.dependencies.openRepoInExternalEditor.buttonContainerOnRepoHome()) {
            globals.logger.warn("The extension stopped working for this repository view. Please be sure you explore the repository on the latest GitHub instance.");
        }
        else {
            (0, openRepoInExternalEditorApp_1.renderOpenRepoInExternalEditorApp)(__assign(__assign({}, globals), { pageType: pageType, className: "btn btn-sm", container: function () { return globals.dependencies.openRepoInExternalEditor.buttonContainerOnRepoHome(); } }));
        }
    }
    else if (pageType === GitHubPageType_1.GitHubPageType.CAN_NOT_BE_DETERMINED_FROM_URL) {
        if (!globals.dependencies.openRepoInExternalEditor.buttonContainerOnRepoHome()) {
            globals.logger.warn("The extension stopped working for this view '".concat(window.location.origin).concat(window.location.pathname, "'. Please be sure you explore repository, asset or pull request on the latest GitHub instance."));
        }
        else {
            (0, openRepoInExternalEditorApp_1.renderOpenRepoInExternalEditorApp)(__assign(__assign({}, globals), { pageType: pageType, className: "btn btn-sm", container: function () { return globals.dependencies.openRepoInExternalEditor.buttonContainerOnRepoHome(); } }));
        }
    }
    else {
        throw new Error("Unknown GitHubPageType ".concat(pageType));
    }
}
function extractFileInfoFromUrl() {
    var split = window.location.pathname.split("/");
    return {
        gitRef: split[4],
        repo: split[2],
        org: split[1],
        path: split.slice(5).join("/"),
    };
}
exports.extractFileInfoFromUrl = extractFileInfoFromUrl;
function unmountPreviouslyRenderedFeatures(id, logger, dependencies, editorEnvelopeLocator) {
    try {
        if ((0, utils_1.mainContainer)(id, dependencies.all.body())) {
            ReactDOM.unmountComponentAtNode((0, utils_1.mainContainer)(id, dependencies.all.body()));
            logger.log("Unmounted previous features.");
        }
        switchHiddenCss(id, dependencies, editorEnvelopeLocator);
    }
    catch (e) {
        logger.log("Ignoring exception while unmounting features.");
    }
}
function pathnameMatches(regex) {
    return !!window.location.pathname.match(new RegExp(regex));
}
function switchHiddenCss(id, dependencies, editorEnvelopeLocator) {
    var _a, _b, _c;
    if (!editorEnvelopeLocator.getEnvelopeMapping(window.location.pathname)) {
        (_a = dependencies.singleView.githubTextEditorToReplaceElement()) === null || _a === void 0 ? void 0 : _a.classList.remove("hidden");
        (_b = (0, singleEditorView_1.iframeContainer)(id, dependencies)) === null || _b === void 0 ? void 0 : _b.classList.add("hidden");
    }
    else {
        dependencies.singleView.githubTextEditorToReplaceElement().classList.add("hidden");
        (_c = (0, singleEditorView_1.iframeContainer)(id, dependencies)) === null || _c === void 0 ? void 0 : _c.classList.remove("hidden");
    }
}
function discoverCurrentGitHubPageType() {
    if (pathnameMatches(".*/.*/edit/.*")) {
        return GitHubPageType_1.GitHubPageType.EDIT;
    }
    if (pathnameMatches(".*/.*/blob/.*")) {
        return GitHubPageType_1.GitHubPageType.VIEW;
    }
    var isOrgSlashRepoSlashTreeSlashName = window.location.pathname.split("/tree/").length === 2 && !window.location.pathname.split("/tree/")[1].includes("/");
    if (isOrgSlashRepoSlashTreeSlashName) {
        return GitHubPageType_1.GitHubPageType.REPO_HOME;
    }
    if (pathnameMatches(".*/.*/pull/[0-9]+/files.*")) {
        return GitHubPageType_1.GitHubPageType.PR_FILES;
    }
    if (pathnameMatches(".*/.*/pull/[0-9]+/commits.*")) {
        return GitHubPageType_1.GitHubPageType.PR_COMMITS;
    }
    if (pathnameMatches("^.*/.*/pull/[0-9]+$")) {
        return GitHubPageType_1.GitHubPageType.PR_HOME;
    }
    if (["/tree/", "/pull/"].some(function (pathnamePart) { return window.location.pathname.includes(pathnamePart); })) {
        return GitHubPageType_1.GitHubPageType.NOT_SUPPORTED;
    }
    return GitHubPageType_1.GitHubPageType.CAN_NOT_BE_DETERMINED_FROM_URL;
}
exports.discoverCurrentGitHubPageType = discoverCurrentGitHubPageType;
__exportStar(require("./ExternalEditorManager"), exports);
//# sourceMappingURL=index.js.map