"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useInitialAsyncCallEffect = exports.useIsolatedEditorTogglingEffect = exports.useEffectAfterFirstRender = void 0;
var react_1 = require("react");
function useEffectAfterFirstRender(func, deps) {
    var firstRender = (0, react_1.useRef)(true);
    (0, react_1.useEffect)(function () {
        if (!firstRender.current) {
            func();
        }
        else {
            firstRender.current = false;
        }
    }, __spreadArray([func], __read(deps), false));
}
exports.useEffectAfterFirstRender = useEffectAfterFirstRender;
function useIsolatedEditorTogglingEffect(textMode, iframeContainer, githubTextEditorToReplace) {
    (0, react_1.useLayoutEffect)(function () {
        if (textMode) {
            githubTextEditorToReplace.classList.remove("hidden");
            iframeContainer.classList.add("hidden");
        }
        else {
            githubTextEditorToReplace.classList.add("hidden");
            iframeContainer.classList.remove("hidden");
        }
    }, [githubTextEditorToReplace.classList, iframeContainer.classList, textMode]);
}
exports.useIsolatedEditorTogglingEffect = useIsolatedEditorTogglingEffect;
function useInitialAsyncCallEffect(promise, callback) {
    (0, react_1.useEffect)(function () {
        var canceled = false;
        promise().then(function (arg) {
            if (canceled) {
                return;
            }
            callback(arg);
        });
        return function () {
            canceled = true;
        };
    }, [callback, promise]);
}
exports.useInitialAsyncCallEffect = useInitialAsyncCallEffect;
//# sourceMappingURL=customEffects.js.map