/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License. 
 */


package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.processes;

import javax.enterprise.event.Event;

import org.kie.workbench.common.stunner.core.factory.impl.EdgeFactoryImpl;
import org.kie.workbench.common.stunner.core.factory.impl.GraphFactoryImpl;
import org.kie.workbench.common.stunner.core.factory.impl.NodeFactoryImpl;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandManagerImpl;
import org.kie.workbench.common.stunner.core.graph.command.impl.GraphCommandFactory;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.spy;

public abstract class StunnerTestingGraphStubAPI extends StunnerTestingGraphAPI {

    protected abstract void initAPI();

    @Override
    protected void init() {
        initAPI();
        initStubs();
    }

    @SuppressWarnings("unchecked")
    protected void initStubs() {
        this.graphFactory = new GraphFactoryImpl(getDefinitionManager());
        this.nodeFactory = new NodeFactoryImpl(getDefinitionUtils());
        this.edgeFactory = new EdgeFactoryImpl(getDefinitionManager());
        this.commandFactory = spy(new GraphCommandFactory());
        this.commandManager = spy(new GraphCommandManagerImpl(mock(Event.class),
                                                              mock(Event.class),
                                                              mock(Event.class)));
    }
}