/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License. 
 */


package org.kie.workbench.common.stunner.bpmn.client.dataproviders;

import java.util.HashMap;
import java.util.Map;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;

import org.kie.workbench.common.forms.dynamic.model.config.SelectorData;
import org.kie.workbench.common.forms.dynamic.model.config.SelectorDataProvider;
import org.kie.workbench.common.forms.dynamic.service.shared.FormRenderingContext;
import org.kie.workbench.common.stunner.bpmn.client.util.DmnResourceContentFetcher;

@Dependent
public class DecisionNameFormProvider implements SelectorDataProvider {

    @Inject
    private DmnResourceContentFetcher dmnResourceContentFetcher;

    @Override
    public String getProviderName() {
        return getClass().getSimpleName();
    }

    @Override
    public SelectorData<String> getSelectorData(final FormRenderingContext context) {
        SelectorData<String> selector = new SelectorData<>();
        Map<String, String> fileNames = new HashMap<>();

        if (dmnResourceContentFetcher != null && dmnResourceContentFetcher.getDecisions() != null) {
            for (String value : dmnResourceContentFetcher.getDecisions())
                fileNames.put(value, value);
        }

        selector.setValues(fileNames);
        return selector;
    }
}
