/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import org.apache.ignite.client.handler.ClientHandlerMetricSource;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;

class IdleChannelHandler
extends ChannelDuplexHandler {
    private static final IgniteLogger LOG = Loggers.forClass(IdleChannelHandler.class);
    private final long idleTimeout;
    private final ClientHandlerMetricSource metrics;

    IdleChannelHandler(long idleTimeout, ClientHandlerMetricSource metrics, long connectionId) {
        this.idleTimeout = idleTimeout;
        this.metrics = metrics;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
            this.metrics.sessionsRejectedTimeoutIncrement();
            LOG.warn("Closing idle channel [idleTimeout=" + this.idleTimeout + ", remoteAddress=" + String.valueOf(ctx.channel().remoteAddress()) + "]", new Object[0]);
            ctx.close();
        }
    }
}

