/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.configuration;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.configuration.ConfigurationModule;
import org.apache.ignite.configuration.SuperRootChange;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.internal.raft.configuration.DisruptorConfigurationSchema;
import org.apache.ignite.internal.raft.configuration.EntryCountBudgetConfigurationSchema;
import org.apache.ignite.internal.raft.configuration.RaftChange;
import org.apache.ignite.internal.raft.configuration.RaftExtensionChange;
import org.apache.ignite.internal.raft.configuration.RaftExtensionConfiguration;
import org.apache.ignite.internal.raft.configuration.RaftExtensionConfigurationSchema;
import org.apache.ignite.internal.raft.configuration.RaftExtensionView;
import org.apache.ignite.internal.raft.configuration.RaftView;
import org.apache.ignite.internal.raft.configuration.UnlimitedBudgetConfigurationSchema;

@AutoService(value={ConfigurationModule.class})
public class RaftConfigurationModule
implements ConfigurationModule {
    public ConfigurationType type() {
        return ConfigurationType.LOCAL;
    }

    public Collection<Class<?>> schemaExtensions() {
        return List.of(RaftExtensionConfigurationSchema.class);
    }

    public Collection<Class<?>> polymorphicSchemaExtensions() {
        return List.of(UnlimitedBudgetConfigurationSchema.class, EntryCountBudgetConfigurationSchema.class);
    }

    public void migrateDeprecatedConfigurations(SuperRootChange superRootChange) {
        RaftExtensionChange raftExtensionChange = (RaftExtensionChange)superRootChange.changeRoot(RaftExtensionConfiguration.KEY);
        RaftExtensionView raftExtensionView = (RaftExtensionView)superRootChange.viewRoot(RaftExtensionConfiguration.KEY);
        RaftChange raftChange = raftExtensionChange.changeRaft();
        RaftView raftView = raftExtensionView.raft();
        RaftConfigurationModule.changeDisruptorStripesIfNeeded(raftView, raftChange);
        RaftConfigurationModule.changeDisruptorLogManagerStripesIfNeeded(raftView, raftChange);
    }

    private static void changeDisruptorStripesIfNeeded(RaftView view, RaftChange change) {
        int stripes = view.stripes();
        if (stripes != DisruptorConfigurationSchema.DEFAULT_STRIPES_COUNT) {
            change.changeDisruptor().changeStripes(stripes);
        }
    }

    private static void changeDisruptorLogManagerStripesIfNeeded(RaftView view, RaftChange change) {
        int logStripesCount = view.logStripesCount();
        if (logStripesCount != DisruptorConfigurationSchema.DEFAULT_LOG_MANAGER_STRIPES_COUNT) {
            change.changeDisruptor().changeLogManagerStripes(logStripesCount);
        }
    }
}

