/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.ignite.client.RetryPolicy;
import org.apache.ignite.internal.client.ClientSchemaVersionMismatchException;
import org.apache.ignite.internal.client.ClientUtils;
import org.apache.ignite.internal.client.PartitionMapping;
import org.apache.ignite.internal.client.PayloadInputChannel;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.ReliableChannel;
import org.apache.ignite.internal.client.WriteContext;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.ClientOp;
import org.apache.ignite.internal.client.proto.ColumnTypeConverter;
import org.apache.ignite.internal.client.proto.ProtocolBitmaskFeature;
import org.apache.ignite.internal.client.sql.ClientSql;
import org.apache.ignite.internal.client.table.ClientColumn;
import org.apache.ignite.internal.client.table.ClientKeyValueBinaryView;
import org.apache.ignite.internal.client.table.ClientKeyValueView;
import org.apache.ignite.internal.client.table.ClientPartitionManager;
import org.apache.ignite.internal.client.table.ClientRecordBinaryView;
import org.apache.ignite.internal.client.table.ClientRecordView;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.PartitionAwarenessProvider;
import org.apache.ignite.internal.client.table.api.PublicApiClientKeyValueView;
import org.apache.ignite.internal.client.table.api.PublicApiClientRecordView;
import org.apache.ignite.internal.client.tx.ClientTransaction;
import org.apache.ignite.internal.client.tx.DirectTxUtils;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.lang.IgniteTriConsumer;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.marshaller.MarshallersProvider;
import org.apache.ignite.internal.marshaller.UnmappedColumnsException;
import org.apache.ignite.internal.tostring.IgniteToStringBuilder;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.Table;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.table.partition.PartitionManager;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ClientTable
implements Table {
    private final int id;
    private final QualifiedName name;
    private final ReliableChannel ch;
    private final MarshallersProvider marshallers;
    private final ClientSql sql;
    private final ConcurrentHashMap<Integer, CompletableFuture<ClientSchema>> schemas = new ConcurrentHashMap();
    private final IgniteLogger log;
    private static final int UNKNOWN_SCHEMA_VERSION = -1;
    private volatile int latestSchemaVer = -1;
    private final Object latestSchemaLock = new Object();
    private final Object partitionAssignmentLock = new Object();
    private volatile PartitionAssignment partitionAssignment = null;
    private volatile int partitionCount = -1;
    private final ClientPartitionManager clientPartitionManager;

    public ClientTable(ReliableChannel ch, MarshallersProvider marshallers, int id, QualifiedName name, int sqlPartitionAwarenessMetadataCacheSize) {
        assert (ch != null);
        assert (marshallers != null);
        assert (name != null);
        this.ch = ch;
        this.marshallers = marshallers;
        this.id = id;
        this.name = name;
        this.log = ClientUtils.logger(ch.configuration(), ClientTable.class);
        this.sql = new ClientSql(ch, marshallers, sqlPartitionAwarenessMetadataCacheSize);
        this.clientPartitionManager = new ClientPartitionManager(this);
    }

    public int tableId() {
        return this.id;
    }

    ReliableChannel channel() {
        return this.ch;
    }

    public QualifiedName qualifiedName() {
        return this.name;
    }

    public PartitionManager partitionManager() {
        return this.clientPartitionManager;
    }

    public <R> RecordView<R> recordView(Mapper<R> recMapper) {
        Objects.requireNonNull(recMapper);
        return new PublicApiClientRecordView<R>(new ClientRecordView<R>(this, this.sql, recMapper));
    }

    public RecordView<Tuple> recordView() {
        return new PublicApiClientRecordView<Tuple>(new ClientRecordBinaryView(this, this.sql));
    }

    public <K, V> KeyValueView<K, V> keyValueView(Mapper<K> keyMapper, Mapper<V> valMapper) {
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(valMapper);
        return new PublicApiClientKeyValueView<K, V>(new ClientKeyValueView<K, V>(this, this.sql, keyMapper, valMapper));
    }

    public KeyValueView<Tuple, Tuple> keyValueView() {
        return new PublicApiClientKeyValueView<Tuple, Tuple>(new ClientKeyValueBinaryView(this, this.sql));
    }

    public CompletableFuture<ClientSchema> getLatestSchema() {
        return this.getSchema(this.latestSchemaVer);
    }

    @TestOnly
    public CompletableFuture<ClientSchema> getSchemaByVersion(int schemaVersion) {
        return this.getSchema(schemaVersion);
    }

    private CompletableFuture<ClientSchema> getSchema(int ver) {
        CompletableFuture fut = this.schemas.computeIfAbsent(ver, this::loadSchema);
        if (fut.isCompletedExceptionally()) {
            this.schemas.remove(ver, fut);
            fut = this.schemas.computeIfAbsent(ver, this::loadSchema);
        }
        return fut;
    }

    private CompletableFuture<ClientSchema> loadSchema(int ver) {
        return this.ch.serviceAsync(5, w -> {
            w.out().packInt(this.id);
            if (ver == -1) {
                w.out().packNil();
            } else {
                w.out().packInt(1);
                w.out().packInt(ver);
            }
        }, r -> {
            ClientMessageUnpacker clientMessageUnpacker = r.in();
            int schemaCnt = clientMessageUnpacker.unpackInt();
            if (schemaCnt == 0) {
                this.log.warn("Schema not found [tableId=" + this.id + ", schemaVersion=" + ver + "]", new Object[0]);
                throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Schema not found: " + ver);
            }
            ClientSchema last = null;
            for (int i = 0; i < schemaCnt; ++i) {
                last = this.readSchema(r.in(), ver);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Schema loaded [tableId=" + this.id + ", schemaVersion=" + last.version() + "]", new Object[0]);
            }
            return last;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientSchema readSchema(ClientMessageUnpacker in, int targetVer) {
        int schemaVer = in.unpackInt();
        int colCnt = in.unpackInt();
        ClientColumn[] columns = new ClientColumn[colCnt];
        int valCnt = 0;
        for (int i = 0; i < colCnt; ++i) {
            ClientColumn column;
            int propCnt = in.unpackInt();
            assert (propCnt >= 7);
            String name = in.unpackString();
            ColumnType type = ColumnTypeConverter.fromIdOrThrow((int)in.unpackInt());
            int keyIndex = in.unpackInt();
            boolean isNullable = in.unpackBoolean();
            int colocationIndex = in.unpackInt();
            int scale = in.unpackInt();
            int precision = in.unpackInt();
            int valIndex = keyIndex < 0 ? valCnt++ : -1;
            in.skipValues(propCnt - 7);
            columns[i] = column = new ClientColumn(name, type, isNullable, keyIndex, valIndex, colocationIndex, i, scale, precision);
        }
        ClientSchema schema = new ClientSchema(schemaVer, columns, this.marshallers);
        if (schemaVer != targetVer) {
            this.schemas.put(schemaVer, CompletableFuture.completedFuture(schema));
        }
        Object object = this.latestSchemaLock;
        synchronized (object) {
            if (schemaVer > this.latestSchemaVer) {
                this.latestSchemaVer = schemaVer;
            }
        }
        return schema;
    }

    public String toString() {
        return IgniteToStringBuilder.toString(ClientTable.class, (Object)this);
    }

    public <T> CompletableFuture<T> doSchemaOutOpAsync(int opCode, IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext> writer, Function<PayloadInputChannel, T> reader, PartitionAwarenessProvider provider, @Nullable Transaction tx) {
        return this.doSchemaOutInOpAsync(opCode, writer, (schema, unpacker) -> reader.apply((PayloadInputChannel)unpacker), null, false, provider, null, null, false, tx);
    }

    public <T> CompletableFuture<T> doSchemaOutOpAsync(int opCode, IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext> writer, Function<PayloadInputChannel, T> reader, PartitionAwarenessProvider provider, boolean expectNotifications, @Nullable Transaction tx) {
        return this.doSchemaOutInOpAsync(opCode, writer, (schema, unpacker) -> reader.apply((PayloadInputChannel)unpacker), null, false, provider, null, null, expectNotifications, tx);
    }

    <T> CompletableFuture<T> doSchemaOutOpAsync(int opCode, IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext> writer, Function<PayloadInputChannel, T> reader, PartitionAwarenessProvider provider, @Nullable RetryPolicy retryPolicyOverride, @Nullable Transaction tx) {
        return this.doSchemaOutInOpAsync(opCode, writer, (schema, unpacker) -> reader.apply((PayloadInputChannel)unpacker), null, false, provider, retryPolicyOverride, null, false, tx);
    }

    <T> CompletableFuture<T> doSchemaOutInOpAsync(int opCode, IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext> writer, BiFunction<ClientSchema, PayloadInputChannel, T> reader, @Nullable T defaultValue, PartitionAwarenessProvider provider, @Nullable Transaction tx) {
        return this.doSchemaOutInOpAsync(opCode, writer, reader, defaultValue, true, provider, null, null, false, tx);
    }

    private <T> CompletableFuture<T> doSchemaOutInOpAsync(int opCode, IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext> writer, BiFunction<ClientSchema, PayloadInputChannel, T> reader, @Nullable T defaultValue, boolean responseSchemaRequired, PartitionAwarenessProvider provider, @Nullable RetryPolicy retryPolicyOverride, @Nullable Integer schemaVersionOverride, boolean expectNotifications, @Nullable Transaction tx) {
        CompletableFuture fut = new CompletableFuture();
        CompletableFuture<ClientSchema> schemaFut = this.getSchema(schemaVersionOverride == null ? this.latestSchemaVer : schemaVersionOverride);
        CompletableFuture<List<String>> partitionsFut = this.getPartitionAssignment();
        ((CompletableFuture)CompletableFuture.allOf(schemaFut, partitionsFut).thenCompose(v -> {
            ClientSchema schema = schemaFut.getNow(null);
            @Nullable PartitionMapping pm = ClientTable.getPreferredNodeName(this.tableId(), provider, partitionsFut.getNow(null), schema);
            WriteContext ctx = new WriteContext(this.ch.observableTimestamp());
            CompletableFuture<@Nullable ClientTransaction> txStartFut = DirectTxUtils.ensureStarted(this.ch, tx, pm, ctx, ch -> {
                boolean supports;
                boolean bl = supports = ch.protocolContext().isFeatureSupported(ProtocolBitmaskFeature.TX_PIGGYBACK) && pm != null && ch.protocolContext().clusterNode().name().equals(pm.nodeConsistentId());
                assert (!supports || ch.protocolContext().allFeaturesSupported(ProtocolBitmaskFeature.TX_DIRECT_MAPPING, ProtocolBitmaskFeature.TX_DELAYED_ACKS));
                return supports;
            });
            return txStartFut.thenCompose(tx0 -> ((CompletableFuture)this.ch.serviceAsync(opCode, w -> writer.accept((Object)schema, (Object)w, (Object)ctx), r -> this.readSchemaAndReadData(schema, r, reader, defaultValue, responseSchemaRequired, ctx, (ClientTransaction)tx0), () -> DirectTxUtils.resolveChannel(ctx, this.ch, ClientOp.isWrite((int)opCode), tx0, pm), retryPolicyOverride, expectNotifications).thenCompose(t -> this.loadSchemaAndReadData(t, reader))).handle((ret, ex) -> {
                if (ex != null) {
                    if (ctx.firstReqFut != null) {
                        ClientTransaction failed = new ClientTransaction(ctx.channel, this.id, ctx.readOnly, null, ctx.pm, null, this.ch.observableTimestamp(), 0L);
                        failed.fail();
                        ctx.firstReqFut.complete(failed);
                        fut.completeExceptionally(ExceptionUtils.unwrapCause((Throwable)ex));
                        return null;
                    }
                    if (ctx.enlistmentToken == null) {
                        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
                            if (cause instanceof ClientSchemaVersionMismatchException) {
                                int expectedVersion = ((ClientSchemaVersionMismatchException)((Object)((Object)((Object)((Object)cause))))).expectedVersion();
                                this.doSchemaOutInOpAsync(opCode, writer, reader, defaultValue, responseSchemaRequired, provider, retryPolicyOverride, expectedVersion, expectNotifications, tx).whenComplete((res0, err0) -> {
                                    if (err0 != null) {
                                        fut.completeExceptionally((Throwable)err0);
                                    } else {
                                        fut.complete(res0);
                                    }
                                });
                                return null;
                            }
                            if (schemaVersionOverride != null || !(cause instanceof UnmappedColumnsException)) continue;
                            this.schemas.remove(-1);
                            this.doSchemaOutInOpAsync(opCode, writer, reader, defaultValue, responseSchemaRequired, provider, retryPolicyOverride, -1, expectNotifications, tx).whenComplete((res0, err0) -> {
                                if (err0 != null) {
                                    fut.completeExceptionally((Throwable)err0);
                                } else {
                                    fut.complete(res0);
                                }
                            });
                            return null;
                        }
                        fut.completeExceptionally((Throwable)ex);
                    } else {
                        tx0.rollbackAsync().handle((ignored, err0) -> {
                            if (err0 != null) {
                                ex.addSuppressed((Throwable)err0);
                            }
                            fut.completeExceptionally((Throwable)ex);
                            return null;
                        });
                    }
                } else {
                    fut.complete(ret);
                }
                return null;
            }));
        })).exceptionally(ex -> {
            fut.completeExceptionally((Throwable)ex);
            ExceptionUtils.sneakyThrow((Throwable)ex);
            return null;
        });
        return fut;
    }

    @Nullable
    private <T> Object readSchemaAndReadData(ClientSchema knownSchema, PayloadInputChannel in, BiFunction<ClientSchema, PayloadInputChannel, T> fn, @Nullable T defaultValue, boolean responseSchemaRequired, WriteContext ctx, @Nullable ClientTransaction tx0) {
        ClientSchema resSchema;
        ClientMessageUnpacker in1 = in.in();
        DirectTxUtils.readTx(in, ctx, tx0, this.ch.observableTimestamp());
        int schemaVer = in1.unpackInt();
        if (!responseSchemaRequired) {
            this.ensureSchemaLoadedAsync(schemaVer);
            return fn.apply(null, in);
        }
        if (in1.tryUnpackNil()) {
            this.ensureSchemaLoadedAsync(schemaVer);
            return defaultValue;
        }
        ClientSchema clientSchema = resSchema = schemaVer == knownSchema.version() ? knownSchema : this.schemas.get(schemaVer);
        if (resSchema != null) {
            return fn.apply(knownSchema, in);
        }
        in1.retain();
        return new IgniteBiTuple((Object)in, (Object)schemaVer);
    }

    private <T> CompletionStage<T> loadSchemaAndReadData(Object data, BiFunction<ClientSchema, PayloadInputChannel, T> fn) {
        if (!(data instanceof IgniteBiTuple)) {
            return CompletableFuture.completedFuture(data);
        }
        IgniteBiTuple biTuple = (IgniteBiTuple)data;
        PayloadInputChannel in = (PayloadInputChannel)biTuple.getKey();
        Integer schemaId = (Integer)biTuple.getValue();
        assert (in != null);
        assert (schemaId != null);
        CompletionStage resFut = this.getSchema(schemaId).thenApply(schema -> fn.apply((ClientSchema)schema, in));
        ((CompletableFuture)resFut).handle((tuple, err) -> {
            in.close();
            return null;
        });
        return resFut;
    }

    private void ensureSchemaLoadedAsync(int schemaVer) {
        if (this.schemas.get(schemaVer) == null) {
            this.getSchema(schemaVer);
        }
    }

    private static boolean isPartitionAssignmentValid(PartitionAssignment pa, long timestamp) {
        return pa != null && pa.timestamp >= timestamp && !pa.partitionsFut.isCompletedExceptionally();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompletableFuture<List<String>> getPartitionAssignment() {
        PartitionAssignment pa = this.partitionAssignment;
        long timestamp = this.ch.partitionAssignmentTimestamp();
        if (ClientTable.isPartitionAssignmentValid(pa, timestamp)) {
            return pa.partitionsFut;
        }
        Object object = this.partitionAssignmentLock;
        synchronized (object) {
            pa = this.partitionAssignment;
            if (ClientTable.isPartitionAssignmentValid(pa, timestamp)) {
                return pa.partitionsFut;
            }
            PartitionAssignment newAssignment = new PartitionAssignment();
            newAssignment.timestamp = timestamp;
            newAssignment.partitionsFut = this.ch.serviceAsync(53, w -> {
                w.out().packInt(this.id);
                w.out().packLong(timestamp);
            }, r -> {
                int cnt = r.in().unpackInt();
                if (cnt <= 0) {
                    throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Invalid partition count returned by the server: " + cnt);
                }
                int oldPartitionCount = this.partitionCount;
                if (oldPartitionCount < 0) {
                    this.partitionCount = cnt;
                } else if (oldPartitionCount != cnt) {
                    String message = String.format("Partition count has changed for table '%s': %d -> %d", this.name.toCanonicalForm(), oldPartitionCount, cnt);
                    throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, message);
                }
                boolean assignmentAvailable = r.in().unpackBoolean();
                if (!assignmentAvailable) {
                    newAssignment.timestamp = 0L;
                    return ClientTable.emptyAssignment(cnt);
                }
                long ts = r.in().unpackLong();
                assert (ts >= timestamp) : "Returned timestamp is older than requested: " + ts + " < " + timestamp;
                newAssignment.timestamp = ts;
                ArrayList<String> res = new ArrayList<String>(cnt);
                for (int i = 0; i < cnt; ++i) {
                    res.add(r.in().tryUnpackNil() ? null : r.in().unpackString());
                }
                return res;
            });
            this.partitionAssignment = newAssignment;
            return newAssignment.partitionsFut;
        }
    }

    int tryGetPartitionCount() {
        return this.partitionCount;
    }

    private static <E> void reduceWithKeepOrder(List<E> agg, List<E> cur, List<Integer> originalIndices) {
        for (int i = 0; i < cur.size(); ++i) {
            E val = cur.get(i);
            Integer orig = originalIndices.get(i);
            agg.set(orig, val);
        }
    }

    <R, E> CompletableFuture<R> split(Transaction tx, Collection<E> keys, BiFunction<Collection<E>, PartitionAwarenessProvider, CompletableFuture<R>> fun, @Nullable R initialValue, Reducer<R> reducer, BiFunction<ClientSchema, E, Integer> hashFunc) {
        assert (tx != null);
        CompletableFuture<ClientSchema> schemaFut = this.getSchema(this.latestSchemaVer);
        CompletableFuture<List<String>> partitionsFut = this.getPartitionAssignment();
        return CompletableFuture.allOf(schemaFut, partitionsFut).thenCompose(v -> {
            ClientSchema schema = schemaFut.getNow(null);
            @Nullable List aff = partitionsFut.getNow(null);
            if (aff == null) {
                return (CompletionStage)fun.apply(keys, PartitionAwarenessProvider.NULL_PROVIDER);
            }
            HashMap mapped = IgniteUtils.newHashMap((int)aff.size());
            ArrayList<CompletableFuture> res = new ArrayList<CompletableFuture>(aff.size());
            for (Object e : keys) {
                int hash = (Integer)hashFunc.apply(schema, e);
                Integer part = Math.abs(hash % aff.size());
                mapped.computeIfAbsent(part, k -> new ArrayList()).add(e);
            }
            for (Map.Entry entry : mapped.entrySet()) {
                res.add((CompletableFuture)fun.apply((Collection)entry.getValue(), PartitionAwarenessProvider.of((Integer)entry.getKey())));
            }
            return CompletableFuture.allOf(res.toArray(new CompletableFuture[0])).thenApply(ignored -> {
                Object in = initialValue;
                for (CompletableFuture val : res) {
                    in = reducer.reduce(in, val.getNow(null));
                }
                return in;
            });
        });
    }

    <E> CompletableFuture<List<E>> split(Transaction tx, Collection<E> keys, BiFunction<Collection<E>, PartitionAwarenessProvider, CompletableFuture<List<E>>> fun, BiFunction<ClientSchema, E, Integer> hashFunc) {
        assert (tx != null);
        CompletableFuture<ClientSchema> schemaFut = this.getSchema(this.latestSchemaVer);
        CompletableFuture<List<String>> partitionsFut = this.getPartitionAssignment();
        return CompletableFuture.allOf(schemaFut, partitionsFut).thenCompose(v -> {
            ClientSchema schema = schemaFut.getNow(null);
            @Nullable List aff = partitionsFut.getNow(null);
            if (aff == null) {
                return (CompletionStage)fun.apply(keys, PartitionAwarenessProvider.NULL_PROVIDER);
            }
            HashMap mapped = IgniteUtils.newHashMap((int)aff.size());
            int idx = 0;
            for (Object key : keys) {
                int hash = (Integer)hashFunc.apply(schema, key);
                int part = Math.abs(hash % aff.size());
                mapped.computeIfAbsent(part, k -> new Batch()).add(key, idx);
                ++idx;
            }
            ArrayList<CompletableFuture> res = new ArrayList<CompletableFuture>(aff.size());
            ArrayList<Batch> batches = new ArrayList<Batch>();
            for (Map.Entry entry : mapped.entrySet()) {
                res.add((CompletableFuture)fun.apply(((Batch)entry.getValue()).batch, PartitionAwarenessProvider.of((Integer)entry.getKey())));
                batches.add((Batch)entry.getValue());
            }
            return CompletableFuture.allOf(res.toArray(new CompletableFuture[0])).thenApply(ignored -> {
                ArrayList<Object> in = new ArrayList<Object>(Collections.nCopies(keys.size(), null));
                for (int i = 0; i < res.size(); ++i) {
                    CompletableFuture f = (CompletableFuture)res.get(i);
                    ClientTable.reduceWithKeepOrder(in, f.getNow(null), ((Batch)batches.get((int)i)).originalIndices);
                }
                return in;
            });
        });
    }

    @Nullable
    private static PartitionMapping getPreferredNodeName(int tableId, PartitionAwarenessProvider provider, @Nullable List<String> partitions, ClientSchema schema) {
        assert (provider != null);
        if (partitions == null || partitions.isEmpty()) {
            return null;
        }
        Integer partition = provider.partition();
        if (partition != null) {
            String node = partitions.get(partition);
            if (node == null) {
                return null;
            }
            return new PartitionMapping(tableId, node, partition);
        }
        Integer hash = provider.getObjectHashCode(schema);
        if (hash == null) {
            return null;
        }
        int part = Math.abs(hash % partitions.size());
        String node = partitions.get(part);
        if (node == null) {
            return null;
        }
        return new PartitionMapping(tableId, node, part);
    }

    private static List<String> emptyAssignment(int size) {
        ArrayList<String> emptyRes = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            emptyRes.add(null);
        }
        return emptyRes;
    }

    private static class PartitionAssignment {
        volatile long timestamp = 0L;
        CompletableFuture<List<String>> partitionsFut;

        private PartitionAssignment() {
        }
    }

    @FunctionalInterface
    static interface Reducer<R> {
        public R reduce(@Nullable R var1, R var2);
    }

    static class Batch<E> {
        List<E> batch = new ArrayList();
        List<Integer> originalIndices = new ArrayList<Integer>();

        Batch() {
        }

        void add(E entry, int origIdx) {
            this.batch.add(entry);
            this.originalIndices.add(origIdx);
        }
    }
}

