/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft;

import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.util.Copiable;

public class Status
implements Copiable<Status> {
    private State state;

    public Status() {
        this.state = null;
    }

    public static Status OK() {
        return new Status();
    }

    public Status(Status s) {
        this.state = s.state != null ? new State(s.state.code, s.state.msg) : null;
    }

    public Status(RaftError raftError, String fmt, Object ... args) {
        this.state = new State(raftError.getNumber(), fmt == null ? null : String.format(fmt, args));
    }

    public Status(int code, String fmt, Object ... args) {
        this.state = new State(code, fmt == null ? null : String.format(fmt, args));
    }

    public Status(int code, String errorMsg) {
        this.state = new State(code, errorMsg);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Status other = (Status)obj;
        if (this.state == null) {
            return other.state == null;
        }
        return this.state.equals(other.state);
    }

    public void reset() {
        this.state = null;
    }

    public boolean isOk() {
        return this.state == null || this.state.code == 0;
    }

    public boolean isCanceled() {
        return this.state != null && this.state.code == RaftError.ECANCELED.getNumber();
    }

    public void setCode(int code) {
        if (this.state == null) {
            this.state = new State(code, null);
        } else {
            this.state.code = code;
        }
    }

    public int getCode() {
        return this.state == null ? 0 : this.state.code;
    }

    public RaftError getRaftError() {
        return this.state == null ? RaftError.SUCCESS : RaftError.forNumber(this.state.code);
    }

    public void setErrorMsg(String errMsg) {
        if (this.state == null) {
            this.state = new State(0, errMsg);
        } else {
            this.state.msg = errMsg;
        }
    }

    public void setError(int code, String fmt, Object ... args) {
        this.state = new State(code, fmt == null ? null : String.format(fmt, args));
    }

    public void setError(RaftError error, String fmt, Object ... args) {
        this.state = new State(error.getNumber(), fmt == null ? null : String.format(fmt, args));
    }

    public String toString() {
        if (this.isOk()) {
            return "Status[OK]";
        }
        return "Status[" + RaftError.describeCode(this.state.code) + "<" + this.state.code + ">: " + this.state.msg + "]";
    }

    @Override
    public Status copy() {
        return new Status(this.getCode(), this.getErrorMsg());
    }

    public String getErrorMsg() {
        return this.state == null ? null : this.state.msg;
    }

    private static class State {
        int code;
        String msg;

        State(int code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.code;
            result = 31 * result + (this.msg == null ? 0 : this.msg.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            State other = (State)obj;
            if (this.code != other.code) {
                return false;
            }
            if (this.msg == null) {
                return other.msg == null;
            }
            return this.msg.equals(other.msg);
        }
    }
}

