/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.compute;

import org.apache.ignite.shaded.org.apache.ignite.compute.JobExecutorType;

public class JobExecutionOptions {
    public static final JobExecutionOptions DEFAULT = JobExecutionOptions.builder().priority(0).maxRetries(0).build();
    private final int priority;
    private final int maxRetries;
    private final JobExecutorType executorType;

    private JobExecutionOptions(int priority, int maxRetries, JobExecutorType executorType) {
        this.priority = priority;
        this.maxRetries = maxRetries;
        this.executorType = executorType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int priority() {
        return this.priority;
    }

    public int maxRetries() {
        return this.maxRetries;
    }

    public JobExecutorType executorType() {
        return this.executorType;
    }

    public static class Builder {
        private int priority;
        private int maxRetries;
        private JobExecutorType executorType = JobExecutorType.JAVA_EMBEDDED;

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder executorType(JobExecutorType jobExecutorType) {
            this.executorType = jobExecutorType;
            return this;
        }

        public JobExecutionOptions build() {
            return new JobExecutionOptions(this.priority, this.maxRetries, this.executorType);
        }
    }
}

