/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptLattice;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.ViewExpanders;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.StarTable;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mappings;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RelOptMaterialization {
    public final RelNode tableRel;
    public final @Nullable RelOptTable starRelOptTable;
    public final @Nullable StarTable starTable;
    public final List<String> qualifiedTableName;
    public final RelNode queryRel;

    public RelOptMaterialization(RelNode tableRel, RelNode queryRel, @Nullable RelOptTable starRelOptTable, List<String> qualifiedTableName) {
        this.queryRel = Objects.requireNonNull(queryRel, "queryRel");
        this.tableRel = RelOptUtil.createCastRel(Objects.requireNonNull(tableRel, "tableRel"), queryRel.getRowType(), false);
        this.starRelOptTable = starRelOptTable;
        this.starTable = starRelOptTable == null ? null : starRelOptTable.unwrapOrThrow(StarTable.class);
        this.qualifiedTableName = qualifiedTableName;
    }

    public static @Nullable RelNode tryUseStar(RelNode rel, final RelOptTable starRelOptTable) {
        final StarTable starTable = starRelOptTable.unwrapOrThrow(StarTable.class);
        RelNode rel2 = rel.accept(new RelShuttleImpl(){

            @Override
            public RelNode visit(TableScan scan) {
                RelOptTable relOptTable = scan.getTable();
                Table table = relOptTable.unwrap(Table.class);
                if (Objects.equals(table, starTable.tables.get(0))) {
                    Mappings.TargetMapping mapping = Mappings.createShiftMapping(starRelOptTable.getRowType().getFieldCount(), 0, 0, relOptTable.getRowType().getFieldCount());
                    RelOptCluster cluster = scan.getCluster();
                    RelNode scan2 = starRelOptTable.toRel(ViewExpanders.simpleContext(cluster));
                    return RelOptUtil.createProject(scan2, Mappings.asListNonNull(mapping.inverse()));
                }
                return scan;
            }

            @Override
            public RelNode visit(LogicalJoin join) {
                RelNode rel;
                while ((rel = super.visit(join)) != join && rel instanceof LogicalJoin) {
                    ProjectFilterTable right;
                    join = (LogicalJoin)rel;
                    ProjectFilterTable left = ProjectFilterTable.of(join.getLeft());
                    if (left == null || (right = ProjectFilterTable.of(join.getRight())) == null) continue;
                    try {
                        this.match(left, right, join.getCluster());
                    }
                    catch (Util.FoundOne e) {
                        return (RelNode)Objects.requireNonNull(e.getNode(), "FoundOne.getNode");
                    }
                }
                return rel;
            }

            private void match(ProjectFilterTable left, ProjectFilterTable right, RelOptCluster cluster) {
                Mappings.TargetMapping leftMapping = left.mapping();
                Mappings.TargetMapping rightMapping = right.mapping();
                RelOptTable leftRelOptTable = left.getTable();
                Table leftTable = leftRelOptTable.unwrap(Table.class);
                int leftCount = leftRelOptTable.getRowType().getFieldCount();
                RelOptTable rightRelOptTable = right.getTable();
                Table rightTable = rightRelOptTable.unwrap(Table.class);
                if (leftTable instanceof StarTable && rightTable != null && ((StarTable)leftTable).tables.contains((Object)rightTable)) {
                    int offset = ((StarTable)leftTable).columnOffset(rightTable);
                    Mappings.TargetMapping mapping = Mappings.merge(leftMapping, Mappings.offsetTarget(Mappings.offsetSource(rightMapping, offset), leftMapping.getTargetCount()));
                    RelNode project = RelOptUtil.createProject(leftRelOptTable.toRel(ViewExpanders.simpleContext(cluster)), Mappings.asListNonNull(mapping.inverse()));
                    ArrayList<RexNode> conditions = new ArrayList<RexNode>();
                    if (left.condition != null) {
                        conditions.add(left.condition);
                    }
                    if (right.condition != null) {
                        conditions.add(RexUtil.apply(mapping, RexUtil.shift(right.condition, offset)));
                    }
                    RelNode filter = RelOptUtil.createFilter(project, conditions);
                    throw new Util.FoundOne(filter);
                }
                if (rightTable instanceof StarTable && leftTable != null && ((StarTable)rightTable).tables.contains((Object)leftTable)) {
                    int offset = ((StarTable)rightTable).columnOffset(leftTable);
                    Mappings.TargetMapping mapping = Mappings.merge(Mappings.offsetSource(leftMapping, offset), Mappings.offsetTarget(rightMapping, leftCount));
                    RelNode project = RelOptUtil.createProject(rightRelOptTable.toRel(ViewExpanders.simpleContext(cluster)), Mappings.asListNonNull(mapping.inverse()));
                    ArrayList<RexNode> conditions = new ArrayList<RexNode>();
                    if (left.condition != null) {
                        conditions.add(RexUtil.apply(mapping, RexUtil.shift(left.condition, offset)));
                    }
                    if (right.condition != null) {
                        conditions.add(RexUtil.apply(mapping, right.condition));
                    }
                    RelNode filter = RelOptUtil.createFilter(project, conditions);
                    throw new Util.FoundOne(filter);
                }
            }
        });
        if (rel2 == rel) {
            return null;
        }
        Program program = Programs.hep((Iterable<? extends RelOptRule>)ImmutableList.of((Object)CoreRules.PROJECT_FILTER_TRANSPOSE, (Object)CoreRules.AGGREGATE_PROJECT_MERGE, (Object)CoreRules.AGGREGATE_FILTER_TRANSPOSE), false, DefaultRelMetadataProvider.INSTANCE);
        return program.run((RelOptPlanner)Nullness.castNonNull(null), rel2, (RelTraitSet)Nullness.castNonNull(null), (List<RelOptMaterialization>)ImmutableList.of(), (List<RelOptLattice>)ImmutableList.of());
    }

    public static RelNode toLeafJoinForm(RelNode rel) {
        Program program = Programs.hep((Iterable<? extends RelOptRule>)ImmutableList.of((Object)CoreRules.JOIN_PROJECT_RIGHT_TRANSPOSE, (Object)CoreRules.JOIN_PROJECT_LEFT_TRANSPOSE, (Object)CoreRules.FILTER_INTO_JOIN, (Object)CoreRules.PROJECT_REMOVE, (Object)CoreRules.PROJECT_MERGE), false, DefaultRelMetadataProvider.INSTANCE);
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            System.out.println(RelOptUtil.dumpPlan("before", rel, SqlExplainFormat.TEXT, SqlExplainLevel.DIGEST_ATTRIBUTES));
        }
        RelNode rel2 = program.run((RelOptPlanner)Nullness.castNonNull(null), rel, (RelTraitSet)Nullness.castNonNull(null), (List<RelOptMaterialization>)ImmutableList.of(), (List<RelOptLattice>)ImmutableList.of());
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            System.out.println(RelOptUtil.dumpPlan("after", rel2, SqlExplainFormat.TEXT, SqlExplainLevel.DIGEST_ATTRIBUTES));
        }
        return rel2;
    }

    private static class ProjectFilterTable {
        final @Nullable RexNode condition;
        final @Nullable Mappings.TargetMapping mapping;
        final TableScan scan;

        private ProjectFilterTable(@Nullable RexNode condition, @Nullable Mappings.TargetMapping mapping, TableScan scan) {
            this.condition = condition;
            this.mapping = mapping;
            this.scan = Objects.requireNonNull(scan, "scan");
        }

        static @Nullable ProjectFilterTable of(RelNode node) {
            if (node instanceof Filter) {
                Filter filter = (Filter)node;
                return ProjectFilterTable.of2(filter.getCondition(), filter.getInput());
            }
            return ProjectFilterTable.of2(null, node);
        }

        private static @Nullable ProjectFilterTable of2(@Nullable RexNode condition, RelNode node) {
            if (node instanceof Project) {
                Project project = (Project)node;
                return ProjectFilterTable.of3(condition, project.getMapping(), project.getInput());
            }
            return ProjectFilterTable.of3(condition, null, node);
        }

        private static @Nullable ProjectFilterTable of3(@Nullable RexNode condition, @Nullable Mappings.TargetMapping mapping, RelNode node) {
            if (node instanceof TableScan) {
                return new ProjectFilterTable(condition, mapping, (TableScan)node);
            }
            return null;
        }

        public Mappings.TargetMapping mapping() {
            return this.mapping != null ? this.mapping : Mappings.createIdentity(this.scan.getRowType().getFieldCount());
        }

        public RelOptTable getTable() {
            return this.scan.getTable();
        }
    }
}

