/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.rel.SourceAwareIgniteRel;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.jetbrains.annotations.Nullable;

public class IgniteTableModify
extends TableModify
implements SourceAwareIgniteRel {
    private static final String REL_TYPE_NAME = "TableModify";
    private final long sourceId;

    public IgniteTableModify(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, RelNode input, TableModify.Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened) {
        this(-1L, cluster, traitSet, table, input, operation, updateColumnList, sourceExpressionList, flattened);
    }

    public IgniteTableModify(long sourceId, RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, RelNode input, TableModify.Operation operation, @Nullable List<String> updateColumnList, @Nullable List<RexNode> sourceExpressionList, boolean flattened) {
        super(cluster, traitSet, table, (Prepare.CatalogReader)Commons.context(cluster).catalogReader(), input, operation, updateColumnList, sourceExpressionList, flattened);
        this.sourceId = sourceId;
    }

    public IgniteTableModify(RelInput input) {
        this(input.get("sourceId") != null ? ((Number)input.get("sourceId")).longValue() : -1L, input.getCluster(), input.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE), input.getTable("table"), input.getInput(), (TableModify.Operation)input.getEnum("operation", TableModify.Operation.class), input.getStringList("updateColumnList"), input.get("sourceExpressionList") != null ? input.getExpressionList("sourceExpressionList") : null, input.getBoolean("flattened", true));
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new IgniteTableModify(this.sourceId, this.getCluster(), traitSet, this.getTable(), (RelNode)IgniteTableModify.sole(inputs), this.getOperation(), this.getUpdateColumnList(), this.getSourceExpressionList(), this.isFlattened());
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IgniteRel clone(long sourceId) {
        return new IgniteTableModify(sourceId, this.getCluster(), this.traitSet, this.getTable(), this.input, this.getOperation(), this.getUpdateColumnList(), this.getSourceExpressionList(), this.isFlattened());
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteTableModify(this.sourceId, cluster, this.getTraitSet(), this.getTable(), (RelNode)IgniteTableModify.sole(inputs), this.getOperation(), this.getUpdateColumnList(), this.getSourceExpressionList(), this.isFlattened());
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("tableId", (Object)Integer.toString(((IgniteTable)this.getTable().unwrap(IgniteTable.class)).id()), pw.getDetailLevel() == SqlExplainLevel.ALL_ATTRIBUTES).itemIf("sourceId", (Object)this.sourceId, this.sourceId != -1L);
    }

    @Override
    public long sourceId() {
        return this.sourceId;
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }
}

