/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.eventlog.config.schema;

import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.eventlog.config.schema.ValidEventType;
import org.apache.ignite.internal.eventlog.event.EventTypeRegistry;

public class EventTypeValidatorImpl
implements Validator<ValidEventType, String[]> {
    public static final EventTypeValidatorImpl INSTANCE = new EventTypeValidatorImpl();

    public void validate(ValidEventType annotation, ValidationContext<String[]> ctx) {
        String[] eventTypes = (String[])ctx.getNewValue();
        if (eventTypes.length == 1 && eventTypes[0].isEmpty()) {
            return;
        }
        for (String eventType : eventTypes) {
            if (EventTypeRegistry.contains(eventType)) continue;
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), String.format("Unable to find event type '%s' in the system. Please, make sure you set the correct event type.", eventType)));
        }
    }
}

