/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.lang;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import org.apache.ignite.internal.lang.IgniteExceptionMapper;
import org.apache.ignite.internal.lang.IgniteExceptionMappersProvider;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteCheckedException;
import org.apache.ignite.lang.IgniteException;

public class IgniteExceptionMapperUtil {
    private static final Map<Class<? extends Exception>, IgniteExceptionMapper<?, ?>> EXCEPTION_CONVERTERS;

    static void registerMapping(IgniteExceptionMapper<?, ?> mapper, Map<Class<? extends Exception>, IgniteExceptionMapper<?, ?>> registeredMappings) {
        if (registeredMappings.containsKey(mapper.mappingFrom())) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Failed to register exception mapper, duplicate found [class=" + mapper.mappingFrom().getCanonicalName() + "]");
        }
        registeredMappings.put(mapper.mappingFrom(), mapper);
    }

    public static Throwable mapToPublicException(Throwable origin) {
        return IgniteExceptionMapperUtil.mapToPublicException(origin, ex -> new IgniteException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)ex));
    }

    public static Throwable mapToPublicException(Throwable origin, Function<Throwable, Throwable> unknownProblemMapper) {
        Throwable res;
        IgniteExceptionMapper<?, ?> m4;
        if (origin instanceof Error) {
            if (origin instanceof AssertionError) {
                return IgniteExceptionMapperUtil.mapCheckingResultIsPublic(origin, unknownProblemMapper);
            }
            return origin;
        }
        for (Class<?> exceptionClass = origin.getClass(); (m4 = EXCEPTION_CONVERTERS.get(exceptionClass)) == null && exceptionClass != Throwable.class; exceptionClass = exceptionClass.getSuperclass()) {
        }
        if (m4 != null) {
            res = IgniteExceptionMapperUtil.map(m4, origin);
            IgniteExceptionMapperUtil.checkResultIsPublic(res, origin);
        } else {
            res = origin;
        }
        if (res instanceof IgniteException || res instanceof IgniteCheckedException) {
            return res;
        }
        return IgniteExceptionMapperUtil.mapCheckingResultIsPublic(origin, unknownProblemMapper);
    }

    private static Throwable mapCheckingResultIsPublic(Throwable origin, Function<Throwable, Throwable> unknownProblemMapper) {
        Throwable result = unknownProblemMapper.apply(origin);
        IgniteExceptionMapperUtil.checkResultIsPublic(result, origin);
        return result;
    }

    private static void checkResultIsPublic(Throwable mappingResult, Throwable origin) {
        assert (mappingResult instanceof IgniteException || mappingResult instanceof IgniteCheckedException) : "Unexpected mapping of internal exception to a public one [origin=" + String.valueOf(origin) + ", mapped=" + String.valueOf(mappingResult) + "]: not a public exception";
        assert (IgniteExceptionMapperUtil.isPublicPackage(mappingResult.getClass().getPackage())) : "Unexpected mapping of internal exception to a public one [origin=" + String.valueOf(origin) + ", mapped=" + String.valueOf(mappingResult) + "]: exception is not defined in a public package";
    }

    private static boolean isPublicPackage(Package somePackage) {
        return !somePackage.getName().startsWith("org.apache.ignite.internal");
    }

    public static <T> CompletableFuture<T> convertToPublicFuture(CompletableFuture<T> origin) {
        if (CompletableFutures.isCompletedSuccessfully(origin)) {
            return origin;
        }
        return origin.handle((res, err) -> {
            if (err != null) {
                throw new CompletionException(IgniteExceptionMapperUtil.mapToPublicException(ExceptionUtils.unwrapCause(err)));
            }
            return res;
        });
    }

    private static <T extends Exception, R extends Exception> Exception map(IgniteExceptionMapper<T, R> mapper, Throwable t2) {
        return mapper.map((Exception)mapper.mappingFrom().cast(t2));
    }

    static {
        HashMap mappers = new HashMap();
        ServiceLoader.load(IgniteExceptionMappersProvider.class).forEach(provider -> provider.mappers().forEach(m4 -> IgniteExceptionMapperUtil.registerMapping(m4, mappers)));
        EXCEPTION_CONVERTERS = Collections.unmodifiableMap(mappers);
    }
}

