/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.aware;

import org.apache.ignite.internal.IgniteInterruptedCheckedException;

class SegmentTruncateStorage {
    private volatile boolean interrupted;
    private long lastTruncatedIdx = -1L;
    private long minReservedIdx = -1L;
    private long lastCpIdx = -1L;
    private long lastArchivedIdx = -1L;

    SegmentTruncateStorage() {
    }

    synchronized void lastTruncatedIdx(long absIdx) {
        this.lastTruncatedIdx = absIdx;
        this.notifyAll();
    }

    synchronized void minReservedIdx(long absIdx) {
        this.minReservedIdx = absIdx;
        this.notifyAll();
    }

    synchronized void lastCheckpointIdx(long absIdx) {
        this.lastCpIdx = absIdx;
        this.notifyAll();
    }

    synchronized void lastArchivedIdx(long absIdx) {
        this.lastArchivedIdx = absIdx;
        this.notifyAll();
    }

    synchronized long lastTruncatedIdx() {
        return this.lastTruncatedIdx;
    }

    synchronized long awaitAvailableTruncate() throws IgniteInterruptedCheckedException {
        try {
            while (this.availableTruncateCnt() == 0L && !this.interrupted) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedCheckedException(e);
        }
        if (this.interrupted) {
            throw new IgniteInterruptedCheckedException("Interrupt waiting for truncation availability");
        }
        return this.availableTruncateCnt();
    }

    synchronized void interrupt() {
        this.interrupted = true;
        this.notifyAll();
    }

    void reset() {
        this.interrupted = false;
    }

    private synchronized long availableTruncateCnt() {
        long highIdx = this.minReservedIdx == -1L ? this.lastCpIdx : Math.min(this.minReservedIdx, this.lastCpIdx);
        highIdx = this.lastArchivedIdx == -1L ? highIdx : Math.min(this.lastArchivedIdx, highIdx);
        return Math.max(0L, highIdx == -1L ? 0L : highIdx - (this.lastTruncatedIdx + 1L));
    }
}

