/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.deployment.uri;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

class GridUriDeploymentUnitDescriptor {
    private final Type type;
    @GridToStringExclude
    private final String uri;
    private final File file;
    private final long tstamp;
    private final ClassLoader clsLdr;
    private final Set<Class<?>> rsrcs = new HashSet();
    private final Map<String, Class<?>> rsrcsByAlias = new HashMap();
    private final String md5;

    GridUriDeploymentUnitDescriptor(String uri, File file, long tstamp, ClassLoader clsLdr, String md5) {
        assert (uri != null);
        assert (file != null);
        assert (tstamp > 0L);
        this.uri = uri;
        this.file = file;
        this.tstamp = tstamp;
        this.clsLdr = clsLdr;
        this.md5 = md5;
        this.type = Type.FILE;
    }

    GridUriDeploymentUnitDescriptor(long tstamp, ClassLoader clsLdr) {
        assert (clsLdr != null);
        assert (tstamp > 0L);
        this.tstamp = tstamp;
        this.clsLdr = clsLdr;
        this.uri = null;
        this.file = null;
        this.md5 = null;
        this.type = Type.CLASS;
    }

    public Type getType() {
        return this.type;
    }

    public String getUri() {
        return this.uri;
    }

    public File getFile() {
        return this.file;
    }

    public long getTimestamp() {
        return this.tstamp;
    }

    public String getMd5() {
        return this.md5;
    }

    public ClassLoader getClassLoader() {
        return this.clsLdr;
    }

    public void addResource(Class<?> cls) {
        this.rsrcs.add(cls);
    }

    public void addResource(String alias, Class<?> cls) {
        this.rsrcsByAlias.put(alias, cls);
        this.rsrcs.add(cls);
    }

    @Nullable
    public Class<?> getResourceByAlias(String alias) {
        return this.rsrcsByAlias.get(alias);
    }

    public Map<String, Class<?>> getResourcesByAlias() {
        return Collections.unmodifiableMap(this.rsrcsByAlias);
    }

    public Set<Class<?>> getResources() {
        return Collections.unmodifiableSet(this.rsrcs);
    }

    @Nullable
    public IgniteBiTuple<Class<?>, String> findResource(final String rsrcName) {
        Class cls = this.rsrcsByAlias.get(rsrcName);
        if (cls != null) {
            return F.t(cls, (Object)rsrcName);
        }
        cls = (Class)F.find(this.rsrcs, null, (IgnitePredicate[])new IgnitePredicate[]{new P1<Class<?>>(){

            public boolean apply(Class<?> cls0) {
                return cls0.getName().equals(rsrcName);
            }
        }});
        return cls != null ? F.t((Object)cls, null) : null;
    }

    public int hashCode() {
        return this.clsLdr.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof GridUriDeploymentUnitDescriptor && this.clsLdr.equals(((GridUriDeploymentUnitDescriptor)obj).clsLdr);
    }

    public String toString() {
        return S.toString(GridUriDeploymentUnitDescriptor.class, (Object)this, (String)"uri", (Object)U.hidePassword((String)this.uri));
    }

    static enum Type {
        FILE,
        CLASS;

    }
}

