/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.yardstick.cache.jdbc.JdbcAbstractBenchmark;

public class JdbcPutIndexedValue8Benchmark
extends JdbcAbstractBenchmark {
    public boolean test(Map<Object, Object> ctx) throws Exception {
        int newKey = JdbcPutIndexedValue8Benchmark.nextRandom(this.args.range());
        int newVal = JdbcPutIndexedValue8Benchmark.nextRandom(this.args.range());
        try (PreparedStatement stmt = this.createUpsertStatement(newKey, newVal);){
            boolean bl = stmt.executeUpdate() > 0;
            return bl;
        }
    }

    @Override
    public void tearDown() throws Exception {
        if (!this.args.createTempDatabase()) {
            this.clearTable("VALUE8");
        }
        super.tearDown();
    }

    private PreparedStatement createUpsertStatement(int newKey, int newVal) throws SQLException {
        int i;
        boolean explicitUpdate;
        PreparedStatement stmt;
        switch (((Connection)this.conn.get()).getMetaData().getDatabaseProductName()) {
            case "H2": {
                stmt = ((Connection)this.conn.get()).prepareStatement("merge into VALUE8(val1, val2, val3, val4, val5, val6, val7, val8) values (?, ?, ?, ?, ?, ?, ?, ?)");
                explicitUpdate = false;
                break;
            }
            case "MySQL": {
                stmt = ((Connection)this.conn.get()).prepareStatement("insert into VALUE8(val1, val2, val3, val4, val5, val6, val7, val8) values(?, ?, ?, ?, ?, ?, ?, ?) on duplicate key update val2 = ?, val3 = ?, val4 = ?, val5 = ?, val6 = ?, val7 = ?, val8 = ?");
                explicitUpdate = true;
                break;
            }
            case "PostgreSQL": {
                stmt = ((Connection)this.conn.get()).prepareStatement("insert into VALUE8(val1, val2, val3, val4, val5, val6, val7, val8) values(?, ?, ?, ?, ?, ?, ?, ?) on conflict(val1) do update set val2 = ?, val3 = ?, val4 = ?, val5 = ?, val6 = ?, val7 = ?, val8 = ?");
                explicitUpdate = true;
                break;
            }
            default: {
                throw new IgniteException("Unexpected database type [databaseProductName=" + ((Connection)this.conn.get()).getMetaData().getDatabaseProductName() + "]");
            }
        }
        for (i = 0; i < 8; ++i) {
            if (i == 0) {
                stmt.setInt(1, newKey);
                continue;
            }
            stmt.setInt(i + 1, newVal + i);
        }
        if (explicitUpdate) {
            for (i = 1; i < 8; ++i) {
                stmt.setInt(i + 8, newVal + i);
            }
        }
        return stmt;
    }
}

