/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryUpdatedListener;
import org.apache.ignite.cache.query.ContinuousQuery;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkDriver;
import org.yardstickframework.BenchmarkProbe;
import org.yardstickframework.BenchmarkProbePoint;
import org.yardstickframework.BenchmarkUtils;

public class CacheEntryEventProbe
implements BenchmarkProbe {
    private BenchmarkConfiguration cfg;
    private Collection<BenchmarkProbePoint> collected = new ArrayList<BenchmarkProbePoint>();
    private QueryCursor qryCur;
    private ExecutorService buildingService;

    public void start(BenchmarkDriver drv, BenchmarkConfiguration cfg) throws Exception {
        IgniteCacheAbstractBenchmark drv0;
        this.cfg = cfg;
        if (drv instanceof IgniteCacheAbstractBenchmark && (drv0 = (IgniteCacheAbstractBenchmark)drv).cache() != null) {
            ContinuousQuery qry = new ContinuousQuery();
            final AtomicLong cnt = new AtomicLong();
            qry.setLocalListener(this.localListener(cnt));
            this.qryCur = drv0.cache().query((Query)qry);
            this.buildingService = Executors.newSingleThreadExecutor();
            this.buildingService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (!Thread.currentThread().isInterrupted()) {
                            Thread.sleep(1000L);
                            long evts = cnt.getAndSet(0L);
                            BenchmarkProbePoint pnt = new BenchmarkProbePoint(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()), new double[]{evts});
                            CacheEntryEventProbe.this.collectPoint(pnt);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)(this.getClass().getSimpleName() + " probe is started."));
        }
        if (this.qryCur == null) {
            BenchmarkUtils.errorHelp((BenchmarkConfiguration)cfg, (String)("Can not start " + this.getClass().getSimpleName() + " probe. Probably, the driver doesn't provide \"cache()\" method."));
        }
    }

    protected CacheEntryUpdatedListener<Integer, Integer> localListener(final AtomicLong cntr) {
        return new CacheEntryUpdatedListener<Integer, Integer>(){

            public void onUpdated(Iterable<CacheEntryEvent<? extends Integer, ? extends Integer>> events) throws CacheEntryListenerException {
                int size = 0;
                for (CacheEntryEvent<? extends Integer, ? extends Integer> e : events) {
                    ++size;
                }
                cntr.addAndGet(size);
            }
        };
    }

    public void stop() throws Exception {
        if (this.qryCur != null) {
            this.qryCur.close();
            this.qryCur = null;
            this.buildingService.shutdownNow();
            this.buildingService.awaitTermination(1L, TimeUnit.MINUTES);
            BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)(this.getClass().getSimpleName() + " is stopped."));
        }
    }

    public Collection<String> metaInfo() {
        return Arrays.asList("Time, sec", "Received events/sec (more is better)");
    }

    public synchronized Collection<BenchmarkProbePoint> points() {
        Collection<BenchmarkProbePoint> ret = this.collected;
        this.collected = new ArrayList<BenchmarkProbePoint>(ret.size() + 5);
        return ret;
    }

    public void buildPoint(long time) {
    }

    private synchronized void collectPoint(BenchmarkProbePoint pnt) {
        this.collected.add(pnt);
    }
}

