/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCluster;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteState;
import org.apache.ignite.Ignition;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.events.Event;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.yardstick.IgniteBenchmarkArguments;
import org.apache.ignite.yardstick.IgniteBenchmarkUtils;
import org.apache.ignite.yardstick.IgniteNode;
import org.apache.ignite.yardstick.PreloadLogger;
import org.jetbrains.annotations.NotNull;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkDriver;
import org.yardstickframework.BenchmarkDriverAdapter;
import org.yardstickframework.BenchmarkUtils;

public abstract class IgniteAbstractBenchmark
extends BenchmarkDriverAdapter {
    protected final IgniteBenchmarkArguments args = new IgniteBenchmarkArguments();
    private PreloadLogger lgr;
    private IgniteNode node;

    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        BenchmarkUtils.jcommander((String[])cfg.commandLineArguments(), (Object)this.args, (String)"<ignite-driver>");
        if (Ignition.state() != IgniteState.STARTED) {
            this.node = new IgniteNode(this.args.isClientOnly() && !this.args.isNearCache());
            this.node.start(cfg);
        } else {
            this.node = new IgniteNode(this.args.isClientOnly() && !this.args.isNearCache(), Ignition.ignite());
        }
        this.waitForNodes();
        this.activateCluster();
        IgniteLogger log = this.ignite().log();
        if (log.isInfoEnabled()) {
            log.info("Benchmark arguments: " + this.args);
        }
    }

    private void activateCluster() {
        boolean pdsInCfg = false;
        DataStorageConfiguration dsCfg = this.ignite().configuration().getDataStorageConfiguration();
        if (dsCfg != null) {
            pdsInCfg = dsCfg.getDefaultDataRegionConfiguration().isPersistenceEnabled();
            DataRegionConfiguration[] drCfgArr = dsCfg.getDataRegionConfigurations();
            if (drCfgArr != null) {
                for (DataRegionConfiguration drCfg : drCfgArr) {
                    if (!drCfg.isPersistenceEnabled()) continue;
                    pdsInCfg = true;
                    break;
                }
            }
        }
        if ((this.args.persistentStoreEnabled() || pdsInCfg) && !this.ignite().cluster().state().active()) {
            BenchmarkUtils.println((String)"Activating cluster.");
            this.ignite().cluster().state(ClusterState.ACTIVE);
        }
    }

    protected void startPreloadLogging(long logInterval) {
        try {
            if (this.node != null && this.cfg != null && logInterval >= 0L) {
                this.lgr = IgniteBenchmarkUtils.startPreloadLogger(this.node, this.cfg, logInterval);
            } else {
                BenchmarkUtils.println((String)("Failed to start preload logger [node=" + this.node + ", cfg = " + this.cfg + ", logInterval = " + logInterval + "]"));
            }
        }
        catch (Exception e) {
            BenchmarkUtils.error((String)("Failed to start preload logger [node=" + this.node + ", cfg = " + this.cfg + ", logInterval = " + logInterval + "]"), (Throwable)e);
        }
    }

    protected void stopPreloadLogging() {
        if (this.lgr != null) {
            this.lgr.stopAndPrintStatistics();
        }
    }

    public void tearDown() throws Exception {
        if (this.node != null) {
            this.node.stop();
        }
    }

    public String description() {
        String desc = BenchmarkUtils.description((BenchmarkConfiguration)this.cfg, (BenchmarkDriver)this);
        return desc.isEmpty() ? ((Object)((Object)this)).getClass().getSimpleName() + this.args.description() + this.cfg.defaultDescription() : desc;
    }

    public String usage() {
        return BenchmarkUtils.usage((Object)this.args);
    }

    protected Ignite ignite() {
        return this.node.ignite();
    }

    private void waitForNodes() throws Exception {
        final CountDownLatch nodesStartedLatch = new CountDownLatch(1);
        this.ignite().events().localListen((IgnitePredicate)new IgnitePredicate<Event>(){

            public boolean apply(Event gridEvt) {
                if (IgniteAbstractBenchmark.this.nodesStarted()) {
                    nodesStartedLatch.countDown();
                }
                return true;
            }
        }, new int[]{10});
        if (!this.nodesStarted()) {
            BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("Waiting for the cluster to contain at least " + this.args.nodes() + " nodes..."));
            nodesStartedLatch.await();
        }
        BenchmarkUtils.println((String)"Cluster is ready");
    }

    private boolean nodesStarted() {
        long curTop;
        IgniteCluster cluster = this.ignite().cluster();
        UUID locNodeId = cluster.localNode().id();
        for (long top = curTop = cluster.topologyVersion(); top >= 1L; --top) {
            Collection nodes = cluster.topology(top);
            if (nodes == null || !IgniteAbstractBenchmark.topologyContainsId(nodes, locNodeId) || nodes.size() < this.args.nodes()) continue;
            return true;
        }
        return false;
    }

    private static boolean topologyContainsId(@NotNull Collection<? extends ClusterNode> top, UUID nodeId) {
        for (ClusterNode clusterNode : top) {
            if (!clusterNode.id().equals(nodeId)) continue;
            return true;
        }
        return false;
    }

    public static int nextRandom(int max) {
        return ThreadLocalRandom.current().nextInt(max);
    }

    protected int nextRandom(int min, int max) {
        return ThreadLocalRandom.current().nextInt(max - min) + min;
    }
}

