/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public class JdbcSetTxParametersRequest
extends JdbcRequest {
    private TransactionConcurrency concurrency;
    @Nullable
    private TransactionIsolation isolation;
    private int timeout;
    private String lb;

    public JdbcSetTxParametersRequest() {
        super((byte)21);
    }

    public JdbcSetTxParametersRequest(TransactionConcurrency concurrency, @Nullable TransactionIsolation isolation, int timeout, String lb) {
        this();
        this.concurrency = concurrency;
        this.isolation = isolation;
        this.timeout = timeout;
        this.lb = lb;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.writeBinary(writer, protoCtx);
        writer.writeByte((byte)this.concurrency.ordinal());
        writer.writeByte((byte)(this.isolation == null ? -1 : this.isolation.ordinal()));
        writer.writeInt(this.timeout);
        writer.writeString(this.lb);
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.readBinary(reader, protoCtx);
        this.concurrency = TransactionConcurrency.fromOrdinal(reader.readByte());
        byte isolationByte = reader.readByte();
        this.isolation = isolationByte == -1 ? null : TransactionIsolation.fromOrdinal(isolationByte);
        this.timeout = reader.readInt();
        this.lb = reader.readString();
    }

    public TransactionConcurrency concurrency() {
        return this.concurrency;
    }

    public TransactionIsolation isolation() {
        return this.isolation;
    }

    public long timeout() {
        return this.timeout;
    }

    public String label() {
        return this.lb;
    }

    @Override
    public String toString() {
        return S.toString(JdbcSetTxParametersRequest.class, this);
    }
}

