/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.DeltaApplicationException;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class RemoveRecord
extends PageDeltaRecord {
    private int idx;
    private int cnt;

    public RemoveRecord(int grpId, long pageId, int idx, int cnt) {
        super(grpId, pageId);
        this.idx = idx;
        this.cnt = cnt;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        Object io = PageIO.getBPlusIO(pageAddr);
        if (((BPlusIO)io).getCount(pageAddr) != this.cnt) {
            throw new DeltaApplicationException("Count is wrong [expCnt=" + this.cnt + ", actual=" + ((BPlusIO)io).getCount(pageAddr) + "]");
        }
        ((BPlusIO)io).remove(pageAddr, this.idx, this.cnt);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.BTREE_PAGE_REMOVE;
    }

    public int index() {
        return this.idx;
    }

    public int count() {
        return this.cnt;
    }

    @Override
    public String toString() {
        return S.toString(RemoveRecord.class, this, "super", (Object)super.toString());
    }
}

