/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorTaskArgument<A>
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private List<UUID> nodes;
    private A arg;
    private boolean debug;

    public VisorTaskArgument() {
    }

    public VisorTaskArgument(Collection<UUID> nodes, A arg, boolean debug) {
        assert (nodes != null);
        assert (!nodes.isEmpty());
        this.nodes = VisorTaskArgument.toList(nodes);
        this.arg = arg;
        this.debug = debug;
    }

    public VisorTaskArgument(Collection<UUID> nodes, boolean debug) {
        this(nodes, null, debug);
    }

    public VisorTaskArgument(UUID node, A arg, boolean debug) {
        this(Collections.singletonList(node), arg, debug);
    }

    public VisorTaskArgument(UUID node, boolean debug) {
        this(node, null, debug);
    }

    public List<UUID> getNodes() {
        return this.nodes;
    }

    public A getArgument() {
        return this.arg;
    }

    public boolean isDebug() {
        return this.debug;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeCollection(out, this.nodes);
        out.writeObject(this.arg);
        out.writeBoolean(this.debug);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodes = U.readList(in);
        this.arg = in.readObject();
        this.debug = in.readBoolean();
    }

    public String toString() {
        return S.toString(VisorTaskArgument.class, this);
    }
}

