/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.QueryEngineConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.jdbc.thin.JdbcThinUtils;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerAbstractConnectionContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerMessageParser;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestHandler;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponseSender;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMessageParser;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequestHandler;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcThinFeature;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcUtils;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxContext;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryEngineConfigurationEx;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public class JdbcConnectionContext
extends ClientListenerAbstractConnectionContext {
    private static final ClientListenerProtocolVersion VER_2_1_0 = ClientListenerProtocolVersion.create(2, 1, 0);
    private static final ClientListenerProtocolVersion VER_2_1_5 = ClientListenerProtocolVersion.create(2, 1, 5);
    static final ClientListenerProtocolVersion VER_2_3_0 = ClientListenerProtocolVersion.create(2, 3, 0);
    static final ClientListenerProtocolVersion VER_2_4_0 = ClientListenerProtocolVersion.create(2, 4, 0);
    static final ClientListenerProtocolVersion VER_2_5_0 = ClientListenerProtocolVersion.create(2, 5, 0);
    static final ClientListenerProtocolVersion VER_2_7_0 = ClientListenerProtocolVersion.create(2, 7, 0);
    static final ClientListenerProtocolVersion VER_2_8_0 = ClientListenerProtocolVersion.create(2, 8, 0);
    static final ClientListenerProtocolVersion VER_2_9_0 = ClientListenerProtocolVersion.create(2, 9, 0);
    static final ClientListenerProtocolVersion VER_2_13_0 = ClientListenerProtocolVersion.create(2, 13, 0);
    static final ClientListenerProtocolVersion VER_2_17_0;
    public static final ClientListenerProtocolVersion CURRENT_VER;
    private static final Set<ClientListenerProtocolVersion> SUPPORTED_VERS;
    public static final String DEFAULT_NESTED_TX_MODE = "ERROR";
    private final GridSpinBusyLock busyLock;
    private final IgniteLogger log;
    private final int maxCursors;
    private JdbcMessageParser parser;
    private JdbcRequestHandler handler;
    private JdbcProtocolContext protoCtx;
    private AtomicReference<AffinityTopologyVersion> lastAffinityTopVer = new AtomicReference();
    @Nullable
    private ClientTxContext txCtx;

    public JdbcConnectionContext(GridKernalContext ctx, GridNioSession ses, GridSpinBusyLock busyLock, long connId, int maxCursors) {
        super(ctx, ses, connId);
        this.busyLock = busyLock;
        this.maxCursors = maxCursors;
        this.log = ctx.log(this.getClass());
    }

    @Override
    public byte clientType() {
        return 1;
    }

    @Override
    public boolean isVersionSupported(ClientListenerProtocolVersion ver) {
        return SUPPORTED_VERS.contains(ver);
    }

    @Override
    public ClientListenerProtocolVersion defaultVersion() {
        return CURRENT_VER;
    }

    @Override
    public void initializeFromHandshake(final GridNioSession ses, ClientListenerProtocolVersion ver, BinaryReaderExImpl reader) throws IgniteCheckedException {
        String nestedTxModeName;
        assert (SUPPORTED_VERS.contains(ver)) : "Unsupported JDBC protocol version.";
        boolean distributedJoins = reader.readBoolean();
        boolean enforceJoinOrder = reader.readBoolean();
        boolean collocated = reader.readBoolean();
        boolean replicatedOnly = reader.readBoolean();
        boolean autoCloseCursors = reader.readBoolean();
        boolean lazyExec = false;
        boolean skipReducerOnUpdate = false;
        String qryEngine = null;
        if (ver.compareTo(VER_2_1_5) >= 0) {
            lazyExec = reader.readBoolean();
        }
        if (ver.compareTo(VER_2_3_0) >= 0) {
            skipReducerOnUpdate = reader.readBoolean();
        }
        if (ver.compareTo(VER_2_7_0) >= 0 && !F.isEmpty(nestedTxModeName = reader.readString()) && !nestedTxModeName.equals(DEFAULT_NESTED_TX_MODE)) {
            throw new IgniteCheckedException("Nested transactions are not supported!");
        }
        Boolean dataPageScanEnabled = null;
        Integer updateBatchSize = null;
        EnumSet<JdbcThinFeature> features = EnumSet.noneOf(JdbcThinFeature.class);
        if (ver.compareTo(VER_2_8_0) >= 0) {
            dataPageScanEnabled = JdbcThinUtils.nullableBooleanFromByte(reader.readByte());
            updateBatchSize = JdbcUtils.readNullableInteger(reader);
        }
        if (ver.compareTo(VER_2_9_0) >= 0) {
            this.userAttrs = reader.readMap();
            byte[] cliFeatures = reader.readByteArray();
            features = JdbcThinFeature.enumSet(cliFeatures);
            if (!U.isTxAwareQueriesEnabled(this.ctx)) {
                features.remove(JdbcThinFeature.TX_AWARE_QUERIES);
            }
        }
        if (ver.compareTo(VER_2_13_0) >= 0 && (qryEngine = reader.readString()) != null) {
            QueryEngineConfiguration[] cfgs = this.ctx.config().getSqlConfiguration().getQueryEnginesConfiguration();
            boolean found = false;
            if (cfgs != null) {
                for (int i = 0; i < cfgs.length; ++i) {
                    if (!qryEngine.equalsIgnoreCase(((QueryEngineConfigurationEx)cfgs[i]).engineName())) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                throw new IgniteCheckedException("Not found configuration for query engine: " + qryEngine);
            }
        }
        TransactionConcurrency concurrency = null;
        TransactionIsolation isolation = null;
        int timeout = 0;
        String lb = null;
        if (ver.compareTo(VER_2_17_0) >= 0) {
            concurrency = TransactionConcurrency.fromOrdinal(reader.readByte());
            isolation = TransactionIsolation.fromOrdinal(reader.readByte());
            timeout = reader.readInt();
            lb = reader.readString();
        }
        if (ver.compareTo(VER_2_5_0) >= 0) {
            String user = null;
            String passwd = null;
            try {
                if (reader.available() > 0) {
                    user = reader.readString();
                    passwd = reader.readString();
                }
            }
            catch (Exception e) {
                throw new IgniteCheckedException("Handshake error: " + e.getMessage(), e);
            }
            this.authenticate(ses, user, passwd);
        }
        this.protoCtx = new JdbcProtocolContext(ver, features, true);
        this.initClientDescriptor("jdbc-thin");
        this.parser = new JdbcMessageParser(this.ctx, this.protoCtx);
        ClientListenerResponseSender snd = new ClientListenerResponseSender(){

            @Override
            public void send(ClientListenerResponse resp) {
                if (resp != null) {
                    if (JdbcConnectionContext.this.log.isDebugEnabled()) {
                        JdbcConnectionContext.this.log.debug("Async response: [resp=" + resp.status() + "]");
                    }
                    ses.send(JdbcConnectionContext.this.parser.encode(resp));
                }
            }
        };
        this.handler = new JdbcRequestHandler(this.busyLock, snd, this.maxCursors, distributedJoins, enforceJoinOrder, collocated, replicatedOnly, autoCloseCursors, lazyExec, skipReducerOnUpdate, qryEngine, dataPageScanEnabled, updateBatchSize, concurrency, isolation, timeout, lb, ver, this);
        this.handler.start();
    }

    @Override
    public ClientListenerRequestHandler handler() {
        return this.handler;
    }

    @Override
    public ClientListenerMessageParser parser() {
        return this.parser;
    }

    @Override
    public void onDisconnected() {
        this.handler.onDisconnect();
        super.onDisconnected();
    }

    @Override
    @Nullable
    public ClientTxContext txContext(int txId) {
        this.ensureSameTransaction(txId);
        return this.txCtx;
    }

    @Override
    public void addTxContext(ClientTxContext txCtx) {
        if (this.txCtx != null) {
            throw new IgniteSQLException("Too many transactions", 3014);
        }
        this.txCtx = txCtx;
    }

    @Override
    public void removeTxContext(int txId) {
        this.ensureSameTransaction(txId);
        this.txCtx = null;
    }

    private void ensureSameTransaction(int txId) {
        if (this.txCtx != null && this.txCtx.txId() != txId) {
            throw new IllegalStateException("Unknown transaction [serverTxId=" + (this.txCtx == null ? null : Integer.valueOf(this.txCtx.txId())) + ", txId=" + txId + "]");
        }
    }

    @Override
    protected void cleanupTxs() {
        if (this.txCtx != null) {
            this.txCtx.close();
        }
        this.txCtx = null;
    }

    public AffinityTopologyVersion getAffinityTopologyVersionIfChanged() {
        AffinityTopologyVersion newVer;
        AffinityTopologyVersion oldVer;
        boolean success;
        boolean changed;
        do {
            oldVer = this.lastAffinityTopVer.get();
            newVer = this.ctx.cache().context().exchange().readyAffinityVersion();
            boolean bl = changed = oldVer == null || oldVer.compareTo(newVer) < 0;
        } while (changed && !(success = this.lastAffinityTopVer.compareAndSet(oldVer, newVer)));
        return changed ? newVer : null;
    }

    public JdbcProtocolContext protocolContext() {
        return this.protoCtx;
    }

    static {
        CURRENT_VER = VER_2_17_0 = ClientListenerProtocolVersion.create(2, 17, 0);
        SUPPORTED_VERS = new HashSet<ClientListenerProtocolVersion>();
        SUPPORTED_VERS.add(CURRENT_VER);
        SUPPORTED_VERS.add(VER_2_13_0);
        SUPPORTED_VERS.add(VER_2_9_0);
        SUPPORTED_VERS.add(VER_2_8_0);
        SUPPORTED_VERS.add(VER_2_7_0);
        SUPPORTED_VERS.add(VER_2_5_0);
        SUPPORTED_VERS.add(VER_2_4_0);
        SUPPORTED_VERS.add(VER_2_3_0);
        SUPPORTED_VERS.add(VER_2_1_5);
        SUPPORTED_VERS.add(VER_2_1_0);
    }
}

