/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.snapshot;

import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.management.snapshot.SnapshotCreateCommandArg;
import org.apache.ignite.internal.management.snapshot.SnapshotJob;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;

@GridInternal
public class SnapshotCreateTask
extends VisorOneNodeTask<SnapshotCreateCommandArg, String> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<SnapshotCreateCommandArg, String> job(SnapshotCreateCommandArg arg) {
        return new SnapshotCreateJob(arg, this.debug);
    }

    private static class SnapshotCreateJob
    extends SnapshotJob<SnapshotCreateCommandArg, String> {
        private static final long serialVersionUID = 0L;

        protected SnapshotCreateJob(SnapshotCreateCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected String run(SnapshotCreateCommandArg arg) throws IgniteException {
            IgniteSnapshotManager.ClusterSnapshotFuture snpFut;
            IgniteFutureImpl<Void> fut = this.ignite.context().cache().context().snapshotMgr().createSnapshot(arg.snapshotName(), arg.dest(), arg.incremental(), false);
            IgniteSnapshotManager.ClusterSnapshotFuture clusterSnapshotFuture = snpFut = fut.internalFuture() instanceof IgniteSnapshotManager.ClusterSnapshotFuture ? (IgniteSnapshotManager.ClusterSnapshotFuture)fut.internalFuture() : null;
            if (arg.sync() || fut.isDone()) {
                fut.get();
            }
            String msgOperId = snpFut != null && snpFut.requestId() != null ? ", id=" + snpFut.requestId() : "";
            return "Snapshot create operation " + (arg.sync() ? "completed successfully" : "started") + " [name=" + arg.snapshotName() + msgOperId + "]";
        }
    }
}

