/*
 * Decompiled with CFR 0.152.
 */
package org.yardstickframework.probes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkDriver;
import org.yardstickframework.BenchmarkExecutionAwareProbe;
import org.yardstickframework.BenchmarkProbePoint;
import org.yardstickframework.BenchmarkTotalsOnlyProbe;
import org.yardstickframework.BenchmarkUtils;

public class PercentileProbe
implements BenchmarkExecutionAwareProbe,
BenchmarkTotalsOnlyProbe {
    public static final String BUCKET_INTERVAL = "BENCHMARK_PROBE_PERCENTILE_BUCKET_INTERVAL";
    public static final String BUCKETS_CNT = "BENCHMARK_PROBE_PERCENTILE_BUCKETS_CNT";
    public static final String TIME_UNIT = "BENCHMARK_PROBE_PERCENTILE_TIME_UNIT";
    public static final long DEFAULT_BUCKET_INTERVAL = 100L;
    public static final int DEFAULT_BUCKETS_CNT = 200;
    public static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MICROSECONDS;
    private ThreadAgent[] agents;
    private BenchmarkConfiguration cfg;
    private int bucketsCnt;
    private long bucketInterval;
    private TimeUnit timeUnit;

    @Override
    public void start(BenchmarkDriver drv, BenchmarkConfiguration cfg) throws Exception {
        this.cfg = cfg;
        this.bucketInterval = PercentileProbe.interval(cfg);
        this.bucketsCnt = PercentileProbe.count(cfg);
        this.timeUnit = PercentileProbe.timeUnit(cfg);
        this.agents = new ThreadAgent[cfg.threads()];
        for (int i = 0; i < this.agents.length; ++i) {
            this.agents[i] = new ThreadAgent();
        }
        BenchmarkUtils.println(cfg, this.getClass().getSimpleName() + " is started.");
    }

    @Override
    public void stop() throws Exception {
        BenchmarkUtils.println(this.cfg, this.getClass().getSimpleName() + " is stopped.");
    }

    @Override
    public Collection<String> metaInfo() {
        return Arrays.asList("Latency, " + this.unitAsString(), "Operations, %");
    }

    private String unitAsString() {
        return this.timeUnit != null ? this.timeUnit.name().toLowerCase() : "n/a";
    }

    @Override
    public Collection<BenchmarkProbePoint> points() {
        long[] buckets0 = new long[this.bucketsCnt];
        for (ThreadAgent agent : this.agents) {
            long[] b0 = agent.reset();
            for (int i = 0; i < b0.length; ++i) {
                int n = i;
                buckets0[n] = buckets0[n] + b0[i];
            }
        }
        ArrayList<BenchmarkProbePoint> ret = new ArrayList<BenchmarkProbePoint>(this.bucketsCnt + 1);
        if (this.bucketsCnt > 0) {
            ret.add(new BenchmarkProbePoint(0L, new double[]{0.0}));
        }
        long sum = 0L;
        for (long b : buckets0) {
            sum += b;
        }
        for (int i = 0; i < buckets0.length; ++i) {
            ret.add(new BenchmarkProbePoint((long)(i + 1) * this.bucketInterval, new double[]{(double)buckets0[i] / (double)sum}));
        }
        return ret;
    }

    @Override
    public void buildPoint(long time) {
    }

    @Override
    public void beforeExecute(int threadIdx) {
        this.agents[threadIdx].beforeExecute();
    }

    @Override
    public void afterExecute(int threadIdx) {
        this.agents[threadIdx].afterExecute();
    }

    private static long interval(BenchmarkConfiguration cfg) {
        try {
            return Long.parseLong(cfg.customProperties().get(BUCKET_INTERVAL));
        }
        catch (NullPointerException | NumberFormatException ignored) {
            return 100L;
        }
    }

    private static int count(BenchmarkConfiguration cfg) {
        try {
            return Integer.parseInt(cfg.customProperties().get(BUCKETS_CNT));
        }
        catch (NullPointerException | NumberFormatException ignored) {
            return 200;
        }
    }

    private static TimeUnit timeUnit(BenchmarkConfiguration cfg) {
        try {
            return TimeUnit.valueOf(cfg.customProperties().get(TIME_UNIT));
        }
        catch (IllegalArgumentException | NullPointerException ignored) {
            return DEFAULT_TIME_UNIT;
        }
    }

    private class ThreadAgent {
        private long beforeTs;
        private volatile long[] buckets;

        private ThreadAgent() {
            this.buckets = new long[PercentileProbe.this.bucketsCnt];
        }

        public void beforeExecute() {
            this.beforeTs = System.nanoTime();
        }

        public void afterExecute() {
            long latency = System.nanoTime() - this.beforeTs;
            this.beforeTs = 0L;
            long bucketIdx = PercentileProbe.this.timeUnit.convert(latency, TimeUnit.NANOSECONDS) / PercentileProbe.this.bucketInterval;
            int idx = bucketIdx >= (long)PercentileProbe.this.bucketsCnt ? PercentileProbe.this.bucketsCnt - 1 : (int)bucketIdx;
            long[] b = this.buckets;
            int n = idx;
            b[n] = b[n] + 1L;
            this.buckets = b;
        }

        public long[] reset() {
            long[] b = this.buckets;
            this.buckets = new long[PercentileProbe.this.bucketsCnt];
            return b;
        }
    }
}

