/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.memory;

import java.lang.ref.Cleaner;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemoryUtils;
import org.apache.ignite.internal.processors.platform.memory.PlatformPooledMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformUnpooledMemory;

public class PlatformMemoryPool {
    private final long poolPtr = PlatformMemoryUtils.allocatePool();
    private static final Cleaner cleaner = Cleaner.create();
    private PlatformPooledMemory mem1;
    private PlatformPooledMemory mem2;
    private PlatformPooledMemory mem3;

    public PlatformMemoryPool() {
        cleaner.register(this, new CleanerRunnable(this.poolPtr));
    }

    public PlatformMemory allocate(int cap) {
        long memPtr = PlatformMemoryUtils.allocatePooled(this.poolPtr, cap);
        return memPtr != 0L ? this.get(memPtr) : new PlatformUnpooledMemory(PlatformMemoryUtils.allocateUnpooled(cap));
    }

    void reallocate(long memPtr, int cap) {
        PlatformMemoryUtils.reallocatePooled(memPtr, cap);
    }

    void release(long memPtr) {
        PlatformMemoryUtils.releasePooled(memPtr);
    }

    public PlatformMemory get(long memPtr) {
        long delta = memPtr - this.poolPtr;
        if (delta == 0L) {
            if (this.mem1 == null) {
                this.mem1 = new PlatformPooledMemory(this, memPtr);
            }
            return this.mem1;
        }
        if (delta == 20L) {
            if (this.mem2 == null) {
                this.mem2 = new PlatformPooledMemory(this, memPtr);
            }
            return this.mem2;
        }
        assert (delta == 40L);
        if (this.mem3 == null) {
            this.mem3 = new PlatformPooledMemory(this, memPtr);
        }
        return this.mem3;
    }

    private static class CleanerRunnable
    implements Runnable {
        private final long poolPtr;

        private CleanerRunnable(long poolPtr) {
            assert (poolPtr != 0L);
            this.poolPtr = poolPtr;
        }

        @Override
        public void run() {
            PlatformMemoryUtils.releasePool(this.poolPtr);
        }
    }
}

