/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.util;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.ToIntFunction;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Sarg;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.ExactBounds;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.MultiBounds;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.RangeBounds;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.processors.query.calcite.sql.fun.IgniteOwnSqlOperatorTable;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.processors.query.calcite.util.TypeUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class RexUtils {
    public static final int MAX_SEARCH_BOUNDS_COMPLEXITY = 100;
    private static final Set<SqlKind> BINARY_COMPARISON = EnumSet.of(SqlKind.EQUALS, new SqlKind[]{SqlKind.IS_NOT_DISTINCT_FROM, SqlKind.LESS_THAN, SqlKind.GREATER_THAN, SqlKind.GREATER_THAN_OR_EQUAL, SqlKind.LESS_THAN_OR_EQUAL});
    private static final Set<SqlKind> TREE_INDEX_COMPARISON = EnumSet.of(SqlKind.SEARCH, new SqlKind[]{SqlKind.IS_NULL, SqlKind.IS_NOT_NULL, SqlKind.EQUALS, SqlKind.IS_NOT_DISTINCT_FROM, SqlKind.LESS_THAN, SqlKind.GREATER_THAN, SqlKind.GREATER_THAN_OR_EQUAL, SqlKind.LESS_THAN_OR_EQUAL});

    public static RexNode makeCast(RexBuilder builder, RexNode node, RelDataType type) {
        return TypeUtils.needCast(builder.getTypeFactory(), node.getType(), type) ? builder.makeCast(type, node) : node;
    }

    public static RexBuilder builder(RelNode rel) {
        return RexUtils.builder(rel.getCluster());
    }

    public static RexBuilder builder(RelOptCluster cluster) {
        return cluster.getRexBuilder();
    }

    public static RexExecutor executor(RelNode rel) {
        return RexUtils.executor(rel.getCluster());
    }

    public static RexExecutor executor(RelOptCluster cluster) {
        return (RexExecutor)Util.first((Object)cluster.getPlanner().getExecutor(), (Object)RexUtil.EXECUTOR);
    }

    public static RexSimplify simplifier(RelOptCluster cluster) {
        return new RexSimplify(RexUtils.builder(cluster), RelOptPredicateList.EMPTY, RexUtils.executor(cluster));
    }

    public static RexNode makeCase(RexBuilder builder, RexNode ... operands) {
        if (U.assertionsEnabled()) {
            for (int i = 0; i < operands.length; i += 2) {
                if (operands[i].getType().getSqlTypeName() != SqlTypeName.BOOLEAN && i < operands.length - 1) {
                    throw new AssertionError((Object)("Unexpected operand type. [operands=" + Arrays.toString(operands) + "]"));
                }
            }
        }
        return builder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, operands);
    }

    public static boolean isIdentity(List<? extends RexNode> projects, RelDataType inputRowType) {
        return RexUtils.isIdentity(projects, inputRowType, false);
    }

    public static boolean isIdentity(List<? extends RexNode> projects, RelDataType inputRowType, boolean local) {
        if (inputRowType.getFieldCount() != projects.size()) {
            return false;
        }
        List fields = inputRowType.getFieldList();
        Class clazz = local ? RexLocalRef.class : RexInputRef.class;
        for (int i = 0; i < fields.size(); ++i) {
            if (!clazz.isInstance(projects.get(i))) {
                return false;
            }
            RexSlot ref = (RexSlot)projects.get(i);
            if (ref.getIndex() != i) {
                return false;
            }
            if (RelOptUtil.eq((String)"t1", (RelDataType)projects.get(i).getType(), (String)"t2", (RelDataType)((RelDataTypeField)fields.get(i)).getType(), (Litmus)Litmus.IGNORE)) continue;
            return false;
        }
        return true;
    }

    public static List<SearchBounds> buildSortedSearchBounds(RelOptCluster cluster, RelCollation collation, RexNode condition, RelDataType rowType, ImmutableBitSet requiredColumns) {
        RelFieldCollation fc;
        int collFldIdx;
        List<RexCall> collFldPreds;
        if (condition == null) {
            return null;
        }
        condition = RexUtil.toCnf((RexBuilder)RexUtils.builder(cluster), (RexNode)condition);
        Map<Integer, List<RexCall>> fieldsToPredicates = RexUtils.mapPredicatesToFields(condition, cluster);
        if (F.isEmpty(fieldsToPredicates)) {
            return null;
        }
        if (collation == null || collation.isDefault()) {
            ArrayList equalsFields = new ArrayList(fieldsToPredicates.size());
            ArrayList otherFields = new ArrayList(fieldsToPredicates.size());
            fieldsToPredicates.forEach((idx, conds) -> (F.exist((Iterable)conds, (IgnitePredicate[])new IgnitePredicate[]{(IgnitePredicate & Serializable)call -> call.getOperator().getKind() == SqlKind.EQUALS}) ? equalsFields : otherFields).add(idx));
            collation = TraitUtils.createCollation(F.concat((boolean)true, equalsFields, otherFields));
        }
        List types = RelOptUtil.getFieldTypeList((RelDataType)rowType);
        Mappings.TargetMapping mapping = null;
        if (requiredColumns != null) {
            mapping = Commons.inverseMapping(requiredColumns, types.size());
        }
        List<SearchBounds> bounds = Arrays.asList(new SearchBounds[types.size()]);
        boolean boundsEmpty = true;
        int prevComplexity = 1;
        for (int i = 0; i < collation.getFieldCollations().size() && !F.isEmpty(collFldPreds = fieldsToPredicates.get(collFldIdx = (fc = (RelFieldCollation)collation.getFieldCollations().get(i)).getFieldIndex())); ++i) {
            SearchBounds fldBounds;
            if (mapping != null) {
                collFldIdx = mapping.getSourceOpt(collFldIdx);
            }
            if ((fldBounds = RexUtils.createBounds(fc, collFldPreds, cluster, (RelDataType)types.get(collFldIdx), prevComplexity)) == null) break;
            boundsEmpty = false;
            bounds.set(collFldIdx, fldBounds);
            if (fldBounds instanceof MultiBounds) {
                prevComplexity *= ((MultiBounds)fldBounds).bounds().size();
                if (((MultiBounds)fldBounds).bounds().stream().anyMatch(b -> b.type() != SearchBounds.Type.EXACT)) break;
            }
            if (fldBounds.type() == SearchBounds.Type.RANGE) break;
        }
        return boundsEmpty ? null : bounds;
    }

    public static List<SearchBounds> buildHashSearchBounds(RelOptCluster cluster, RexNode condition, RelDataType rowType, ImmutableBitSet requiredColumns, boolean ignoreNotEqualPreds) {
        int fldIdx;
        List<RexCall> collFldPreds;
        condition = RexUtil.toCnf((RexBuilder)RexUtils.builder(cluster), (RexNode)condition);
        Map<Integer, List<RexCall>> fieldsToPredicates = RexUtils.mapPredicatesToFields(condition, cluster);
        if (F.isEmpty(fieldsToPredicates)) {
            return null;
        }
        List<SearchBounds> bounds = null;
        List types = RelOptUtil.getFieldTypeList((RelDataType)rowType);
        Mappings.TargetMapping mapping = null;
        if (requiredColumns != null) {
            mapping = Commons.inverseMapping(requiredColumns, types.size());
        }
        Iterator<Integer> iterator = fieldsToPredicates.keySet().iterator();
        while (iterator.hasNext() && !F.isEmpty(collFldPreds = fieldsToPredicates.get(fldIdx = iterator.next().intValue()))) {
            for (RexCall pred : collFldPreds) {
                if (pred.getOperator().kind != SqlKind.EQUALS && pred.getOperator().kind != SqlKind.IS_NOT_DISTINCT_FROM) {
                    if (ignoreNotEqualPreds) continue;
                    return null;
                }
                if (bounds == null) {
                    bounds = Arrays.asList(new SearchBounds[types.size()]);
                }
                if (mapping != null) {
                    fldIdx = mapping.getSourceOpt(fldIdx);
                }
                bounds.set(fldIdx, new ExactBounds((RexNode)pred, RexUtils.makeCast(RexUtils.builder(cluster), RexUtil.removeCast((RexNode)((RexNode)pred.operands.get(1))), (RelDataType)types.get(fldIdx))));
            }
        }
        return bounds;
    }

    /*
     * Unable to fully structure code
     */
    private static SearchBounds createBounds(@Nullable RelFieldCollation fc, List<RexCall> collFldPreds, RelOptCluster cluster, RelDataType fldType, int prevComplexity) {
        builder = RexUtils.builder(cluster);
        nullBound = builder.makeCall((SqlOperator)IgniteOwnSqlOperatorTable.NULL_BOUND, new RexNode[0]);
        upperCond = null;
        lowerCond = null;
        upperBound = null;
        lowerBound = null;
        upperInclude = true;
        lowerInclude = true;
        collFldPreds.sort(Comparator.comparingInt((ToIntFunction<RexCall>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$createBounds$2(org.apache.calcite.rex.RexCall ), (Lorg/apache/calcite/rex/RexCall;)I)()));
        block5: for (RexCall pred : collFldPreds) {
            val = null;
            ref = (RexNode)pred.getOperands().get(0);
            if (RexUtils.isBinaryComparison((RexNode)pred)) {
                val = RexUtil.removeCast((RexNode)((RexNode)pred.operands.get(1)));
                if (!RexUtils.$assertionsDisabled && !RexUtils.idxOpSupports(val)) {
                    throw new AssertionError(val);
                }
                val = RexUtils.makeCast(builder, val, fldType);
            }
            op = pred.getOperator();
            if (op.kind == SqlKind.EQUALS) {
                return new ExactBounds((RexNode)pred, val);
            }
            if (op.kind == SqlKind.IS_NOT_DISTINCT_FROM) {
                return new ExactBounds((RexNode)pred, builder.makeCall((SqlOperator)SqlStdOperatorTable.COALESCE, new RexNode[]{val, nullBound}));
            }
            if (op.kind == SqlKind.IS_NULL) {
                return new ExactBounds((RexNode)pred, nullBound);
            }
            if (op.kind == SqlKind.OR) {
                orBounds = new ArrayList<SearchBounds>();
                curComplexity = 0;
                for (RexNode operand : pred.getOperands()) {
                    opBounds = RexUtils.createBounds(fc, Collections.singletonList((RexCall)operand), cluster, fldType, prevComplexity);
                    if (opBounds instanceof MultiBounds) {
                        curComplexity += ((MultiBounds)opBounds).bounds().size();
                        orBounds.addAll(((MultiBounds)opBounds).bounds());
                    } else if (opBounds != null) {
                        ++curComplexity;
                        orBounds.add(opBounds);
                    }
                    if (opBounds != null && curComplexity <= 100) continue;
                    orBounds = null;
                    break;
                }
                if (orBounds == null) continue;
                return new MultiBounds((RexNode)pred, orBounds);
            }
            if (op.kind == SqlKind.SEARCH) {
                sarg = (Sarg)((RexLiteral)pred.operands.get(1)).getValueAs(Sarg.class);
                bounds = RexUtils.expandSargToBounds(fc, cluster, fldType, prevComplexity, sarg, ref);
                if (bounds == null) continue;
                if (bounds.size() == 1) {
                    if (bounds.get(0) instanceof RangeBounds && collFldPreds.size() > 1) {
                        ascDir = fc.getDirection().isDescending() == false;
                        rangeBounds = (RangeBounds)bounds.get(0);
                        if (rangeBounds.lowerBound() != null) {
                            if (lowerBound != null && lowerBound != nullBound) {
                                lowerBound = RexUtils.leastOrGreatest(builder, ascDir == false, lowerBound, rangeBounds.lowerBound());
                                lowerInclude |= rangeBounds.lowerInclude();
                            } else {
                                lowerBound = rangeBounds.lowerBound();
                                lowerInclude = rangeBounds.lowerInclude();
                            }
                            lowerCond = RexUtils.lessOrGreater(builder, ascDir == false, lowerInclude, ref, lowerBound);
                        }
                        if (rangeBounds.upperBound() == null) continue;
                        if (upperBound != null && upperBound != nullBound) {
                            upperBound = RexUtils.leastOrGreatest(builder, ascDir, upperBound, rangeBounds.upperBound());
                            upperInclude |= rangeBounds.upperInclude();
                        } else {
                            upperBound = rangeBounds.upperBound();
                            upperInclude = rangeBounds.upperInclude();
                        }
                        upperCond = RexUtils.lessOrGreater(builder, ascDir, upperInclude, ref, upperBound);
                        continue;
                    }
                    return bounds.get(0);
                }
                return new MultiBounds((RexNode)pred, bounds);
            }
            lowerBoundBelow = fc.getDirection().isDescending() == false;
            includeBound = op.kind == SqlKind.GREATER_THAN_OR_EQUAL || op.kind == SqlKind.LESS_THAN_OR_EQUAL;
            lessCondition = false;
            switch (5.$SwitchMap$org$apache$calcite$sql$SqlKind[op.kind.ordinal()]) {
                case 1: 
                case 2: {
                    lessCondition = true;
                    lowerBoundBelow = lowerBoundBelow == false;
                }
                case 3: 
                case 4: {
                    if (!lowerBoundBelow) ** GOTO lbl88
                    if (lowerBound == null || lowerBound == nullBound) {
                        lowerCond = pred;
                        lowerBound = val;
                        lowerInclude = includeBound;
                    } else {
                        lowerBound = RexUtils.leastOrGreatest(builder, lessCondition, lowerBound, val);
                        lowerCond = RexUtils.lessOrGreater(builder, lessCondition, lowerInclude |= includeBound, ref, lowerBound);
                    }
                    ** GOTO lbl95
lbl88:
                    // 1 sources

                    if (upperBound == null || upperBound == nullBound) {
                        upperCond = pred;
                        upperBound = val;
                        upperInclude = includeBound;
                    } else {
                        upperBound = RexUtils.leastOrGreatest(builder, lessCondition, upperBound, val);
                        upperCond = RexUtils.lessOrGreater(builder, lessCondition, upperInclude |= includeBound, ref, upperBound);
                    }
                }
lbl95:
                // 5 sources

                case 5: {
                    if (fc.nullDirection == RelFieldCollation.NullDirection.FIRST && lowerBound == null) {
                        lowerCond = pred;
                        lowerBound = nullBound;
                        lowerInclude = false;
                        continue block5;
                    }
                    if (fc.nullDirection != RelFieldCollation.NullDirection.LAST || upperBound != null) continue block5;
                    upperCond = pred;
                    upperBound = nullBound;
                    upperInclude = false;
                    continue block5;
                }
            }
            throw new AssertionError((Object)("Unknown condition: " + op.kind));
        }
        if (lowerBound == null && upperBound == null) {
            return null;
        }
        cond = lowerCond == null ? upperCond : (upperCond == null ? lowerCond : (upperCond == lowerCond ? lowerCond : builder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{lowerCond, upperCond})));
        return new RangeBounds(cond, lowerBound, upperBound, lowerInclude, upperInclude);
    }

    private static List<SearchBounds> expandSargToBounds(RelFieldCollation fc, RelOptCluster cluster, RelDataType fldType, int prevComplexity, Sarg<?> sarg, RexNode ref) {
        int complexity = prevComplexity * sarg.complexity();
        if (complexity > 100) {
            return null;
        }
        RexBuilder builder = RexUtils.builder(cluster);
        RexNode sargCond = RexUtil.sargRef((RexBuilder)builder, (RexNode)ref, sarg, (RelDataType)fldType, (RexUnknownAs)RexUnknownAs.UNKNOWN);
        List disjunctions = RelOptUtil.disjunctions((RexNode)RexUtil.toDnf((RexBuilder)builder, (RexNode)sargCond));
        ArrayList<SearchBounds> bounds = new ArrayList<SearchBounds>(disjunctions.size());
        for (RexNode bound : disjunctions) {
            List conjunctions = RelOptUtil.conjunctions((RexNode)bound);
            ArrayList<RexCall> calls = new ArrayList<RexCall>(conjunctions.size());
            for (RexNode rexNode : conjunctions) {
                if (RexUtils.isSupportedTreeComparison(rexNode)) {
                    calls.add((RexCall)rexNode);
                    continue;
                }
                return null;
            }
            bounds.add(RexUtils.createBounds(fc, calls, cluster, fldType, complexity));
        }
        return bounds;
    }

    private static RexNode leastOrGreatest(RexBuilder builder, boolean least, RexNode arg0, RexNode arg1) {
        return builder.makeCall((SqlOperator)(least ? IgniteOwnSqlOperatorTable.LEAST2 : IgniteOwnSqlOperatorTable.GREATEST2), new RexNode[]{arg0, arg1});
    }

    private static RexNode lessOrGreater(RexBuilder builder, boolean less, boolean includeBound, RexNode arg0, RexNode arg1) {
        return builder.makeCall((SqlOperator)(less ? (includeBound ? SqlStdOperatorTable.LESS_THAN_OR_EQUAL : SqlStdOperatorTable.LESS_THAN) : (includeBound ? SqlStdOperatorTable.GREATER_THAN_OR_EQUAL : SqlStdOperatorTable.GREATER_THAN)), new RexNode[]{arg0, arg1});
    }

    private static Map<Integer, List<RexCall>> mapPredicatesToFields(RexNode condition, RelOptCluster cluster) {
        List conjunctions = RelOptUtil.conjunctions((RexNode)condition);
        HashMap<Integer, List<RexCall>> res = new HashMap<Integer, List<RexCall>>(conjunctions.size());
        for (RexNode rexNode : conjunctions) {
            Pair refPredicate = null;
            if (rexNode instanceof RexCall && rexNode.getKind() == SqlKind.OR) {
                List operands = ((RexCall)rexNode).getOperands();
                Integer ref = null;
                ArrayList<RexCall> preds = new ArrayList<RexCall>(operands.size());
                for (RexNode operand : operands) {
                    Pair<Integer, RexCall> operandRefPredicate = RexUtils.extractRefPredicate(operand, cluster);
                    if (operandRefPredicate == null) {
                        ref = null;
                        break;
                    }
                    if (ref == null) {
                        ref = (Integer)operandRefPredicate.getKey();
                    } else if (!ref.equals(operandRefPredicate.getKey())) {
                        ref = null;
                        break;
                    }
                    if (RexUtils.containsFieldAccess((RexNode)operandRefPredicate.getValue()).booleanValue()) {
                        ref = null;
                        break;
                    }
                    preds.add((RexCall)operandRefPredicate.getValue());
                }
                if (ref != null) {
                    refPredicate = Pair.of(ref, (Object)((RexCall)RexUtils.builder(cluster).makeCall(((RexCall)rexNode).getOperator(), preds)));
                }
            } else {
                refPredicate = RexUtils.extractRefPredicate(rexNode, cluster);
            }
            if (refPredicate == null) continue;
            List fldPreds = res.computeIfAbsent((Integer)refPredicate.getKey(), k -> new ArrayList(conjunctions.size()));
            fldPreds.add((RexCall)refPredicate.getValue());
        }
        return res;
    }

    private static Pair<Integer, RexCall> extractRefPredicate(RexNode rexNode, RelOptCluster cluster) {
        RexSlot ref;
        if (!RexUtils.isSupportedTreeComparison(rexNode = RexUtils.expandBooleanFieldComparison(rexNode, RexUtils.builder(cluster)))) {
            return null;
        }
        RexCall predCall = (RexCall)rexNode;
        if (RexUtils.isBinaryComparison(rexNode)) {
            ref = (RexSlot)RexUtils.extractRefFromBinary(predCall, cluster);
            if (ref == null) {
                return null;
            }
            if (RexUtils.refOnTheRight(predCall)) {
                predCall = (RexCall)RexUtils.invert(RexUtils.builder(cluster), predCall);
            }
        } else {
            ref = (RexSlot)RexUtils.extractRefFromOperand(predCall, cluster, 0);
            if (ref == null) {
                return null;
            }
        }
        return Pair.of((Object)ref.getIndex(), (Object)predCall);
    }

    private static RexNode invert(RexBuilder rexBuilder, RexCall call) {
        if (call.getOperator() == SqlStdOperatorTable.IS_NOT_DISTINCT_FROM) {
            return rexBuilder.makeCall(call.getOperator(), new RexNode[]{(RexNode)call.getOperands().get(1), (RexNode)call.getOperands().get(0)});
        }
        return RexUtil.invert((RexBuilder)rexBuilder, (RexCall)call);
    }

    private static RexNode expandBooleanFieldComparison(RexNode rexNode, RexBuilder builder) {
        if (rexNode instanceof RexSlot) {
            return builder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexNode, builder.makeLiteral(true)});
        }
        if (rexNode instanceof RexCall && rexNode.getKind() == SqlKind.NOT && ((RexCall)rexNode).getOperands().get(0) instanceof RexSlot) {
            return builder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{(RexNode)((RexCall)rexNode).getOperands().get(0), builder.makeLiteral(false)});
        }
        return rexNode;
    }

    private static RexNode extractRefFromBinary(RexCall call, RelOptCluster cluster) {
        assert (RexUtils.isBinaryComparison((RexNode)call));
        RexNode leftRef = RexUtils.extractRefFromOperand(call, cluster, 0);
        RexNode rightOp = (RexNode)call.getOperands().get(1);
        if (leftRef != null) {
            return RexUtils.idxOpSupports(RexUtil.removeCast((RexNode)rightOp)) ? leftRef : null;
        }
        RexNode rightRef = RexUtils.extractRefFromOperand(call, cluster, 1);
        RexNode leftOp = (RexNode)call.getOperands().get(0);
        if (rightRef != null) {
            return RexUtils.idxOpSupports(RexUtil.removeCast((RexNode)leftOp)) ? rightRef : null;
        }
        return null;
    }

    private static RexNode extractRefFromOperand(RexCall call, RelOptCluster cluster, int operandNum) {
        assert (RexUtils.isSupportedTreeComparison((RexNode)call));
        RexNode op = (RexNode)call.getOperands().get(operandNum);
        if ((op = RexUtil.removeCast((RexNode)op)) instanceof RexSlot && !TypeUtils.needCast(cluster.getTypeFactory(), op.getType(), ((RexNode)call.getOperands().get(operandNum)).getType())) {
            return op;
        }
        return null;
    }

    private static boolean refOnTheRight(RexCall predCall) {
        RexNode rightOp = (RexNode)predCall.getOperands().get(1);
        return (rightOp = RexUtil.removeCast((RexNode)rightOp)).isA(SqlKind.LOCAL_REF) || rightOp.isA(SqlKind.INPUT_REF);
    }

    private static boolean isBinaryComparison(RexNode exp) {
        return BINARY_COMPARISON.contains(exp.getKind()) && exp instanceof RexCall && ((RexCall)exp).getOperands().size() == 2;
    }

    private static boolean isSupportedTreeComparison(RexNode exp) {
        return TREE_INDEX_COMPARISON.contains(exp.getKind()) && exp instanceof RexCall;
    }

    private static boolean idxOpSupports(RexNode op) {
        return op instanceof RexLiteral || op instanceof RexDynamicParam || op instanceof RexFieldAccess || RexUtils.containsRef(op) == false;
    }

    public static boolean isNotNull(RexNode op) {
        if (op == null) {
            return false;
        }
        return !(op instanceof RexLiteral) || !((RexLiteral)op).isNull();
    }

    public static Mappings.TargetMapping inversePermutation(List<RexNode> nodes, RelDataType inputRowType, boolean local) {
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_FUNCTION, (int)nodes.size(), (int)inputRowType.getFieldCount());
        Class clazz = local ? RexLocalRef.class : RexInputRef.class;
        for (Ord node : Ord.zip(nodes)) {
            if (!clazz.isInstance(node.e)) continue;
            mapping.set(node.i, ((RexSlot)node.e).getIndex());
        }
        return mapping;
    }

    public static List<RexNode> replaceLocalRefs(List<RexNode> nodes) {
        return LocalRefReplacer.INSTANCE.apply(nodes);
    }

    public static List<RexNode> replaceInputRefs(List<RexNode> nodes) {
        return InputRefReplacer.INSTANCE.apply(nodes);
    }

    public static RexNode replaceLocalRefs(RexNode node) {
        return LocalRefReplacer.INSTANCE.apply(node);
    }

    public static RexNode replaceInputRefs(RexNode node) {
        return InputRefReplacer.INSTANCE.apply(node);
    }

    public static boolean hasCorrelation(RexNode node) {
        return RexUtils.hasCorrelation(Collections.singletonList(node));
    }

    public static boolean hasCorrelation(List<RexNode> nodes) {
        try {
            RexVisitorImpl<Void> v = new RexVisitorImpl<Void>(true){

                public Void visitCorrelVariable(RexCorrelVariable correlVariable) {
                    throw new ControlFlowException();
                }
            };
            nodes.forEach(arg_0 -> RexUtils.lambda$hasCorrelation$4((RexVisitor)v, arg_0));
            return false;
        }
        catch (ControlFlowException e) {
            return true;
        }
    }

    public static Set<CorrelationId> extractCorrelationIds(RexNode node) {
        if (node == null) {
            return Collections.emptySet();
        }
        return RexUtils.extractCorrelationIds(Collections.singletonList(node));
    }

    public static Set<Integer> notNullKeys(List<RexNode> row) {
        if (F.isEmpty(row)) {
            return Collections.emptySet();
        }
        HashSet<Integer> keys = new HashSet<Integer>();
        for (int i = 0; i < row.size(); ++i) {
            if (!RexUtils.isNotNull(row.get(i))) continue;
            keys.add(i);
        }
        return keys;
    }

    public static double doubleFromRex(RexNode n, double def) {
        try {
            if (n.isA(SqlKind.LITERAL)) {
                return (Double)((RexLiteral)n).getValueAs(Double.class);
            }
            return def;
        }
        catch (Exception e) {
            assert (false) : "Unable to extract value: " + e.getMessage();
            return def;
        }
    }

    public static Set<CorrelationId> extractCorrelationIds(List<RexNode> nodes) {
        final HashSet<CorrelationId> cors = new HashSet<CorrelationId>();
        RexVisitorImpl<Void> v = new RexVisitorImpl<Void>(true){

            public Void visitCorrelVariable(RexCorrelVariable correlVariable) {
                cors.add(correlVariable.id);
                return null;
            }
        };
        nodes.forEach(arg_0 -> RexUtils.lambda$extractCorrelationIds$5((RexVisitor)v, arg_0));
        return cors;
    }

    private static Boolean containsRef(RexNode node) {
        RexVisitorImpl<Void> v = new RexVisitorImpl<Void>(true){

            public Void visitInputRef(RexInputRef inputRef) {
                throw Util.FoundOne.NULL;
            }

            public Void visitLocalRef(RexLocalRef locRef) {
                throw Util.FoundOne.NULL;
            }
        };
        try {
            node.accept((RexVisitor)v);
            return false;
        }
        catch (Util.FoundOne e) {
            return true;
        }
    }

    private static Boolean containsFieldAccess(RexNode node) {
        RexVisitorImpl<Void> v = new RexVisitorImpl<Void>(true){

            public Void visitFieldAccess(RexFieldAccess fieldAccess) {
                throw Util.FoundOne.NULL;
            }
        };
        try {
            node.accept((RexVisitor)v);
            return false;
        }
        catch (Util.FoundOne e) {
            return true;
        }
    }

    private static /* synthetic */ void lambda$extractCorrelationIds$5(RexVisitor v, RexNode rex) {
        rex.accept(v);
    }

    private static /* synthetic */ void lambda$hasCorrelation$4(RexVisitor v, RexNode n) {
        n.accept(v);
    }

    private static /* synthetic */ int lambda$createBounds$2(RexCall pred) {
        switch (pred.getOperator().getKind()) {
            case EQUALS: 
            case IS_NOT_DISTINCT_FROM: 
            case IS_NULL: {
                return 0;
            }
        }
        return 1;
    }

    private static class InputRefReplacer
    extends RexShuttle {
        private static final RexShuttle INSTANCE = new InputRefReplacer();

        private InputRefReplacer() {
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            return new RexLocalRef(inputRef.getIndex(), inputRef.getType());
        }
    }

    private static class LocalRefReplacer
    extends RexShuttle {
        private static final RexShuttle INSTANCE = new LocalRefReplacer();

        private LocalRefReplacer() {
        }

        public RexNode visitLocalRef(RexLocalRef inputRef) {
            return new RexInputRef(inputRef.getIndex(), inputRef.getType());
        }
    }
}

