/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep.msg;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryMarshallable;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridH2DmlRequest
implements Message,
GridCacheQueryMarshallable {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private long reqId;
    @GridToStringInclude
    @GridDirectCollection(value=Integer.class)
    private List<Integer> caches;
    @GridToStringInclude
    private AffinityTopologyVersion topVer;
    @GridToStringInclude
    private int[] qryParts;
    private int pageSize;
    @GridToStringInclude
    private String qry;
    private byte flags;
    private int timeout;
    @GridToStringInclude(sensitive=true)
    @GridDirectTransient
    private Object[] params;
    private byte[] paramsBytes;
    @GridToStringInclude
    private String schemaName;
    @GridToStringInclude
    private boolean explicitTimeout;

    public GridH2DmlRequest() {
    }

    public GridH2DmlRequest(GridH2DmlRequest req) {
        this.reqId = req.reqId;
        this.caches = req.caches;
        this.topVer = req.topVer;
        this.qryParts = req.qryParts;
        this.pageSize = req.pageSize;
        this.qry = req.qry;
        this.flags = req.flags;
        this.timeout = req.timeout;
        this.params = req.params;
        this.paramsBytes = req.paramsBytes;
        this.schemaName = req.schemaName;
        this.explicitTimeout = req.explicitTimeout;
    }

    public Object[] parameters() {
        return this.params;
    }

    public GridH2DmlRequest parameters(Object[] params) {
        if (params == null) {
            params = GridCacheSqlQuery.EMPTY_PARAMS;
        }
        this.params = params;
        return this;
    }

    public GridH2DmlRequest requestId(long reqId) {
        this.reqId = reqId;
        return this;
    }

    public long requestId() {
        return this.reqId;
    }

    public GridH2DmlRequest caches(List<Integer> caches) {
        this.caches = caches;
        return this;
    }

    public List<Integer> caches() {
        return this.caches;
    }

    public GridH2DmlRequest topologyVersion(AffinityTopologyVersion topVer) {
        this.topVer = topVer;
        return this;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public int[] queryPartitions() {
        return this.qryParts;
    }

    public GridH2DmlRequest queryPartitions(int[] qryParts) {
        this.qryParts = qryParts;
        return this;
    }

    public GridH2DmlRequest pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public GridH2DmlRequest query(String qry) {
        this.qry = qry;
        return this;
    }

    public String query() {
        return this.qry;
    }

    public GridH2DmlRequest flags(int flags) {
        assert (flags >= 0 && flags <= 255) : flags;
        this.flags = (byte)flags;
        return this;
    }

    public boolean isFlagSet(int flags) {
        return (this.flags & flags) == flags;
    }

    public Boolean isDataPageScanEnabled() {
        return GridH2QueryRequest.isDataPageScanEnabled(this.flags);
    }

    public int timeout() {
        return this.timeout;
    }

    public GridH2DmlRequest timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public GridH2DmlRequest schemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    public boolean explicitTimeout() {
        return this.explicitTimeout;
    }

    public GridH2DmlRequest explicitTimeout(boolean explicitTimeout) {
        this.explicitTimeout = explicitTimeout;
        return this;
    }

    public void marshall(Marshaller m) {
        if (this.paramsBytes != null) {
            return;
        }
        assert (this.params != null);
        try {
            this.paramsBytes = U.marshal((Marshaller)m, (Object)this.params);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public void unmarshall(Marshaller m, GridKernalContext ctx) {
        if (this.params != null) {
            return;
        }
        assert (this.paramsBytes != null);
        try {
            ClassLoader ldr = U.resolveClassLoader((IgniteConfiguration)ctx.config());
            this.params = m instanceof BinaryMarshaller ? BinaryUtils.rawArrayFromBinary((Object)((BinaryMarshaller)m).binaryMarshaller().unmarshal(this.paramsBytes, ldr)) : (Object[])U.unmarshal((Marshaller)m, (byte[])this.paramsBytes, (ClassLoader)ldr);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeCollection("caches", this.caches, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeBoolean("explicitTimeout", this.explicitTimeout)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeInt("pageSize", this.pageSize)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeByteArray("paramsBytes", this.paramsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeString("qry", this.qry)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeIntArray("qryParts", this.qryParts)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeLong("reqId", this.reqId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeString("schemaName", this.schemaName)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeInt("timeout", this.timeout)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeMessage("topVer", (Message)this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.caches = (List)reader.readCollection("caches", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.explicitTimeout = reader.readBoolean("explicitTimeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.pageSize = reader.readInt("pageSize");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.paramsBytes = reader.readByteArray("paramsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.qry = reader.readString("qry");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.qryParts = reader.readIntArray("qryParts");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.reqId = reader.readLong("reqId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.schemaName = reader.readString("schemaName");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.timeout = reader.readInt("timeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridH2DmlRequest.class);
    }

    public short directType() {
        return -55;
    }

    public byte fieldsCount() {
        return 11;
    }

    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(GridH2DmlRequest.class, (Object)this);
    }
}

