/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.yamlinput;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.yamlinput.YamlInput;
import org.apache.hop.pipeline.transforms.yamlinput.YamlInputData;
import org.apache.hop.pipeline.transforms.yamlinput.YamlInputField;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.w3c.dom.Node;

@Transform(id="YamlInput", image="yamlinput.svg", name="i18n::YamlInput.Name", description="i18n::YamlInput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::YamlInputMeta.keyword"}, documentationUrl="/pipeline/transforms/yamlinput.html")
public class YamlInputMeta
extends BaseTransformMeta<YamlInput, YamlInputData> {
    private static final Class<?> PKG = YamlInputMeta.class;
    private static final String YES = "Y";
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    private String[] fileName;
    private String[] fileMask;
    private String[] fileRequired;
    private boolean includeFilename;
    private String filenameField;
    private boolean includeRowNumber;
    private String rowNumberField;
    private long rowLimit;
    private YamlInputField[] inputFields;
    private String encoding;
    private String yamlField;
    private boolean inFields;
    private boolean isAFile;
    private boolean addResultFile;
    private boolean validating;
    private boolean isIgnoreEmptyFile;
    private String[] includeSubFolders;
    private boolean doNotFailIfNoFile;

    public boolean addResultFile() {
        return this.addResultFile;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public void setAddResultFile(boolean addResultFile) {
        this.addResultFile = addResultFile;
    }

    public YamlInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(YamlInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String getYamlField() {
        return this.yamlField;
    }

    public void setYamlField(String yamlField) {
        this.yamlField = yamlField;
    }

    public boolean isInFields() {
        return this.inFields;
    }

    public void setInFields(boolean inFields) {
        this.inFields = inFields;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public String[] getFileRequired() {
        return this.fileRequired;
    }

    public void setFileRequired(String[] fileRequiredin) {
        for (int i = 0; i < fileRequiredin.length; ++i) {
            this.fileRequired[i] = this.getRequiredFilesCode(fileRequiredin[i]);
        }
    }

    public void setIncludeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            this.includeSubFolders[i] = this.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean includeFilename() {
        return this.includeFilename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public boolean isIgnoreEmptyFile() {
        return this.isIgnoreEmptyFile;
    }

    public void setIgnoreEmptyFile(boolean isIgnoreEmptyFile) {
        this.isIgnoreEmptyFile = isIgnoreEmptyFile;
    }

    public boolean isdoNotFailIfNoFile() {
        return this.doNotFailIfNoFile;
    }

    public void setdoNotFailIfNoFile(boolean doNotFailIfNoFile) {
        this.doNotFailIfNoFile = doNotFailIfNoFile;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean getIsAFile() {
        return this.isAFile;
    }

    public void setIsAFile(boolean isAFile) {
        this.isAFile = isAFile;
    }

    public String[] getIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Object clone() {
        YamlInputMeta retval = (YamlInputMeta)((Object)super.clone());
        int nrFiles = this.fileName.length;
        int nrFields = this.inputFields.length;
        retval.allocate(nrFiles, nrFields);
        System.arraycopy(this.fileName, 0, retval.fileName, 0, nrFiles);
        System.arraycopy(this.fileMask, 0, retval.fileMask, 0, nrFiles);
        System.arraycopy(this.fileRequired, 0, retval.fileRequired, 0, nrFiles);
        System.arraycopy(this.includeSubFolders, 0, retval.includeSubFolders, 0, nrFiles);
        for (int i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (YamlInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    public String getXml() {
        int i;
        StringBuilder retval = new StringBuilder(400);
        retval.append("    ").append(XmlHandler.addTagValue((String)"include", (boolean)this.includeFilename));
        retval.append("    ").append(XmlHandler.addTagValue((String)"include_field", (String)this.filenameField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    ").append(XmlHandler.addTagValue((String)"addresultfile", (boolean)this.addResultFile));
        retval.append("    ").append(XmlHandler.addTagValue((String)"validating", (boolean)this.validating));
        retval.append("    " + XmlHandler.addTagValue((String)"IsIgnoreEmptyFile", (boolean)this.isIgnoreEmptyFile));
        retval.append("    " + XmlHandler.addTagValue((String)"doNotFailIfNoFile", (boolean)this.doNotFailIfNoFile));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    <file>").append(Const.CR);
        for (i = 0; i < this.fileName.length; ++i) {
            retval.append("      ").append(XmlHandler.addTagValue((String)"name", (String)this.fileName[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"filemask", (String)this.fileMask[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"file_required", (String)this.fileRequired[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"include_subfolders", (String)this.includeSubFolders[i]));
        }
        retval.append("    </file>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (i = 0; i < this.inputFields.length; ++i) {
            YamlInputField field = this.inputFields[i];
            retval.append(field.getXml());
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XmlHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    ").append(XmlHandler.addTagValue((String)"IsInFields", (boolean)this.inFields));
        retval.append("    ").append(XmlHandler.addTagValue((String)"IsAFile", (boolean)this.isAFile));
        retval.append("    ").append(XmlHandler.addTagValue((String)"YamlField", (String)this.yamlField));
        return retval.toString();
    }

    public String getRequiredFilesDesc(String tt) {
        if (Utils.isEmpty((CharSequence)tt)) {
            return RequiredFilesDesc[0];
        }
        if (tt.equalsIgnoreCase(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            int i;
            this.includeFilename = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"include"));
            this.filenameField = XmlHandler.getTagValue((Node)transformNode, (String)"include_field");
            this.addResultFile = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"addresultfile"));
            this.validating = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"validating"));
            this.isIgnoreEmptyFile = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"IsIgnoreEmptyFile"));
            this.doNotFailIfNoFile = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"doNotFailIfNoFile"));
            this.includeRowNumber = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"rownum"));
            this.rowNumberField = XmlHandler.getTagValue((Node)transformNode, (String)"rownum_field");
            this.encoding = XmlHandler.getTagValue((Node)transformNode, (String)"encoding");
            Node filenode = XmlHandler.getSubNode((Node)transformNode, (String)"file");
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFiles = XmlHandler.countNodes((Node)filenode, (String)"name");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                Node filenamenode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                Node fileRequirednode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                Node includeSubFoldersnode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
                this.fileName[i] = XmlHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XmlHandler.getNodeValue((Node)filemasknode);
                this.fileRequired[i] = XmlHandler.getNodeValue((Node)fileRequirednode);
                this.includeSubFolders[i] = XmlHandler.getNodeValue((Node)includeSubFoldersnode);
            }
            for (i = 0; i < nrFields; ++i) {
                YamlInputField field;
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i] = field = new YamlInputField(fnode);
            }
            this.rowLimit = Const.toLong((String)XmlHandler.getTagValue((Node)transformNode, (String)"limit"), (long)0L);
            this.inFields = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"IsInFields"));
            this.isAFile = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"IsAFile"));
            this.yamlField = XmlHandler.getTagValue((Node)transformNode, (String)"YamlField");
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"YamlInputMeta.Exception.ErrorLoadingXml", (String[])new String[]{e.toString()}));
        }
    }

    public void allocate(int nrfiles, int nrFields) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.fileRequired = new String[nrfiles];
        this.includeSubFolders = new String[nrfiles];
        this.inputFields = new YamlInputField[nrFields];
    }

    public void setDefault() {
        int i;
        this.isIgnoreEmptyFile = false;
        this.doNotFailIfNoFile = true;
        this.includeFilename = false;
        this.filenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.isAFile = false;
        this.addResultFile = false;
        this.validating = false;
        int nrFiles = 0;
        int nrFields = 0;
        this.allocate(nrFiles, nrFields);
        for (i = 0; i < nrFiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
            this.fileRequired[i] = RequiredFilesCode[0];
            this.includeSubFolders[i] = RequiredFilesCode[0];
        }
        for (i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new YamlInputField("field" + (i + 1));
        }
        this.rowLimit = 0L;
        this.inFields = false;
        this.yamlField = "";
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaString v;
        for (int i = 0; i < this.inputFields.length; ++i) {
            IValueMeta v2;
            YamlInputField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            String valueName = variables.resolve(field.getName());
            try {
                v2 = ValueMetaFactory.createValueMeta((String)valueName, (int)type);
            }
            catch (HopPluginException e) {
                v2 = new ValueMetaString(valueName);
            }
            v2.setLength(field.getLength());
            v2.setPrecision(field.getPrecision());
            v2.setOrigin(name);
            v2.setConversionMask(field.getFormat());
            v2.setDecimalSymbol(field.getDecimalSymbol());
            v2.setGroupingSymbol(field.getGroupSymbol());
            v2.setCurrencySymbol(field.getCurrencySymbol());
            r.addValueMeta(v2);
        }
        if (this.includeFilename) {
            v = new ValueMetaString(variables.resolve(this.filenameField));
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.includeRowNumber) {
            v = new ValueMetaInteger(variables.resolve(this.rowNumberField));
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
    }

    public FileInputList getFiles(IVariables variables) {
        return FileInputList.createFileList((IVariables)variables, (String[])this.fileName, (String[])this.fileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean());
    }

    private boolean[] includeSubFolderBoolean() {
        int len = this.fileName.length;
        boolean[] includeSubFolderBoolean = new boolean[len];
        for (int i = 0; i < len; ++i) {
            includeSubFolderBoolean[i] = YES.equalsIgnoreCase(this.includeSubFolders[i]);
        }
        return includeSubFolderBoolean;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (input.length <= 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"YamlInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"YamlInputMeta.CheckResult.NoInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.getInputFields().length <= 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"YamlInputMeta.CheckResult.NoInputField", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.isInFields()) {
            if (Utils.isEmpty((CharSequence)this.getYamlField())) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"YamlInputMeta.CheckResult.NoField", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"YamlInputMeta.CheckResult.FieldOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            FileInputList fileInputList = this.getFiles(variables);
            if (fileInputList == null || fileInputList.getFiles().size() == 0) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"YamlInputMeta.CheckResult.NoFiles", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"YamlInputMeta.CheckResult.FilesOk", (String[])new String[]{"" + fileInputList.getFiles().size()}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            FileInputList fileList;
            ArrayList<String> newFilenames = new ArrayList<String>();
            if (!this.isInFields() && (fileList = this.getFiles(variables)).getFiles().size() > 0) {
                for (FileObject fileObject : fileList.getFiles()) {
                    if (!fileObject.exists()) continue;
                    newFilenames.add(fileObject.getName().getPath());
                }
                this.fileName = newFilenames.toArray(new String[newFilenames.size()]);
                this.fileMask = new String[newFilenames.size()];
                this.fileRequired = new String[newFilenames.size()];
                for (int i = 0; i < newFilenames.size(); ++i) {
                    this.fileRequired[i] = YES;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }
}

