/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import org.apache.beam.repackaged.direct_java.runners.local.StructuralKey;
import org.apache.beam.runners.direct.BundleFactory;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.DirectGraph;
import org.apache.beam.runners.direct.DirectRunner;
import org.apache.beam.runners.direct.UncommittedBundle;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.IllegalMutationException;
import org.apache.beam.sdk.util.MutationDetector;
import org.apache.beam.sdk.util.MutationDetectors;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.SetMultimap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

class ImmutabilityCheckingBundleFactory
implements BundleFactory {
    private final @UnknownKeyFor @NonNull @Initialized BundleFactory underlying;
    private final @UnknownKeyFor @NonNull @Initialized DirectGraph graph;

    public static @UnknownKeyFor @NonNull @Initialized ImmutabilityCheckingBundleFactory create(@UnknownKeyFor @NonNull @Initialized BundleFactory underlying, @UnknownKeyFor @NonNull @Initialized DirectGraph graph) {
        return new ImmutabilityCheckingBundleFactory(underlying, graph);
    }

    private ImmutabilityCheckingBundleFactory(@UnknownKeyFor @NonNull @Initialized BundleFactory underlying, @UnknownKeyFor @NonNull @Initialized DirectGraph graph) {
        this.underlying = (BundleFactory)Preconditions.checkNotNull((Object)underlying);
        this.graph = graph;
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized UncommittedBundle<T> createRootBundle() {
        return this.underlying.createRootBundle();
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized UncommittedBundle<T> createBundle(@UnknownKeyFor @NonNull @Initialized PCollection<T> output) {
        if (DirectRunner.Enforcement.IMMUTABILITY.appliesTo(output, this.graph)) {
            return new ImmutabilityEnforcingBundle<T>(this.underlying.createBundle(output));
        }
        return this.underlying.createBundle(output);
    }

    @Override
    public <K, T> @UnknownKeyFor @NonNull @Initialized UncommittedBundle<T> createKeyedBundle(@UnknownKeyFor @NonNull @Initialized StructuralKey<K> key, @UnknownKeyFor @NonNull @Initialized PCollection<T> output) {
        if (DirectRunner.Enforcement.IMMUTABILITY.appliesTo(output, this.graph)) {
            return new ImmutabilityEnforcingBundle<T>(this.underlying.createKeyedBundle(key, output));
        }
        return this.underlying.createKeyedBundle(key, output);
    }

    private class ImmutabilityEnforcingBundle<@UnknownKeyFor T>
    implements UncommittedBundle<T> {
        private final @UnknownKeyFor @NonNull @Initialized UncommittedBundle<T> underlying;
        private final @UnknownKeyFor @NonNull @Initialized SetMultimap<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>, @UnknownKeyFor @NonNull @Initialized MutationDetector> mutationDetectors;
        private @UnknownKeyFor @NonNull @Initialized Coder<T> coder;

        public ImmutabilityEnforcingBundle(UncommittedBundle<T> underlying) {
            this.underlying = underlying;
            this.mutationDetectors = HashMultimap.create();
            this.coder = this.getPCollection().getCoder();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> getPCollection() {
            return this.underlying.getPCollection();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized UncommittedBundle<T> add(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> element) {
            try {
                this.mutationDetectors.put(element, (Object)MutationDetectors.forValueWithCoder((Object)element.getValue(), this.coder));
            }
            catch (CoderException e) {
                throw new RuntimeException(e);
            }
            this.underlying.add(element);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized CommittedBundle<T> commit(@UnknownKeyFor @NonNull @Initialized Instant synchronizedProcessingTime) {
            for (MutationDetector detector : this.mutationDetectors.values()) {
                try {
                    detector.verifyUnmodified();
                }
                catch (IllegalMutationException exn) {
                    throw new IllegalMutationException(String.format("PTransform %s mutated value %s after it was output (new value was %s). Values must not be mutated in any way after being output.", ImmutabilityCheckingBundleFactory.this.graph.getProducer((PValue)this.underlying.getPCollection()).getFullName(), exn.getSavedValue(), exn.getNewValue()), exn.getSavedValue(), exn.getNewValue(), (Throwable)exn);
                }
            }
            return this.underlying.commit(synchronizedProcessingTime);
        }
    }
}

