/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.CoderTranslator;
import org.apache.beam.repackaged.direct_java.runners.core.construction.CoderTranslatorRegistrar;
import org.apache.beam.repackaged.direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SdkComponents;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableBiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CoderTranslation {
    public static final @UnknownKeyFor @NonNull @Initialized String JAVA_SERIALIZED_CODER_URN = "beam:coders:javasdk:0.1";
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized BiMap<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder>, @UnknownKeyFor @NonNull @Initialized String> KNOWN_CODER_URNS = CoderTranslation.loadCoderURNs();
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder>, @UnknownKeyFor @NonNull @Initialized CoderTranslator<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder>> KNOWN_TRANSLATORS = CoderTranslation.loadTranslators();

    private static @UnknownKeyFor @NonNull @Initialized BiMap<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder>, @UnknownKeyFor @NonNull @Initialized String> loadCoderURNs() {
        ImmutableBiMap.Builder coderUrns = ImmutableBiMap.builder();
        for (CoderTranslatorRegistrar registrar : ServiceLoader.load(CoderTranslatorRegistrar.class)) {
            coderUrns.putAll(registrar.getCoderURNs());
        }
        return coderUrns.build();
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder>, @UnknownKeyFor @NonNull @Initialized CoderTranslator<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder>> loadTranslators() {
        ImmutableMap.Builder translators = ImmutableMap.builder();
        for (CoderTranslatorRegistrar coderTranslatorRegistrar : ServiceLoader.load(CoderTranslatorRegistrar.class)) {
            translators.putAll(coderTranslatorRegistrar.getCoderTranslators());
        }
        return translators.build();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.MessageWithComponents toProto(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) throws @UnknownKeyFor @NonNull @Initialized IOException {
        SdkComponents components = SdkComponents.create();
        RunnerApi.Coder coderProto = CoderTranslation.toProto(coder, components);
        return RunnerApi.MessageWithComponents.newBuilder().setCoder(coderProto).setComponents(components.toComponents()).build();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Coder toProto(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (KNOWN_CODER_URNS.containsKey(coder.getClass())) {
            return CoderTranslation.toKnownCoder(coder, components);
        }
        return CoderTranslation.toCustomCoder(coder);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Coder toKnownCoder(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        CoderTranslator<? extends Coder> translator = KNOWN_TRANSLATORS.get(coder.getClass());
        List<String> componentIds = CoderTranslation.registerComponents(coder, translator, components);
        return RunnerApi.Coder.newBuilder().addAllComponentCoderIds(componentIds).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn((String)KNOWN_CODER_URNS.get(coder.getClass())).setPayload(ByteString.copyFrom((byte[])translator.getPayload(coder)))).build();
    }

    private static <T extends Coder<?>> @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> registerComponents(T coder, @UnknownKeyFor @NonNull @Initialized CoderTranslator<T> translator, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<String> componentIds = new ArrayList<String>();
        for (Coder<?> component : translator.getComponents(coder)) {
            componentIds.add(components.registerCoder(component));
        }
        return componentIds;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Coder toCustomCoder(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) throws @UnknownKeyFor @NonNull @Initialized IOException {
        RunnerApi.Coder.Builder coderBuilder = RunnerApi.Coder.newBuilder();
        return coderBuilder.setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(JAVA_SERIALIZED_CODER_URN).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(coder))).build()).build();
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fromProto(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Coder protoCoder, @UnknownKeyFor @NonNull @Initialized RehydratedComponents components, @UnknownKeyFor @NonNull @Initialized TranslationContext context) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String coderSpecUrn = protoCoder.getSpec().getUrn();
        if (coderSpecUrn.equals(JAVA_SERIALIZED_CODER_URN)) {
            return CoderTranslation.fromCustomCoder(protoCoder);
        }
        return CoderTranslation.fromKnownCoder(protoCoder, components, context);
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fromKnownCoder(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Coder coder, @UnknownKeyFor @NonNull @Initialized RehydratedComponents components, @UnknownKeyFor @NonNull @Initialized TranslationContext context) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String coderUrn = coder.getSpec().getUrn();
        ArrayList coderComponents = new ArrayList();
        for (String componentId : coder.getComponentCoderIdsList()) {
            Coder<?> innerCoder = context == TranslationContext.DEFAULT ? components.getCoder(componentId) : CoderTranslation.fromProto(components.getComponents().getCodersOrThrow(componentId), components, context);
            coderComponents.add(innerCoder);
        }
        Class coderType = (Class)KNOWN_CODER_URNS.inverse().get((Object)coderUrn);
        CoderTranslator<? extends Coder> translator = KNOWN_TRANSLATORS.get(coderType);
        Preconditions.checkArgument((translator != null ? 1 : 0) != 0, (String)"Unknown Coder URN %s. Known URNs: %s", (Object)coderUrn, (Object)KNOWN_CODER_URNS.values());
        return translator.fromComponents(coderComponents, coder.getSpec().getPayload().toByteArray(), context);
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fromCustomCoder(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Coder protoCoder) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return (Coder)SerializableUtils.deserializeFromByteArray((byte[])protoCoder.getSpec().getPayload().toByteArray(), (String)"Custom Coder Bytes");
    }

    private static class DefaultTranslationContext
    implements TranslationContext {
        private DefaultTranslationContext() {
        }
    }

    public static interface TranslationContext {
        public static final @UnknownKeyFor @NonNull @Initialized TranslationContext DEFAULT = new DefaultTranslationContext();
    }
}

