/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca;

import com.googlecode.jsendnsca.NagiosConfigurationException;
import com.googlecode.jsendnsca.NagiosSettings;
import com.googlecode.jsendnsca.encryption.Encryption;
import com.googlecode.jsendnsca.utils.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class NagiosSettingsFactory {
    public static NagiosSettings createSettings(File file) throws IOException, NagiosConfigurationException {
        return NagiosSettingsFactory.createSettings(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NagiosSettings createSettings(InputStream inputStream) throws IOException, NagiosConfigurationException {
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            NagiosSettings nagiosSettings = NagiosSettingsFactory.createSettings(properties);
            return nagiosSettings;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    public static NagiosSettings createSettings(Properties properties) throws NagiosConfigurationException {
        NagiosSettings settings = new NagiosSettings();
        NagiosSettingsFactory.overrideUsing(properties, settings);
        return settings;
    }

    private static void overrideUsing(Properties properties, NagiosSettings settings) throws NagiosConfigurationException {
        block8: for (PropertyKey key : PropertyKey.values()) {
            if (!key.providedIn(properties)) continue;
            String name = key.name;
            String value = NagiosSettingsFactory.getValue(properties, name);
            switch (key) {
                case HOST: {
                    settings.setNagiosHost(value);
                    continue block8;
                }
                case PORT: {
                    NagiosSettingsFactory.toPort(settings, name, value);
                    continue block8;
                }
                case PASSWORD: {
                    settings.setPassword(value);
                    continue block8;
                }
                case TIMEOUT: {
                    settings.setTimeout(NagiosSettingsFactory.toInteger(name, value));
                    continue block8;
                }
                case CONNECT_TIMEOUT: {
                    settings.setConnectTimeout(NagiosSettingsFactory.toInteger(name, value));
                    continue block8;
                }
                case ENCRYPTION: {
                    settings.setEncryption(NagiosSettingsFactory.toEncryption(value));
                }
            }
        }
    }

    private static String getValue(Properties properties, String name) throws NagiosConfigurationException {
        String value = properties.getProperty(name);
        if (StringUtils.isBlank((String)value)) {
            throw new NagiosConfigurationException("Key [%s] value cannot be empty or purely whitespace", name);
        }
        return value;
    }

    private static void toPort(NagiosSettings settings, String name, String value) throws NagiosConfigurationException {
        try {
            settings.setPort(NagiosSettingsFactory.toInteger(name, value));
        }
        catch (IllegalArgumentException e) {
            throw new NagiosConfigurationException("Key [%s] %s, was [%s]", name, e.getMessage(), value);
        }
    }

    private static Encryption toEncryption(String value) throws NagiosConfigurationException {
        try {
            return Encryption.valueOf(Encryption.class, value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new NagiosConfigurationException("Key [%s] must be one of [%s], was [foobar]", PropertyKey.ENCRYPTION.name, Encryption.supportedList().toLowerCase(), value);
        }
    }

    private static int toInteger(String name, String value) throws NagiosConfigurationException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new NagiosConfigurationException("Key [%s] must be an integer, was [%s]", name, value);
        }
    }

    public static enum PropertyKey {
        HOST("nagios.nsca.host"),
        PORT("nagios.nsca.port"),
        PASSWORD("nagios.nsca.password"),
        TIMEOUT("nagios.nsca.timeout"),
        CONNECT_TIMEOUT("nagios.nsca.connect.timeout"),
        ENCRYPTION("nagios.nsca.encryption");

        private final String name;

        private PropertyKey(String name) {
            this.name = name;
        }

        private boolean providedIn(Properties properties) {
            return properties.containsKey(this.name);
        }
    }
}

