/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.common;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSortedSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Queues;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ReflectHelpers {
    private static final @UnknownKeyFor @NonNull @Initialized Joiner COMMA_SEPARATOR = Joiner.on((String)", ");
    private static final @UnknownKeyFor @NonNull @Initialized MemberGetter<@UnknownKeyFor @NonNull @Initialized Method> GET_METHODS = Class::getDeclaredMethods;
    private static final @UnknownKeyFor @NonNull @Initialized MemberGetter<@UnknownKeyFor @NonNull @Initialized Field> GET_FIELDS = Class::getDeclaredFields;

    public static @UnknownKeyFor @NonNull @Initialized String formatMethod(@UnknownKeyFor @NonNull @Initialized Method input) {
        String parameterTypes = FluentIterable.from(Arrays.asList(input.getParameterTypes())).transform(Class::getSimpleName).join(COMMA_SEPARATOR);
        return String.format("%s(%s)", input.getName(), parameterTypes);
    }

    public static @UnknownKeyFor @NonNull @Initialized String formatMethodWithClass(@UnknownKeyFor @NonNull @Initialized Method input) {
        return String.format("%s#%s", input.getDeclaringClass().getName(), ReflectHelpers.formatMethod(input));
    }

    public static @UnknownKeyFor @NonNull @Initialized String formatAnnotation(@UnknownKeyFor @NonNull @Initialized Annotation annotation) {
        String annotationName = annotation.annotationType().getName();
        String annotationNameWithoutPackage = annotationName.substring(annotationName.lastIndexOf(46) + 1).replace('$', '.');
        String annotationToString = annotation.toString();
        String values = annotationToString.substring(annotationToString.indexOf(40));
        return String.format("%s%s", annotationNameWithoutPackage, values);
    }

    public static @UnknownKeyFor @NonNull @Initialized String simpleTypeDescription(@UnknownKeyFor @NonNull @Initialized Type input) {
        StringBuilder builder = new StringBuilder();
        ReflectHelpers.format(builder, input);
        return builder.toString();
    }

    private static void format(@UnknownKeyFor @NonNull @Initialized StringBuilder builder, @UnknownKeyFor @NonNull @Initialized Type t) {
        if (t instanceof Class) {
            ReflectHelpers.formatClass(builder, (Class)t);
        } else if (t instanceof TypeVariable) {
            ReflectHelpers.formatTypeVariable(builder, (TypeVariable)t);
        } else if (t instanceof WildcardType) {
            ReflectHelpers.formatWildcardType(builder, (WildcardType)t);
        } else if (t instanceof ParameterizedType) {
            ReflectHelpers.formatParameterizedType(builder, (ParameterizedType)t);
        } else if (t instanceof GenericArrayType) {
            ReflectHelpers.formatGenericArrayType(builder, (GenericArrayType)t);
        } else {
            builder.append(t.toString());
        }
    }

    private static void formatClass(@UnknownKeyFor @NonNull @Initialized StringBuilder builder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        builder.append(clazz.getSimpleName());
    }

    private static void formatTypeVariable(@UnknownKeyFor @NonNull @Initialized StringBuilder builder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeVariable<@UnknownKeyFor @KeyForBottom @NonNull @Initialized @NonNull @Initialized ?> t) {
        builder.append(t.getName());
    }

    private static void formatWildcardType(@UnknownKeyFor @NonNull @Initialized StringBuilder builder, @UnknownKeyFor @NonNull @Initialized WildcardType t) {
        builder.append("?");
        for (Type lowerBound : t.getLowerBounds()) {
            builder.append(" super ");
            ReflectHelpers.format(builder, lowerBound);
        }
        for (Type upperBound : t.getUpperBounds()) {
            if (Object.class.equals((Object)upperBound)) continue;
            builder.append(" extends ");
            ReflectHelpers.format(builder, upperBound);
        }
    }

    private static void formatParameterizedType(@UnknownKeyFor @NonNull @Initialized StringBuilder builder, @UnknownKeyFor @NonNull @Initialized ParameterizedType t) {
        if (t.getOwnerType() != null) {
            ReflectHelpers.format(builder, t.getOwnerType());
            builder.append('.');
        }
        ReflectHelpers.format(builder, t.getRawType());
        if (t.getActualTypeArguments().length > 0) {
            builder.append('<');
            COMMA_SEPARATOR.appendTo(builder, (Iterable)FluentIterable.from(Arrays.asList(t.getActualTypeArguments())).transform(ReflectHelpers::simpleTypeDescription));
            builder.append('>');
        }
    }

    private static void formatGenericArrayType(@UnknownKeyFor @NonNull @Initialized StringBuilder builder, @UnknownKeyFor @NonNull @Initialized GenericArrayType t) {
        ReflectHelpers.format(builder, t.getGenericComponentType());
        builder.append("[]");
    }

    public static @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Method> getClosureOfMethodsOnInterfaces(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> interfaces) {
        return FluentIterable.from(interfaces).transformAndConcat(ReflectHelpers::getClosureOfMethodsOnInterface);
    }

    public static @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Method> getClosureOfMethodsOnInterface(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> iface) {
        Preconditions.checkNotNull(iface);
        Preconditions.checkArgument((boolean)iface.isInterface());
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ArrayDeque interfacesToProcess = Queues.newArrayDeque();
        interfacesToProcess.add(iface);
        while (!interfacesToProcess.isEmpty()) {
            Class current = (Class)interfacesToProcess.remove();
            builder.add((Object[])current.getMethods());
            interfacesToProcess.addAll(Arrays.asList(current.getInterfaces()));
        }
        return builder.build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Iterable<T> loadServicesOrdered(@UnknownKeyFor @NonNull @Initialized Class<T> iface, @UnknownKeyFor @NonNull @Initialized ClassLoader classLoader) {
        ServiceLoader<T> loader = ServiceLoader.load(iface, classLoader);
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder((Comparator)ObjectsClassComparator.INSTANCE);
        builder.addAll(loader);
        return builder.build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Iterable<T> loadServicesOrdered(@UnknownKeyFor @NonNull @Initialized Class<T> iface) {
        return ReflectHelpers.loadServicesOrdered(iface, ReflectHelpers.findClassLoader());
    }

    public static @UnknownKeyFor @NonNull @Initialized ClassLoader findClassLoader(@UnknownKeyFor @NonNull @Initialized ClassLoader proposed) {
        ClassLoader classLoader = proposed;
        if (classLoader == null) {
            classLoader = ReflectHelpers.class.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static @UnknownKeyFor @NonNull @Initialized ClassLoader findClassLoader(Class<?> ... classes) {
        if (classes == null || classes.length == 0) {
            throw new IllegalArgumentException("set of classes can't be null");
        }
        ClassLoader current = null;
        for (Class<?> clazz : classes) {
            ClassLoader proposed = clazz.getClassLoader();
            if (proposed == null) continue;
            if (current == null) {
                current = proposed;
                continue;
            }
            if (proposed == current || !ReflectHelpers.isParent(current, proposed)) continue;
            current = proposed;
        }
        return current == null ? ClassLoader.getSystemClassLoader() : current;
    }

    public static @UnknownKeyFor @NonNull @Initialized ClassLoader findClassLoader() {
        return ReflectHelpers.findClassLoader(Thread.currentThread().getContextClassLoader());
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isParent(@UnknownKeyFor @NonNull @Initialized ClassLoader current, @UnknownKeyFor @NonNull @Initialized ClassLoader proposed) {
        ArrayList<ClassLoader> visited = new ArrayList<ClassLoader>();
        for (ClassLoader it = proposed.getParent(); it != null; it = it.getParent()) {
            if (it == current) {
                return true;
            }
            if (visited.contains(it)) {
                return false;
            }
            visited.add(it);
        }
        return false;
    }

    public static @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Method> declaredMethodsWithAnnotation(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Annotation> anno, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> startClass, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> stopClass) {
        return ReflectHelpers.declaredMembersWithAnnotation(anno, startClass, stopClass, GET_METHODS);
    }

    public static @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Field> declaredFieldsWithAnnotation(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Annotation> anno, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> startClass, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> stopClass) {
        return ReflectHelpers.declaredMembersWithAnnotation(anno, startClass, stopClass, GET_FIELDS);
    }

    private static <MemberT extends AnnotatedElement> @UnknownKeyFor @NonNull @Initialized Collection<MemberT> declaredMembersWithAnnotation(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Annotation> anno, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> startClass, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> stopClass, @UnknownKeyFor @NonNull @Initialized MemberGetter<MemberT> getter) {
        ArrayList<AnnotatedElement> matches = new ArrayList<AnnotatedElement>();
        LinkedHashSet interfaces = new LinkedHashSet();
        for (Class<?> clazz = startClass; clazz != null && !clazz.equals(stopClass); clazz = clazz.getSuperclass()) {
            for (AnnotatedElement member : (AnnotatedElement[])getter.getMembers(clazz)) {
                if (!member.isAnnotationPresent(anno)) continue;
                matches.add(member);
            }
            for (TypeDescriptor typeDescriptor : TypeDescriptor.of(clazz).getInterfaces()) {
                interfaces.add(typeDescriptor.getRawType());
            }
        }
        for (Class clazz : interfaces) {
            for (AnnotatedElement member : (AnnotatedElement[])getter.getMembers(clazz)) {
                if (!member.isAnnotationPresent(anno)) continue;
                matches.add(member);
            }
        }
        return matches;
    }

    private static interface MemberGetter<@UnknownKeyFor MemberT> {
        public MemberT @UnknownKeyFor @NonNull @Initialized [] getMembers(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);
    }

    public static class ObjectsClassComparator
    implements Comparator<Object> {
        public static final @UnknownKeyFor @NonNull @Initialized ObjectsClassComparator INSTANCE = new ObjectsClassComparator();

        @Override
        public @UnknownKeyFor @NonNull @Initialized int compare(@UnknownKeyFor @NonNull @Initialized Object o1, @UnknownKeyFor @NonNull @Initialized Object o2) {
            return o1.getClass().getCanonicalName().compareTo(o2.getClass().getCanonicalName());
        }
    }
}

