/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class ShardedKey<@UnknownKeyFor K> {
    private final K key;
    private final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] shardId;

    protected ShardedKey(K key, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] shardId) {
        this.key = key;
        this.shardId = shardId;
    }

    public static <K> @UnknownKeyFor @NonNull @Initialized ShardedKey<K> of(K key, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] shardId) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key should not be null!");
        Preconditions.checkArgument((shardId != null ? 1 : 0) != 0, (Object)"Shard id should not be null!");
        return new ShardedKey<K>(key, shardId);
    }

    public K getKey() {
        return this.key;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "ShardedKey{key=" + this.key + ", shardId=" + Arrays.toString(this.shardId) + "}";
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@UnknownKeyFor @NonNull @Initialized Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ShardedKey) {
            ShardedKey that = (ShardedKey)o;
            return this.key.equals(that.key) && Arrays.equals(this.shardId, that.shardId);
        }
        return false;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        int hash = 1;
        hash *= 1000003;
        hash ^= this.key.hashCode();
        hash *= 1000003;
        return hash ^= Arrays.hashCode(this.shardId);
    }

    public static class Coder<@UnknownKeyFor K>
    extends StructuredCoder<ShardedKey<K>> {
        private final @UnknownKeyFor @NonNull @Initialized ByteArrayCoder shardCoder = ByteArrayCoder.of();
        private final @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<K> keyCoder;

        private Coder(@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<K> coder) {
            this.keyCoder = coder;
        }

        public static <K> @UnknownKeyFor @NonNull @Initialized Coder<K> of(@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<K> keyCoder) {
            return new Coder<K>(keyCoder);
        }

        public @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<K> getKeyCoder() {
            return this.keyCoder;
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized ShardedKey<K> shardedKey, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.shardCoder.encode(((ShardedKey)shardedKey).shardId, outStream);
            this.keyCoder.encode(((ShardedKey)shardedKey).key, outStream);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ShardedKey<K> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            byte[] shardId = this.shardCoder.decode(inStream);
            K key = this.keyCoder.decode(inStream);
            return ShardedKey.of(key, shardId);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Collections.singletonList(this.keyCoder);
        }

        @Override
        public void verifyDeterministic() throws  @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            Coder.verifyDeterministic(this, "Key coder must be deterministic", this.keyCoder);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
            return this.keyCoder.consistentWithEquals();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized ShardedKey<K> shardedKey) {
            return this.shardCoder.isRegisterByteSizeObserverCheap(((ShardedKey)shardedKey).shardId) && this.keyCoder.isRegisterByteSizeObserverCheap(((ShardedKey)shardedKey).key);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object structuralValue(@UnknownKeyFor @NonNull @Initialized ShardedKey<K> shardedKey) {
            return ShardedKey.of(this.keyCoder.structuralValue(((ShardedKey)shardedKey).key), ((ShardedKey)shardedKey).shardId);
        }

        @Override
        public void registerByteSizeObserver(@UnknownKeyFor @NonNull @Initialized ShardedKey<K> shardedKey, @UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver observer) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.shardCoder.registerByteSizeObserver(((ShardedKey)shardedKey).shardId, observer);
            this.keyCoder.registerByteSizeObserver(((ShardedKey)shardedKey).key, observer);
        }
    }
}

