/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.io;

import com.google.api.core.InternalApi;
import com.google.common.annotations.VisibleForTesting;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

@InternalApi(value="For internal usage only")
public class HeaderInterceptor
implements ClientInterceptor {
    private final Metadata.Key<String> key;
    private final String defaultValue;

    public HeaderInterceptor(Metadata.Key<String> key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ClientInterceptors.CheckedForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            protected void checkedStart(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                HeaderInterceptor.this.updateHeaders(headers);
                this.delegate().start(responseListener, headers);
            }
        };
    }

    @VisibleForTesting
    public void updateHeaders(Metadata headers) {
        if (!headers.containsKey(this.key)) {
            headers.put(this.key, (Object)this.defaultValue);
        }
    }

    public String toString() {
        return String.format("%s: (key='%s' value='%s')", this.getClass().getName(), this.key.name(), this.defaultValue);
    }
}

