/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.io;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import com.google.cloud.bigtable.metrics.Counter;
import com.google.cloud.bigtable.metrics.Meter;
import com.google.cloud.bigtable.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptors;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

@InternalApi(value="For internal usage only")
public class ChannelPool
extends ManagedChannel {
    protected static final Logger LOG = new Logger(ChannelPool.class);
    private static final Metadata.Key<String> CHANNEL_ID_KEY = Metadata.Key.of((String)"bigtable-channel-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final AtomicInteger ChannelIdGenerator = new AtomicInteger();
    protected static Stats STATS;
    private final ImmutableList<ManagedChannel> channels;
    private final AtomicInteger requestCount = new AtomicInteger();
    private final String authority;
    private boolean shutdown = false;

    @InternalApi(value="For internal usage only")
    public static final String extractIdentifier(Metadata trailers) {
        return trailers != null ? (String)trailers.get(CHANNEL_ID_KEY) : "";
    }

    protected static synchronized Stats getStats() {
        if (STATS == null) {
            STATS = new Stats();
        }
        return STATS;
    }

    public ChannelPool(ChannelFactory factory, int count) throws IOException {
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Channel count has to be a positive number.");
        ImmutableList.Builder channelListBuilder = ImmutableList.builder();
        for (int i = 0; i < count; ++i) {
            channelListBuilder.add((Object)new InstrumentedChannel(factory.create()));
        }
        this.channels = channelListBuilder.build();
        this.authority = ((ManagedChannel)this.channels.get(0)).authority();
    }

    private ManagedChannel getNextChannel() {
        int currentRequestNum = this.requestCount.getAndIncrement();
        int index = Math.abs(currentRequestNum % this.channels.size());
        return (ManagedChannel)this.channels.get(index);
    }

    public String authority() {
        return this.authority;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions) {
        Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"Cannot perform operations on a closed connection");
        return this.getNextChannel().newCall(methodDescriptor, callOptions);
    }

    public int size() {
        return this.channels.size();
    }

    public synchronized ManagedChannel shutdown() {
        for (ManagedChannel channelWrapper : this.channels) {
            channelWrapper.shutdown();
        }
        this.shutdown = true;
        return this;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public boolean isTerminated() {
        for (ManagedChannel channel : this.channels) {
            if (channel.isTerminated()) continue;
            return false;
        }
        return true;
    }

    public ManagedChannel shutdownNow() {
        for (ManagedChannel channel : this.channels) {
            if (channel.isTerminated()) continue;
            channel.shutdownNow();
        }
        return this;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long endTimeNanos = System.nanoTime() + unit.toNanos(timeout);
        for (ManagedChannel channel : this.channels) {
            if (channel.isTerminated()) continue;
            long awaitTimeNanos = endTimeNanos - System.nanoTime();
            if (awaitTimeNanos <= 0L) break;
            channel.awaitTermination(awaitTimeNanos, TimeUnit.NANOSECONDS);
        }
        return this.isTerminated();
    }

    private class InstrumentedChannel
    extends ManagedChannel {
        private final ManagedChannel delegate;
        private final Timer timer;
        private final AtomicBoolean active = new AtomicBoolean(true);
        private final int channelId;

        public InstrumentedChannel(ManagedChannel channel) {
            this.delegate = channel;
            this.channelId = ChannelIdGenerator.incrementAndGet();
            this.timer = BigtableClientMetrics.timer((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Trace, (String)("channels.channel" + this.channelId + ".rpc.latency"));
            ChannelPool.getStats().ACTIVE_CHANNEL_COUNTER.inc();
        }

        private synchronized void markInactive() {
            boolean previouslyActive = this.active.getAndSet(false);
            if (previouslyActive) {
                ChannelPool.getStats().ACTIVE_CHANNEL_COUNTER.dec();
            }
        }

        public ManagedChannel shutdown() {
            this.markInactive();
            return this.delegate.shutdown();
        }

        public boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        public boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        public ManagedChannel shutdownNow() {
            this.markInactive();
            return this.delegate.shutdownNow();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            this.markInactive();
            return this.delegate.awaitTermination(timeout, unit);
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions) {
            final Timer.Context timerContext = this.timer.time();
            final AtomicBoolean decremented = new AtomicBoolean(false);
            return new ClientInterceptors.CheckedForwardingClientCall<ReqT, RespT>(this.delegate.newCall(methodDescriptor, callOptions)){

                protected void checkedStart(ClientCall.Listener<RespT> responseListener, Metadata headers) throws Exception {
                    ClientCall.Listener timingListener = InstrumentedChannel.this.wrap(responseListener, timerContext, decremented);
                    ChannelPool.getStats().ACTIVE_RPC_COUNTER.inc();
                    ChannelPool.getStats().RPC_METER.mark();
                    this.delegate().start(timingListener, headers);
                }

                public void cancel(String message, Throwable cause) {
                    if (!decremented.getAndSet(true)) {
                        ChannelPool.getStats().ACTIVE_RPC_COUNTER.dec();
                    }
                    super.cancel(message, cause);
                }
            };
        }

        protected <RespT> ClientCall.Listener<RespT> wrap(final ClientCall.Listener<RespT> delegate, final Timer.Context timeContext, final AtomicBoolean decremented) {
            return new ClientCall.Listener<RespT>(){

                public void onHeaders(Metadata headers) {
                    delegate.onHeaders(headers);
                }

                public void onMessage(RespT message) {
                    delegate.onMessage(message);
                }

                public void onClose(Status status, Metadata trailers) {
                    try {
                        if (trailers != null) {
                            trailers.put(CHANNEL_ID_KEY, (Object)String.format("{cbt:%d,grpc:%s}", InstrumentedChannel.this.channelId, InstrumentedChannel.this.delegate));
                        }
                        if (!decremented.getAndSet(true)) {
                            ChannelPool.getStats().ACTIVE_RPC_COUNTER.dec();
                        }
                        if (!status.isOk()) {
                            BigtableClientMetrics.meter((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Info, (String)("grpc.errors." + status.getCode().name())).mark();
                        }
                        delegate.onClose(status, trailers);
                    }
                    finally {
                        timeContext.close();
                    }
                }

                public void onReady() {
                    delegate.onReady();
                }
            };
        }

        public String authority() {
            return this.delegate.authority();
        }
    }

    private static class Stats {
        Counter ACTIVE_CHANNEL_COUNTER = BigtableClientMetrics.counter((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Info, (String)"grpc.channel.active");
        Counter ACTIVE_RPC_COUNTER = BigtableClientMetrics.counter((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Info, (String)"grpc.rpc.active");
        Meter RPC_METER = BigtableClientMetrics.meter((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Info, (String)"grpc.rpc.performed");

        private Stats() {
        }
    }

    public static interface ChannelFactory {
        public ManagedChannel create() throws IOException;
    }
}

