/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.grpc.async.ResourceLimiter;
import com.google.common.base.Preconditions;
import com.google.protobuf.MessageLite;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.concurrent.CancellationException;
import javax.annotation.Nullable;

@InternalApi(value="For internal usage only")
public class ThrottlingClientInterceptor
implements ClientInterceptor {
    private final ResourceLimiter resourceLimiter;

    public ThrottlingClientInterceptor(ResourceLimiter resourceLimiter) {
        Preconditions.checkNotNull((Object)resourceLimiter);
        this.resourceLimiter = resourceLimiter;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, final CallOptions callOptions, final Channel delegateChannel) {
        if (this.resourceLimiter == null) {
            return delegateChannel.newCall(method, callOptions);
        }
        return new ClientCall<ReqT, RespT>(){
            private boolean cancelledEarly;
            private ClientCall.Listener<RespT> delegateListener = null;
            private ClientCall<ReqT, RespT> delegateCall;
            private Metadata headers;
            private int numMessagesRequested = 0;
            private Long id = null;

            public void start(ClientCall.Listener<RespT> listener, Metadata headers) {
                Preconditions.checkState((!this.cancelledEarly ? 1 : 0) != 0, (Object)"Call already cancelled");
                Preconditions.checkState((this.delegateListener == null && this.headers == null ? 1 : 0) != 0, (Object)"Call already started");
                this.delegateListener = (ClientCall.Listener)Preconditions.checkNotNull(listener);
                this.headers = (Metadata)Preconditions.checkNotNull((Object)headers);
            }

            public void request(int numMessages) {
                if (this.delegateCall != null) {
                    this.delegateCall.request(numMessages);
                    return;
                }
                Preconditions.checkState((!this.cancelledEarly ? 1 : 0) != 0, (Object)"Call already cancelled");
                this.numMessagesRequested += numMessages;
            }

            public void cancel(@Nullable String message, @Nullable Throwable cause) {
                if (this.delegateCall != null) {
                    this.delegateCall.cancel(message, cause);
                    return;
                }
                this.cancelledEarly = true;
                if (message == null && cause == null) {
                    cause = new CancellationException("Cancelled without a message or cause");
                }
                if (this.delegateListener != null) {
                    this.delegateListener.onClose(Status.CANCELLED.withDescription(message).withCause(cause), new Metadata());
                }
            }

            public void sendMessage(ReqT message) {
                Preconditions.checkState((this.delegateCall == null ? 1 : 0) != 0, (Object)"ThrottlingClientInterceptor only supports unary operations");
                Preconditions.checkState((this.delegateListener != null && this.headers != null ? 1 : 0) != 0, (Object)"start() has to be called before sendMessage().");
                Preconditions.checkState((!this.cancelledEarly ? 1 : 0) != 0, (Object)"Call already cancelled");
                try {
                    this.id = ThrottlingClientInterceptor.this.resourceLimiter.registerOperationWithHeapSize(((MessageLite)message).getSerializedSize());
                }
                catch (InterruptedException e) {
                    this.delegateListener.onClose(Status.INTERNAL.withDescription("Operation was interrupted"), new Metadata());
                    return;
                }
                this.delegateCall = delegateChannel.newCall(method, callOptions);
                ForwardingClientCallListener.SimpleForwardingClientCallListener markCompletionListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(this.delegateListener){

                    public void onClose(Status status, Metadata trailers) {
                        ThrottlingClientInterceptor.this.resourceLimiter.markCanBeCompleted(id);
                        this.delegate().onClose(status, trailers);
                    }
                };
                this.delegateCall.start((ClientCall.Listener)markCompletionListener, this.headers);
                this.delegateCall.request(this.numMessagesRequested);
                this.delegateCall.sendMessage(message);
                this.delegateCall.halfClose();
            }

            public void halfClose() {
            }
        };
    }
}

