/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.util;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.UnsignedBytes;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class ByteArray
implements Serializable,
Comparable<ByteArray> {
    private final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] value;

    public ByteArray(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] value) {
        this.value = value;
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getValue() {
        return this.value;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArray byteArray = (ByteArray)o;
        return Arrays.equals(this.value, byteArray.value);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.value != null ? Arrays.hashCode(this.value) : 0;
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized int compareTo(@UnknownKeyFor @NonNull @Initialized ByteArray other) {
        return UnsignedBytes.lexicographicalComparator().compare(this.value, other.value);
    }
}

