/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation;

import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Throwables;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.ExplainMode;
import org.apache.spark.util.Utils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class EvaluationContext {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(EvaluationContext.class);
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized NamedDataset<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?>> leaves;
    private final @UnknownKeyFor @NonNull @Initialized SparkSession session;

    EvaluationContext(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized NamedDataset<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?>> leaves, @UnknownKeyFor @NonNull @Initialized SparkSession session) {
        this.leaves = leaves;
        this.session = session;
    }

    public void evaluate() {
        for (NamedDataset<?> ds : this.leaves) {
            Dataset<WindowedValue<?>> dataset = ds.dataset();
            if (dataset == null) continue;
            if (LOG.isDebugEnabled()) {
                ExplainMode explainMode = ExplainMode.fromString((String)"simple");
                String execPlan = dataset.queryExecution().explainString(explainMode);
                LOG.debug("Evaluating dataset {}:\n{}", (Object)ds.name(), (Object)execPlan);
            }
            EvaluationContext.evaluate(ds.name(), dataset);
        }
    }

    public static <T> void evaluate(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Dataset<T> ds) {
        long startMs = System.currentTimeMillis();
        try {
            ds.write().mode("overwrite").format("noop").save();
            LOG.info("Evaluated dataset {} in {}", (Object)name, (Object)EvaluationContext.durationSince(startMs));
        }
        catch (RuntimeException e) {
            LOG.error("Failed to evaluate dataset {}: {}", (Object)name, (Object)Throwables.getRootCause((Throwable)e).getMessage());
            throw new RuntimeException(e);
        }
    }

    public static <T> T @UnknownKeyFor @NonNull @Initialized [] collect(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Dataset<T> ds) {
        long startMs = System.currentTimeMillis();
        try {
            Object[] res = (Object[])ds.collect();
            LOG.info("Collected dataset {} in {} [size: {}]", new Object[]{name, EvaluationContext.durationSince(startMs), res.length});
            return res;
        }
        catch (Exception e) {
            LOG.error("Failed to collect dataset {}: {}", (Object)name, (Object)Throwables.getRootCause((Throwable)e).getMessage());
            throw new RuntimeException(e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized SparkSession getSparkSession() {
        return this.session;
    }

    private static @UnknownKeyFor @NonNull @Initialized String durationSince(@UnknownKeyFor @NonNull @Initialized long startMs) {
        return Utils.msDurationToString((long)(System.currentTimeMillis() - startMs));
    }

    static interface NamedDataset<@UnknownKeyFor T> {
        public @UnknownKeyFor @NonNull @Initialized String name();

        @Nullable
        public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> dataset();
    }
}

